/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj.test;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.data.Tag;
import org.mydragonfly.pj.service.JournalService;

public class JournalTest {
    private static Configuration config = new Configuration();
    private static SessionFactory sessionFactory;

    protected static org.hibernate.Session getSession() {
        return sessionFactory.openSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Journal> getAllJournals(SessionFactory sessionFactory) {
        Session session = sessionFactory.openSession();
        List list = null;
        try {
            Query query = session.createQuery("from Journal as journal");
            list = query.list();
            Hibernate.initialize((Object)list);
        }
        finally {
            session.close();
        }
        return list;
    }

    public void createEntryTest(org.hibernate.Session session) throws Exception {
        Transaction transaction = null;
        List<Journal> list = JournalService.getJournals();
        try {
            transaction = session.beginTransaction();
            if (list.size() > 0) {
                Journal journal = list.get(0);
                HashSet<Tag> hashSet = new HashSet<Tag>();
                hashSet.add(new Tag("Test"));
                hashSet.add(new Tag("someTag"));
                Entry entry = new Entry(journal, new Date(), false, "My first test entry", "Some technical content.. blah blah..", hashSet);
                journal.getEntries().add(entry);
                session.persist((Object)entry);
                transaction.commit();
            } else {
                System.out.println("No Journals found, cant add Entry!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createJournalTest(SessionFactory sessionFactory) throws Exception {
        Session session = sessionFactory.openSession();
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            Journal journal = new Journal("Linux Notes", "password", new Date(), null);
            session.save((Object)journal);
            journal = new Journal("Personal", "password", new Date(), null);
            session.save((Object)journal);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new Exception("Transaction failed", exception);
        }
        finally {
            session.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Journal journal = new Journal("New Add Jnl", "secret", new Date(), null);
        HashSet<Tag> hashSet = new HashSet<Tag>();
        hashSet.add(new Tag("Test"));
        hashSet.add(new Tag("someTag"));
        Entry entry = new Entry(journal, new Date(), false, "My first test entry", "Some technical content.. blah blah..", null);
        HashSet<Entry> hashSet2 = new HashSet<Entry>();
        hashSet2.add(entry);
        journal.setEntries(hashSet2);
        JournalService.saveJournal(journal);
        List<Journal> list = JournalService.getJournals();
        System.out.println("List all journals....");
        for (Journal journal2 : list) {
            System.out.println("Journal id=" + journal2.getId() + " title=" + journal2.getTitle() + " pswd=" + journal2.getPassword() + "entries" + journal2.getEntries());
            for (Entry entry2 : journal2.getEntries()) {
                System.out.println("\t[Entry] id=" + entry2.getId() + " date=" + entry2.getCreateDate() + " private=" + entry2.getPrivateEntry() + " desc=" + entry2.getDescription());
            }
        }
    }

    static {
        config.configure();
        sessionFactory = config.buildSessionFactory();
    }
}

