/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.event.DefaultWordFinder;
import com.swabunga.spell.event.Word;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordNotFoundException;
import com.swabunga.spell.event.WordTokenizer;
import java.text.BreakIterator;

public abstract class AbstractWordTokenizer
implements WordTokenizer {
    protected Word currentWord;
    protected WordFinder finder;
    protected BreakIterator sentenceIterator;
    protected int wordCount = 0;

    public AbstractWordTokenizer(String text) {
        this(new DefaultWordFinder(text));
    }

    public AbstractWordTokenizer(WordFinder wf) {
        this.finder = wf;
    }

    @Override
    public int getCurrentWordCount() {
        return this.wordCount;
    }

    @Override
    public int getCurrentWordEnd() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.currentWord.getEnd();
    }

    @Override
    public int getCurrentWordPosition() {
        if (this.currentWord == null) {
            throw new WordNotFoundException("No Words in current String");
        }
        return this.currentWord.getStart();
    }

    @Override
    public boolean hasMoreWords() {
        return this.finder.hasNext();
    }

    @Override
    public String nextWord() {
        this.currentWord = this.finder.next();
        return this.currentWord.getText();
    }

    @Override
    public abstract void replaceWord(String var1);

    @Override
    public String getContext() {
        return this.finder.toString();
    }

    @Override
    public boolean isNewSentence() {
        return this.finder.startsSentence();
    }
}

