/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.infocardOrganizer;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.infoml.infocardOrganizer.AncestorDialog;
import org.infoml.infocardOrganizer.InfocardBuilder;
import org.infoml.infocardOrganizer.Main;
import org.infoml.infocardOrganizer.MainFrame;
import org.infoml.infocardOrganizer.MyBorder;
import org.infoml.infocardOrganizer.MyDocumentListener;
import org.infoml.infocardOrganizer.NotecardModel;
import org.infoml.infocardOrganizer.SetupInformationDialog2;
import org.infoml.jaxb.InfomlType;

public class NotecardDialog
extends AncestorDialog {
    MyBorder myBorder;
    MainFrame mainFr;
    Main infomlFile;
    InfocardBuilder infocardBuilder;
    private int preferredWidth = 0;
    private boolean visible = false;
    JPanel mainPanel;
    JPanel sPanel;
    private int titleHeight;
    private int contentHeight;
    private int keywordsHeight;
    private int notes1Height;
    public boolean titleField = false;
    public boolean contentField = false;
    public boolean keywordsField = false;
    public boolean notes1Field = false;
    public boolean notes2Field = false;
    NotecardModel model;
    JTextField title;
    JTextArea keywords;
    JTextArea content;
    JTextArea notes2;
    JTextArea notes1;
    JButton moreFields;
    JButton create;
    JButton cancel;
    Document titleDoc;
    Document contentDoc;
    Document keywordsDoc;
    Document notes1Doc;
    Document notes2Doc;
    boolean edit;
    JScrollPane scrollPane1;

    public NotecardDialog(Frame owner, String title, NotecardModel model, InfocardBuilder infocardBuilder, MainFrame mainFr, boolean edit) {
        super(owner, title, mainFr);
        this.setAlwaysOnTop(false);
        this.model = model;
        this.infocardBuilder = infocardBuilder;
        infocardBuilder.model = model;
        this.mainFr = mainFr;
        this.infomlFile = mainFr.infomlFile;
        this.myBorder = new MyBorder();
        this.edit = edit;
        this.mainPanel = new JPanel(new BorderLayout(0, 10));
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.setBorder(this.createBorder());
        this.mainPanel.add((Component)this.createNorthPanel(), "North");
        this.sPanel = this.createSouthPanel();
        this.mainPanel.add((Component)this.sPanel, "South");
        this.mainPanel.add((Component)this.createCenterPanel(), "Center");
        this.ownUndoManager.discardAllEdits();
        this.setFocusVector();
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public Border createBorder() {
        TitledBorder inner = BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "   Notecard   ");
        CompoundBorder cb = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(20, 15, 15, 15), inner);
        return cb;
    }

    public void makeTitleTextField(JPanel parent) {
        JPanel intermediar = new JPanel(new GridLayout());
        intermediar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.title = new JTextField(40);
        this.title.addCaretListener(this.mainFr.caretListener);
        this.title.addFocusListener(this.mainFr.focusListener);
        if (this.edit && !this.model.getTitle().equals("No title")) {
            this.title.setText(this.model.getTitle());
        }
        MyDocumentListener listener = new MyDocumentListener(this, this.model, "title");
        this.titleDoc = this.title.getDocument();
        this.titleDoc.addDocumentListener(listener);
        this.titleDoc.addUndoableEditListener(this.ownUndoListener);
        intermediar.add(this.title);
        parent.add(intermediar);
        this.title.setBorder(BorderFactory.createLoweredBevelBorder());
        this.titleHeight = intermediar.getPreferredSize().height;
        intermediar.setMaximumSize(new Dimension(600, intermediar.getPreferredSize().height));
        intermediar.setMinimumSize(new Dimension(300, intermediar.getPreferredSize().height));
    }

    public void makeContentTextArea(JPanel parent) {
        this.content = new JTextArea(14, 50);
        this.contentDoc = this.content.getDocument();
        this.content.setLineWrap(true);
        this.content.setWrapStyleWord(true);
        NotecardDialog.invertFocusTraversalBehaviour(this.content);
        this.content.addCaretListener(this.mainFr.caretListener);
        this.content.addFocusListener(this.mainFr.focusListener);
        MyDocumentListener listener1 = new MyDocumentListener(this, this.model, new String("content"));
        this.contentDoc.addDocumentListener(listener1);
        this.contentDoc.addUndoableEditListener(this.ownUndoListener);
        if (this.edit) {
            this.content.setText(this.model.getContentString());
        }
        JScrollPane scrollPane1 = new JScrollPane(this.content, 20, 31);
        scrollPane1.setBorder(this.myBorder.getBorder());
        scrollPane1.setMaximumSize(new Dimension(600, scrollPane1.getPreferredSize().height));
        scrollPane1.setMinimumSize(new Dimension(300, scrollPane1.getPreferredSize().height));
        parent.add(scrollPane1);
        this.contentHeight = scrollPane1.getPreferredSize().height;
    }

    public void makeKeywordsTextArea(JPanel parent) {
        this.keywords = new JTextArea(3, 40);
        this.keywords.setLineWrap(true);
        this.keywords.setWrapStyleWord(true);
        NotecardDialog.invertFocusTraversalBehaviour(this.keywords);
        this.keywords.addFocusListener(this.mainFr.focusListener);
        this.keywords.addCaretListener(this.mainFr.caretListener);
        this.keywordsDoc = this.keywords.getDocument();
        MyDocumentListener listener2 = new MyDocumentListener(this, this.model, new String("keywords"));
        this.keywordsDoc.addDocumentListener(listener2);
        this.keywordsDoc.addUndoableEditListener(this.ownUndoListener);
        if (this.edit) {
            this.keywords.setText(this.model.getSelectorsString());
        }
        JScrollPane scrollPane2 = new JScrollPane(this.keywords, 20, 31);
        scrollPane2.setBorder(this.myBorder.getBorder());
        parent.add(scrollPane2);
        this.keywordsHeight = scrollPane2.getPreferredSize().height;
    }

    public void makeNotes1TextArea(JPanel parent) {
        this.notes1 = new JTextArea(4, 40);
        this.notes1.setLineWrap(true);
        this.notes1.setWrapStyleWord(true);
        NotecardDialog.invertFocusTraversalBehaviour(this.notes1);
        this.notes1.addFocusListener(this.mainFr.focusListener);
        this.notes1.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            this.notes1.setText(this.model.getNotes1String());
        }
        this.notes1Doc = this.notes1.getDocument();
        MyDocumentListener listener3 = new MyDocumentListener(this, this.model, new String("notes1"));
        this.notes1Doc.addDocumentListener(listener3);
        this.notes1Doc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane scrollPane3 = new JScrollPane(this.notes1, 20, 31);
        scrollPane3.setBorder(this.myBorder.getBorder());
        parent.add(scrollPane3);
        this.notes1Height = scrollPane3.getPreferredSize().height;
    }

    public void makeTitleLabel(JPanel parent) {
        JPanel panelA = new JPanel();
        JLabel titleL = new JLabel(" Title ");
        panelA.add(titleL);
        panelA.setPreferredSize(new Dimension(titleL.getPreferredSize().width, this.titleHeight));
        parent.add(panelA);
        if (titleL.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = titleL.getPreferredSize().width;
        }
    }

    public void makeContentLabel(JPanel parent) {
        JPanel panelB = new JPanel();
        JLabel contentL = new JLabel(" Content ");
        panelB.add(contentL);
        contentL.setPreferredSize(new Dimension(contentL.getPreferredSize().width, this.contentHeight));
        parent.add(panelB);
        if (contentL.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = contentL.getPreferredSize().width;
        }
    }

    public void makeKeywordsLabel(JPanel parent) {
        JPanel panelC = new JPanel();
        JLabel keywordsL = new JLabel("   Tags   ");
        panelC.add(keywordsL);
        keywordsL.setPreferredSize(new Dimension(keywordsL.getPreferredSize().width, this.keywordsHeight));
        parent.add(panelC);
        if (keywordsL.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = keywordsL.getPreferredSize().width;
        }
    }

    public void makeNotes1Label(JPanel parent) {
        JPanel panelD = new JPanel();
        JLabel notes1L = new JLabel(" Notes1 ");
        panelD.add(notes1L);
        notes1L.setPreferredSize(new Dimension(notes1L.getPreferredSize().width, this.notes1Height));
        parent.add(panelD);
        if (notes1L.getPreferredSize().width > this.preferredWidth) {
            this.preferredWidth = notes1L.getPreferredSize().width;
        }
    }

    public JPanel createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        panel.add((Component)cPanel, "Center");
        this.makeTitleTextField(cPanel);
        this.makeContentTextArea(cPanel);
        this.makeKeywordsTextArea(cPanel);
        this.makeNotes1TextArea(cPanel);
        JPanel wPanel = new JPanel();
        wPanel.setLayout(new BoxLayout(wPanel, 1));
        wPanel.setAlignmentY(1.0f);
        panel.add((Component)wPanel, "West");
        this.makeTitleLabel(wPanel);
        this.makeContentLabel(wPanel);
        this.makeKeywordsLabel(wPanel);
        this.makeNotes1Label(wPanel);
        return panel;
    }

    private boolean checkValidity() {
        boolean valid = false;
        if (this.model.getTitle().compareTo("") != 0 || !this.model.getContentList().isEmpty() || this.model.getNotes1List().isEmpty() || this.model.getNotes2List().isEmpty() || !this.model.getSelectorsList().isEmpty()) {
            valid = true;
        }
        return valid;
    }

    public void buildContentTree() {
        this.infocardBuilder.setStandardInfocard();
        this.infocardBuilder.setCardId();
        this.infocardBuilder.setContent();
        this.infocardBuilder.setTitle();
        this.infocardBuilder.setSelectors();
        this.infocardBuilder.setNotes1();
        this.infocardBuilder.setNotes2();
        this.infocardBuilder.setCreator(MainFrame.setupModel);
        this.infocardBuilder.setDateCreated();
        this.mainFr.infomlFile.hasChanged = true;
    }

    public void editContentTree() {
        this.infocardBuilder.modifyInfocard(this.infomlFile.findInfocard(this.model));
        this.infocardBuilder.setContent();
        this.infocardBuilder.setTitle();
        this.infocardBuilder.setSelectors();
        this.infocardBuilder.setNotes1();
        this.infocardBuilder.setNotes2();
        this.infocardBuilder.setCreator(MainFrame.setupModel);
        this.infocardBuilder.setDateCreated();
        this.mainFr.infomlFile.hasChanged = true;
    }

    boolean createContent() {
        if (MainFrame.setupModel.setupInf()) {
            if (this.model.getSelectorsString() != null && this.model.getSelectorsString().compareTo("") != 0) {
                this.model.setSelectorsList(this.model.getSelectorsString());
            }
            if (this.model.getContentString() != null && this.model.getContentString().compareTo("") != 0) {
                this.model.setContentList(this.model.getContentString());
            }
            if (this.model.getNotes1String() != null && this.model.getNotes1String().compareTo("") != 0) {
                this.model.setNotes1List(this.model.getNotes1String());
            }
            if (this.model.getNotes2String() != null && this.model.getNotes2String().compareTo("") != 0) {
                this.model.setNotes2List(this.model.getNotes2String());
            }
            if (this.checkValidity()) {
                this.infocardBuilder.generateCardId();
                MainFrame.setupModel.increaseSequenceNumber("notecarddialog");
                MainFrame.serializator.run();
                this.mainFr.infoWindow.addNode(this.model, 1);
                this.buildContentTree();
                MainFrame.equalizer.setModifiedNotecardModel(this.model);
                MainFrame.equalizer.run();
                this.dispose();
                this.mainFr.doc = null;
                this.mainFr.undoAction.setEnabled(false);
                this.mainFr.redoAction.setEnabled(false);
                this.mainFr.focusedDialog = null;
            } else {
                JOptionPane.showMessageDialog(this, "Please add text to at least one of the fields", "Validation Error", 0);
            }
        } else {
            JOptionPane pane = new JOptionPane("This program needs certain setup information \nbefore it can create infocards. \nClick OK to open the Setup Information Dialog", 0);
            JDialog dialog = pane.createDialog(this, "Setup Information Missing");
            dialog.setVisible(true);
            while (pane.getValue() == JOptionPane.UNINITIALIZED_VALUE) {
            }
            if (pane.getValue() != null) {
                SetupInformationDialog2 setupInformationDialog2 = new SetupInformationDialog2(this, "Setup Information", this.mainFr);
            }
            return false;
        }
        return true;
    }

    void editContent() {
        this.model.getSelectorsList().clear();
        this.model.getContentList().clear();
        this.model.getNotes1List().clear();
        if (MainFrame.setupModel.setupInf()) {
            if (this.model.getSelectorsString() != null) {
                this.model.setSelectorsList(this.model.getSelectorsString());
            }
            if (this.model.getContentString() != null && this.model.getContentString().compareTo("") != 0) {
                this.model.setContentList(this.model.getContentString());
            }
            if (this.model.getNotes1String() != null && this.model.getNotes1String().compareTo("") != 0) {
                this.model.setNotes1List(this.model.getNotes1String());
            }
            if (this.model.getNotes2String() != null && this.model.getNotes2String().compareTo("") != 0) {
                this.model.setNotes2List(this.model.getNotes2String());
            }
            if (this.checkValidity()) {
                this.editContentTree();
                this.mainFr.infoWindow.editNode(this.model);
                MainFrame.equalizer.setMainFr(this.mainFr);
                MainFrame.equalizer.setModifiedNotecardModel(this.model);
                MainFrame.equalizer.setModifiedInfomlType((InfomlType)this.mainFr.infocards.get(this.model));
                MainFrame.equalizer.equalizeNotecards();
                this.dispose();
                this.mainFr.doc = null;
                this.mainFr.undoAction.setEnabled(false);
                this.mainFr.redoAction.setEnabled(false);
                this.mainFr.focusedDialog = null;
            } else {
                JOptionPane.showMessageDialog(this, "Please add text to at least one of the fields", "Validation Error", 0);
            }
        } else {
            JOptionPane pane = new JOptionPane("This program needs certain setup information \nbefore it can create infocards. \nClick OK to open the Setup Information Dialog", 0);
            JDialog dialog = pane.createDialog(this, "Setup Information Missing");
            dialog.setVisible(true);
            while (pane.getValue() == JOptionPane.UNINITIALIZED_VALUE) {
            }
            if (pane.getValue() != null) {
                SetupInformationDialog2 setupInformationDialog2 = new SetupInformationDialog2(this, "Setup Information", this.mainFr);
            }
        }
    }

    public JPanel createSouthPanel() {
        Color color1 = new Color(100, 25, 60);
        Color color2 = new Color(60, 25, 100);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panelB = new JPanel(new FlowLayout(2));
        panel.add((Component)panelB, "South");
        JButton another = new JButton("Done/Another");
        another.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NotecardDialog.this.edit) {
                    NotecardDialog.this.createContent();
                    MainFrame cfr_ignored_0 = NotecardDialog.this.mainFr;
                    if (MainFrame.setupModel.setupInf()) {
                        NotecardDialog.this.mainFr.doSave();
                    }
                    NotecardModel model = new NotecardModel();
                    NotecardDialog.this.infocardBuilder = new InfocardBuilder(NotecardDialog.this.infomlFile, model);
                    NotecardDialog dialog = new NotecardDialog(NotecardDialog.this.mainFr, "New Notecard", model, NotecardDialog.this.infocardBuilder, NotecardDialog.this.mainFr, false);
                } else {
                    NotecardDialog.this.editContent();
                    NotecardDialog.this.mainFr.doSave();
                    NotecardModel model = new NotecardModel();
                    NotecardDialog.this.infocardBuilder = new InfocardBuilder(NotecardDialog.this.infomlFile, model);
                    NotecardDialog notecardDialog = new NotecardDialog(NotecardDialog.this.mainFr, "New Notecard", model, NotecardDialog.this.infocardBuilder, NotecardDialog.this.mainFr, false);
                }
            }
        });
        another.setForeground(color2);
        panelB.add(another);
        panelB.add(new JLabel("                  "));
        if (!this.edit) {
            this.create = new JButton(" Create ");
            this.create.setForeground(color1);
            this.create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotecardDialog.this.createContent();
                    MainFrame cfr_ignored_0 = NotecardDialog.this.mainFr;
                    if (MainFrame.setupModel.setupInf()) {
                        NotecardDialog.this.mainFr.doSave();
                    }
                }
            });
            panelB.add(this.create);
        } else {
            this.create = new JButton(" Done ");
            this.create.setForeground(color1);
            this.create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotecardDialog.this.editContent();
                    NotecardDialog.this.mainFr.doSave();
                }
            });
            panelB.add(this.create);
        }
        this.cancel = new JButton(" Cancel ");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotecardDialog.this.dispose();
                NotecardDialog.this.mainFr.undoAction.setEnabled(false);
                NotecardDialog.this.mainFr.redoAction.setEnabled(false);
                NotecardDialog.this.mainFr.focusedDialog = null;
                --AncestorDialog.viewableInstances;
            }
        });
        panelB.add(this.cancel);
        return panel;
    }

    public JPanel createPanelA() {
        JPanel panelA = new JPanel(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        panelA.add((Component)cPanel, "Center");
        this.notes2 = new JTextArea(4, 40);
        this.notes2.setLineWrap(true);
        this.notes2.setWrapStyleWord(true);
        NotecardDialog.invertFocusTraversalBehaviour(this.notes2);
        this.notes2.addFocusListener(this.mainFr.focusListener);
        this.notes2.addCaretListener(this.mainFr.caretListener);
        if (this.edit) {
            this.notes2.setText(this.model.getNotes2String());
        }
        MyDocumentListener listener4 = new MyDocumentListener(this, this.model, "notes2");
        this.notes2Doc = this.notes2.getDocument();
        this.notes2Doc.addDocumentListener(listener4);
        this.notes2Doc.addUndoableEditListener(this.ownUndoListener);
        JScrollPane scrollPane = new JScrollPane(this.notes2, 20, 31);
        cPanel.add(scrollPane);
        scrollPane.setBorder(this.myBorder.getBorder());
        JPanel wPanel = new JPanel();
        wPanel.setLayout(new BoxLayout(wPanel, 1));
        wPanel.setAlignmentY(0.5f);
        panelA.add((Component)wPanel, "West");
        JPanel panelD = new JPanel();
        JLabel notes2L = new JLabel(" Notes2 ", 0);
        notes2L.setPreferredSize(new Dimension(this.preferredWidth, this.notes1Height));
        panelD.add(notes2L);
        wPanel.add(panelD);
        return panelA;
    }

    public JPanel createCenterPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        final JPanel panelA = this.createPanelA();
        this.moreFields = new JButton(" More fields ");
        this.moreFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!NotecardDialog.this.visible) {
                            NotecardDialog.this.sPanel.add((Component)panelA, "North");
                            NotecardDialog.this.pack();
                            NotecardDialog.this.repaint();
                            NotecardDialog.this.visible = true;
                        } else {
                            NotecardDialog.this.sPanel.remove(panelA);
                            NotecardDialog.this.pack();
                            NotecardDialog.this.repaint();
                            NotecardDialog.this.visible = false;
                        }
                    }
                });
            }
        });
        panel.add(this.moreFields);
        panel.setMaximumSize(new Dimension(600, panel.getPreferredSize().height));
        panel.setMinimumSize(new Dimension(300, panel.getPreferredSize().height));
        return panel;
    }

    public void setFocusVector() {
        this.focusableComponents.addElement(this.title);
        this.focusableComponents.addElement(this.content);
        this.focusableComponents.addElement(this.keywords);
        this.focusableComponents.addElement(this.notes1);
        this.focusableComponents.addElement(this.moreFields);
        this.focusableComponents.addElement(this.notes2);
        this.focusableComponents.addElement(this.create);
        this.focusableComponents.addElement(this.cancel);
    }

    public static void invertFocusTraversalBehaviour(JTextArea textArea) {
        Set<AWTKeyStroke> forwardKeys = textArea.getFocusTraversalKeys(0);
        Set<AWTKeyStroke> backwardKeys = textArea.getFocusTraversalKeys(1);
        if (forwardKeys.size() != 1 || backwardKeys.size() != 1) {
            return;
        }
        AWTKeyStroke fks = forwardKeys.iterator().next();
        AWTKeyStroke bks = backwardKeys.iterator().next();
        int fkm = fks.getModifiers();
        int bkm = bks.getModifiers();
        int ctrlMask = 130;
        int ctrlShiftMask = 195;
        if (fks.getKeyCode() != 9 || (fkm & 0x82) == 0 || (fkm & 0x82) != fkm) {
            return;
        }
        if (bks.getKeyCode() != 9 || (bkm & 0xC3) == 0 || (bkm & 0xC3) != bkm) {
            return;
        }
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(1);
        newForwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        textArea.setFocusTraversalKeys(0, Collections.unmodifiableSet(newForwardKeys));
        HashSet<AWTKeyStroke> newBackwardKeys = new HashSet<AWTKeyStroke>(1);
        newBackwardKeys.add(AWTKeyStroke.getAWTKeyStroke(9, 65));
        textArea.setFocusTraversalKeys(1, Collections.unmodifiableSet(newBackwardKeys));
    }

    public static class TextInserter
    extends AbstractAction {
        private JTextArea textArea;
        private String insertable;

        private TextInserter(JTextArea textArea, String insertable) {
            this.textArea = textArea;
            this.insertable = insertable;
        }

        public static void applyTabBinding(JTextArea textArea) {
            textArea.getInputMap(0).put(KeyStroke.getKeyStroke(9, 130), "tab");
            textArea.getActionMap().put("tab", new TextInserter(textArea, "\t"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.textArea.insert(this.insertable, this.textArea.getCaretPosition());
        }
    }
}

