/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.jaxb.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.validator.Messages;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.infoml.jaxb.impl.runtime.DefaultJAXBContextImpl;
import org.infoml.jaxb.impl.runtime.ValidatableObject;
import org.infoml.jaxb.impl.runtime.ValidationContext;
import org.xml.sax.SAXException;

public class ValidatorImpl
implements Validator {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    final DefaultJAXBContextImpl jaxbContext;

    public ValidatorImpl(DefaultJAXBContextImpl c) {
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
        this.jaxbContext = c;
    }

    @Override
    public boolean validateRoot(Object o) throws ValidationException {
        if (o == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"rootObj"));
        }
        return this.validate(o, true);
    }

    @Override
    public boolean validate(Object o) throws ValidationException {
        if (o == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"subrootObj"));
        }
        return this.validate(o, false);
    }

    private boolean validate(Object o, boolean validateId) throws ValidationException {
        try {
            ValidatableObject vo = this.jaxbContext.getGrammarInfo().castToValidatableObject(o);
            if (vo == null) {
                throw new ValidationException(Messages.format((String)"Validator.NotValidatable"));
            }
            EventInterceptor ei = new EventInterceptor(this.eventHandler);
            ValidationContext context = new ValidationContext(this.jaxbContext, ei, validateId);
            context.validate(vo);
            context.reconcileIDs();
            return !ei.hadError();
        }
        catch (SAXException e) {
            Exception nested = e.getException();
            if (nested != null) {
                throw new ValidationException(nested);
            }
            throw new ValidationException(e);
        }
    }

    @Override
    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public void setEventHandler(ValidationEventHandler handler) {
        this.eventHandler = handler == null ? new DefaultValidationEventHandler() : handler;
    }

    @Override
    public void setProperty(String name, Object value) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(name, value);
    }

    @Override
    public Object getProperty(String name) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException(Messages.format((String)"Shared.MustNotBeNull", (Object)"name"));
        }
        throw new PropertyException(name);
    }

    private static class EventInterceptor
    implements ValidationEventHandler {
        private boolean hadError = false;
        private final ValidationEventHandler next;

        EventInterceptor(ValidationEventHandler _next) {
            this.next = _next;
        }

        public boolean hadError() {
            return this.hadError;
        }

        @Override
        public boolean handleEvent(ValidationEvent e) {
            boolean result;
            this.hadError = true;
            if (this.next != null) {
                try {
                    result = this.next.handleEvent(e);
                }
                catch (RuntimeException re) {
                    result = false;
                }
            } else {
                result = false;
            }
            return result;
        }
    }
}

