/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://jwsdp.dev.java.net/CDDLv1.0.html
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
 
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

// import java content classes generated by binding compiler
import primer.myPo.*;

/*
 * $Id: Main.java,v 1.1 2008/11/03 06:51:21 greggw Exp $
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
public class Main {
    
    // This sample application demonstrates how to modify a java content
    // tree and marshal it back to a xml data. This example demonstrates
    // customiation within the schema file, po.xsd, and the impact that these 
    // customizations have on the schema derived Java representation.
    
    public static void main( String[] args ) {
        try {
            // create a JAXBContext capable of handling classes generated into
            // the primer.po package
            JAXBContext jc = JAXBContext.newInstance( "primer.myPo" );
            
            // create an Unmarshaller
            Unmarshaller u = jc.createUnmarshaller();
            
            // unmarshal a po instance document into a tree of Java content
            // objects composed of classes from the primer.myPo package.
            PurchaseOrderElement po = 
                (PurchaseOrderElement)u.unmarshal( new FileInputStream( "po.xml" ) );

            // change the billto address
            USAddress address = po.getBillTo();
            address.setToName( "John Bob" );
            address.setStreet( "242 Main Street" );
            address.setCity( "Beverly Hills" );
            address.setState(USState.CA);
            address.setZipCode(90210);
	
            USState purchaseState = address.getState();
            ListIterator iter = po.getItems().getItem().listIterator();
	    while( iter.hasNext()) {
		
                // update to 20% off sale price	
                Items.ItemType item = (Items.ItemType)iter.next();
            	item.setPrice(item.getPrice().multiply(new BigDecimal("0.80")));
                
                //Calculate sales tax for specific states
                if (purchaseState == USState.MA) {
                    item.setPrice(item.getPrice().multiply(new BigDecimal("1.05")));
                } else if (purchaseState == USState.CA) {
                    item.setPrice(item.getPrice().multiply(new BigDecimal("1.06")));
                }
                item.setPrice(item.getPrice().setScale(2, BigDecimal.ROUND_DOWN));
            }

            // create a Marshaller and marshal to a file
            Marshaller m = jc.createMarshaller();
            m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
            m.marshal( po, System.out );
            
        } catch( JAXBException je ) {
            je.printStackTrace();
        } catch( IOException ioe ) {
            ioe.printStackTrace();
        }
    }
}
