/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class EventDispatchUtils {
    private EventDispatchUtils() {
    }

    public static void sleepWithEventDispatch(int timeout) {
        EventDispatchUtils.sleepWithEventDispatch(new Condition(){

            public boolean getValue() {
                return false;
            }
        }, timeout);
    }

    public static void sleepWithEventDispatch(Condition condition, int timeout) {
        Display display = Display.getCurrent();
        boolean isEventDispatchThread = display != null && display.getThread() == Thread.currentThread();
        long time = System.currentTimeMillis();
        while (!condition.getValue() && System.currentTimeMillis() - time <= (long)timeout) {
            if (isEventDispatchThread) {
                EventDispatchUtils.dispatchSWTEvents(display);
                if (condition.getValue() || System.currentTimeMillis() - time > (long)timeout) {
                    return;
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    private static void dispatchSWTEvents(Display display) {
        final AtomicBoolean isProcessed = new AtomicBoolean();
        display.asyncExec(new Runnable(){

            public void run() {
                isProcessed.set(true);
            }
        });
        while (!isProcessed.get()) {
            display.readAndDispatch();
        }
    }

    public static interface Condition {
        public boolean getValue();
    }
}

