/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SweetSystemProperty {
    LOCALHOSTADDRESS("sweet.localhostAddress", Type.READ_WRITE),
    LOCALHOSTADDRESS_DEBUG_PRINTDETECTION("sweet.localhostAddress.debug.printDetection", Type.READ_WRITE),
    LOCALHOSTADDRESS_DEBUG_PRINT("sweet.localhostAddress.debug.print", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTPORT("sweet.webserver.debug.printPort", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTREQUESTS("sweet.webserver.debug.printRequests", Type.READ_WRITE),
    WEBSERVER_DEBUG_PRINTDATA("sweet.webserver.debug.printData", Type.READ_WRITE),
    WEBSERVER_ACTIVATEOLDRESOURCEMETHOD("sweet.webserver.activateOldResourceMethod", Type.READ_WRITE),
    COMPONENTS_DEBUG_PRINTOPTIONS("sweet.components.debug.printOptions", Type.READ_WRITE),
    WEBBROWSER_RUNTIME("sweet.webbrowser.runtime", Type.READ_WRITE),
    WEBBROWSER_XULRUNNER_HOME("sweet.webbrowser.xulrunner.home", Type.READ_WRITE),
    HTMLEDITOR_GETHTMLCONTENT_TIMEOUT("sweet.htmleditor.getHTMLContent.timeout", Type.READ_WRITE),
    VLCPLAYER_FIXPLAYLISTAUTOPLAYNEXT("sweet.vlcplayer.fixPlaylistAutoPlayNext", Type.READ_WRITE);

    private final String _name;
    private final boolean _readOnly;

    private SweetSystemProperty(String name) {
        this(name, Type.READ_ONLY);
    }

    private SweetSystemProperty(String name, Type type) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ("".equals(name = name.trim())) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._readOnly = type == Type.READ_ONLY;
    }

    public String get() {
        return this.get(null);
    }

    public String get(final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(SweetSystemProperty.this.getName(), defaultValue);
            }
        });
    }

    public String set(final String value) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(String.valueOf(this.getName()) + " is a read-only property");
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(SweetSystemProperty.this.getName(), value);
            }
        });
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public String toString() {
        return this.get();
    }

    public String toDebugString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name()).append(": ");
        buf.append(this.getName()).append("=");
        buf.append(this.get());
        if (this.isReadOnly()) {
            buf.append(" (read-only)");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        READ_WRITE,
        READ_ONLY;

    }
}

