/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.sweet.EventDispatchUtils;
import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.SweetSystemProperty;
import chrriis.dj.sweet.components.HTMLEditorDirtyStateEvent;
import chrriis.dj.sweet.components.HTMLEditorListener;
import chrriis.dj.sweet.components.JHTMLEditorCKeditor;
import chrriis.dj.sweet.components.JHTMLEditorFCKeditor;
import chrriis.dj.sweet.components.JHTMLEditorTinyMCE;
import chrriis.dj.sweet.components.JWebBrowser;
import chrriis.dj.sweet.components.WebBrowserAdapter;
import chrriis.dj.sweet.components.WebBrowserCommandEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;

public class JHTMLEditor
extends Composite {
    private JWebBrowser webBrowser;
    private int instanceID;
    private JHTMLEditorImplementation implementation;
    private boolean isDirty;
    protected List<HTMLEditorListener> htmlEditorListenerList = new ArrayList<HTMLEditorListener>();
    protected List<InitializationListener> initializationListenerList = new ArrayList<InitializationListener>();
    private static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation;

    JHTMLEditorImplementation getImplementation() {
        return this.implementation;
    }

    /*
     * Unable to fully structure code
     */
    public JHTMLEditor(Composite parent, HTMLEditorImplementation editorImplementation, NSOption ... options) {
        super(parent, 0);
        if (editorImplementation == null) {
            throw new NullPointerException("The editor implementation cannot be null!");
        }
        this.setLayout(new FillLayout());
        optionMap = NSOption.createOptionMap(options);
        this.webBrowser = new JWebBrowser((Composite)this, options);
        switch (JHTMLEditor.$SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation()[editorImplementation.ordinal()]) {
            case 1: {
                try {
                    this.implementation = new JHTMLEditorFCKeditor(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl17
                    throw e;
                }
            }
lbl17:
            // 2 sources

            case 2: {
                try {
                    this.implementation = new JHTMLEditorCKeditor(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl24
                    throw e;
                }
            }
lbl24:
            // 2 sources

            case 3: {
                try {
                    this.implementation = new JHTMLEditorTinyMCE(this, optionMap);
                    break;
                }
                catch (RuntimeException e) {
                    if (editorImplementation == null) ** GOTO lbl31
                    throw e;
                }
            }
lbl31:
            // 2 sources

            default: {
                throw new IllegalStateException("A suitable HTML editor (FCKeditor, TinyMCE) distribution could not be found on the classpath!");
            }
        }
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserCommandEvent e) {
                String command = e.getCommand();
                if ("[Chrriis]JH_setLoaded".equals(command)) {
                    int i = JHTMLEditor.this.initializationListenerList.size() - 1;
                    while (i >= 0) {
                        JHTMLEditor.this.initializationListenerList.get(i).objectInitialized();
                        --i;
                    }
                } else if ("[Chrriis]JH_setDirty".equals(command)) {
                    JHTMLEditor.this.setDirty(true);
                }
            }
        });
        this.webBrowser.setBarsVisible(false);
        this.instanceID = ObjectRegistry.getInstance().add(this);
        result = new AtomicBoolean();
        initializationListener = new InitializationListener(){

            public void objectInitialized() {
                JHTMLEditor.this.removeInitializationListener(this);
                result.set(true);
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(WebServer.getDefaultWebServer().getDynamicContentURL(JHTMLEditor.class.getName(), String.valueOf(this.instanceID), "index.html"));
        EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

            public boolean getValue() {
                return result.get();
            }
        }, 4000);
        this.removeInitializationListener(initializationListener);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        String resourcePath = httpRequest.getResourcePath();
        int index = resourcePath.indexOf(47);
        int instanceID = Integer.parseInt(resourcePath.substring(0, index));
        JHTMLEditor htmlEditor = (JHTMLEditor)ObjectRegistry.getInstance().get(instanceID);
        if (htmlEditor == null) {
            return null;
        }
        String resourcePath_ = resourcePath.substring(index + 1);
        if (resourcePath_.startsWith("/")) {
            resourcePath_ = resourcePath_.substring(1);
        }
        return htmlEditor.getWebServerContent(httpRequest, resourcePath_, instanceID);
    }

    protected WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest, String resourcePath, int instanceID) {
        return this.implementation.getWebServerContent(httpRequest, resourcePath, instanceID);
    }

    public String getHTMLContent() {
        return JHTMLEditor.convertLinksToLocal(this.implementation.getHTMLContent());
    }

    public void setHTMLContent(String html) {
        html = JHTMLEditor.convertLinksFromLocal(html.replaceAll("[\r\n]", " "));
        this.implementation.setHTMLContent(html);
        this.setDirty(false);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setDirty(boolean isDirty) {
        if (this.isDirty == isDirty) {
            return;
        }
        this.isDirty = isDirty;
        HTMLEditorDirtyStateEvent e = null;
        HTMLEditorListener[] hTMLEditorListenerArray = this.getHTMLEditorListeners();
        int n = hTMLEditorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            HTMLEditorListener listener = hTMLEditorListenerArray[n2];
            if (e == null) {
                e = new HTMLEditorDirtyStateEvent(this, isDirty);
            }
            listener.notifyDirtyStateChanged(e);
            ++n2;
        }
    }

    public void clearDirtyState() {
        this.implementation.clearDirtyIndicator();
        this.setDirty(false);
    }

    static String convertLinksToLocal(String html) {
        String resource;
        String codeBase;
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/resource/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            codeBase = html.substring(m.start(2), m.end(2));
            resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeURL(Utils.decodeURL(codeBase)), resource).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        p = Pattern.compile("=\\s*\"(" + WebServer.getDefaultWebServer().getURLPrefix() + "/location/)([^/]+)/([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            codeBase = html.substring(m.start(2), m.end(2));
            resource = html.substring(m.start(3), m.end(3));
            try {
                resource = new File(Utils.decodeBase64(codeBase), Utils.decodeURL(resource)).toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(3));
        }
        return html;
    }

    static String convertLinksFromLocal(String html) {
        Matcher m;
        if (html == null) {
            return html;
        }
        Pattern p = Pattern.compile("=\\s*\"(file:/{1,3})([^\"]+)\"\\s");
        while ((m = p.matcher(html)).find()) {
            File resourceFile;
            String resource = html.substring(m.start(2), m.end(2));
            if (Boolean.parseBoolean(SweetSystemProperty.WEBSERVER_ACTIVATEOLDRESOURCEMETHOD.get())) {
                resourceFile = new File(resource);
                resource = WebServer.getDefaultWebServer().getResourcePathURL(Utils.encodeURL(resourceFile.getParent()), resourceFile.getName());
            } else {
                resourceFile = new File(Utils.decodeURL(resource));
                resource = WebServer.getDefaultWebServer().getResourcePathURL(resourceFile.getParent(), resourceFile.getName());
            }
            html = String.valueOf(html.substring(0, m.start(1))) + resource + html.substring(m.end(2));
        }
        return html;
    }

    public void addHTMLEditorListener(HTMLEditorListener listener) {
        this.htmlEditorListenerList.add(listener);
    }

    public void removeHTMLEditorListener(HTMLEditorListener listener) {
        this.htmlEditorListenerList.remove(listener);
    }

    public HTMLEditorListener[] getHTMLEditorListeners() {
        return this.htmlEditorListenerList.toArray(new HTMLEditorListener[0]);
    }

    private void addInitializationListener(InitializationListener listener) {
        this.initializationListenerList.add(listener);
    }

    private void removeInitializationListener(InitializationListener listener) {
        this.initializationListenerList.remove(listener);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation() {
        if ($SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation != null) {
            return $SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation;
        }
        int[] nArray = new int[HTMLEditorImplementation.values().length];
        try {
            nArray[HTMLEditorImplementation.CKEditor.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTMLEditorImplementation.FCKEditor.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HTMLEditorImplementation.TinyMCE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$chrriis$dj$sweet$components$JHTMLEditor$HTMLEditorImplementation = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CKEditorOptions {
        static final String SET_OPTIONS_OPTION_KEY = "CKEditor Options";

        private CKEditorOptions() {
        }

        public static NSOption setOptions(Map<String, String> optionMap) {
            final HashMap<String, String> optionMap_ = new HashMap<String, String>(optionMap);
            return new NSOption(SET_OPTIONS_OPTION_KEY){

                public Object getOptionValue() {
                    return optionMap_;
                }
            };
        }
    }

    public static class FCKEditorOptions {
        static final String SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY = "FCKEditor Custom Configuration Script";

        private FCKEditorOptions() {
        }

        public static NSOption setCustomJavascriptConfiguration(final String javascriptConfiguration) {
            return new NSOption(SET_CUSTOM_JAVASCRIPT_CONFIGURATION_OPTION_KEY){

                public Object getOptionValue() {
                    return javascriptConfiguration;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTMLEditorImplementation {
        FCKEditor,
        CKEditor,
        TinyMCE;

    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    static interface JHTMLEditorImplementation {
        public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest var1, String var2, int var3);

        public String getHTMLContent();

        public void setHTMLContent(String var1);

        public void setDirtyTrackingActive(boolean var1);

        public void clearDirtyIndicator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TinyMCEOptions {
        static final String SET_CUSTOM_HTML_HEADERS_OPTION_KEY = "TinyMCE Custom HTML Headers";
        static final String SET_OPTIONS_OPTION_KEY = "TinyMCE Options";

        private TinyMCEOptions() {
        }

        public static NSOption setCustomHTMLHeaders(final String customHTMLHeaders) {
            return new NSOption(SET_CUSTOM_HTML_HEADERS_OPTION_KEY){

                public Object getOptionValue() {
                    return customHTMLHeaders;
                }
            };
        }

        public static NSOption setOptions(Map<String, String> optionMap) {
            final HashMap<String, String> optionMap_ = new HashMap<String, String>(optionMap);
            return new NSOption(SET_OPTIONS_OPTION_KEY){

                public Object getOptionValue() {
                    return optionMap_;
                }
            };
        }
    }
}

