/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.sweet.EventDispatchUtils;
import chrriis.dj.sweet.SweetSystemProperty;
import chrriis.dj.sweet.components.HTMLEditorListener;
import chrriis.dj.sweet.components.HTMLEditorSaveEvent;
import chrriis.dj.sweet.components.JHTMLEditor;
import chrriis.dj.sweet.components.JWebBrowser;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.eclipse.swt.browser.Browser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JHTMLEditorCKeditor
implements JHTMLEditor.JHTMLEditorImplementation {
    private static final String PACKAGE_PREFIX = "/ckeditor/";
    private static final String EDITOR_INSTANCE = "HTMLeditor1";
    private final JHTMLEditor htmlEditor;
    private final String customOptions;
    static final String LS = Utils.LINE_SEPARATOR;
    private volatile Object tempResult;

    public JHTMLEditorCKeditor(JHTMLEditor htmlEditor, Map<Object, Object> optionMap) {
        if (this.getClass().getResource("/ckeditor/ckeditor.js") == null) {
            throw new IllegalStateException("The CKEditor distribution is missing from the classpath!");
        }
        this.htmlEditor = htmlEditor;
        Map customOptionsMap = (Map)optionMap.get("CKEditor Options");
        if (customOptionsMap != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : customOptionsMap.keySet()) {
                String value = (String)customOptionsMap.get(key);
                if (value == null || value.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(String.valueOf(',') + LS);
                }
                sb.append("          " + key + ": " + value);
            }
            this.customOptions = sb.length() > 0 ? sb.toString() : null;
        } else {
            this.customOptions = null;
        }
    }

    @Override
    public WebServer.WebServerContent getWebServerContent(final WebServer.HTTPRequest httpRequest, final String resourcePath, int instanceID) {
        if ("index.html".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    int index = resourcePath.lastIndexOf(46);
                    return 1.getDefaultMimeType(index == -1 ? null : resourcePath.substring(index));
                }

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>" + LS + "    <style type=\"text/css\">" + LS + "      body, form {margin: 0; padding: 0; overflow: auto;}" + LS + "    </style>" + LS + "    <script type=\"text/javascript\" src=\"ckeditor.js\"></script>" + LS + "    <script type=\"text/javascript\">" + LS + "      var sendCommand = " + "sendSCommand" + ";" + LS + "      var htmlContent;" + LS + "      var htmlDirtyTracker;" + LS + "      var isDirtyTrackingActive = true;" + LS + "      function JH_checkDirty() {" + LS + "        var oEditor = CKEDITOR.instances." + JHTMLEditorCKeditor.EDITOR_INSTANCE + ";" + LS + "        if(htmlContent == null) {" + LS + "          try {" + LS + "            htmlContent = oEditor.getData();" + LS + "          } catch(e) {" + LS + "          }" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        } else {" + LS + "          try {" + LS + "            var newHtmlContent = oEditor.getData();" + LS + "            if(newHtmlContent != htmlContent) {" + LS + "              htmlContent = null;" + LS + "              htmlDirtyTracker = null;" + LS + "              sendCommand('[Chrriis]JH_setDirty');" + LS + "            } else {" + LS + "              htmlContent = newHtmlContent;" + LS + "              htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "            }" + LS + "          } catch(e) {" + LS + "            htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "          }" + LS + "        }" + LS + "      }" + LS + "      function JH_clearDirtyIndicator() {" + LS + "        if(htmlDirtyTracker) {" + LS + "          clearTimeout(htmlDirtyTracker);" + LS + "        }" + LS + "        htmlContent = null;" + LS + "        if(isDirtyTrackingActive) {" + LS + "          htmlDirtyTracker = setTimeout('JH_checkDirty()', 1000);" + LS + "        }" + LS + "      }" + LS + "      function JH_setDirtyTrackingActive(isActive) {" + LS + "        isDirtyTrackingActive = isActive;" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_setData(html) {" + LS + "        var oEditor = CKEDITOR.instances." + JHTMLEditorCKeditor.EDITOR_INSTANCE + ";" + LS + "        oEditor.setData(decodeURIComponent(html));" + LS + "        JH_clearDirtyIndicator();" + LS + "      }" + LS + "      function JH_sendData() {" + LS + "        document.jhtml_form.action = 'jhtml_sendData';" + LS + "        document.jhtml_form.submit();" + LS + "        document.jhtml_form.action = 'jhtml_save';" + LS + "        return false;" + LS + "      }" + LS + "      function JH_doSave() {" + LS + "        document.jhtml_form.action = 'jhtml_save';" + LS + "        document.jhtml_form.submit();" + LS + "        return false;" + LS + "      }" + LS + "      CKEDITOR.on('instanceReady'," + LS + "      \t function(evt) {" + LS + "     \t   var editor = evt.editor;" + LS + "     \t   editor.execCommand('maximize');" + LS + "          JH_clearDirtyIndicator();" + LS + "          sendCommand('[Chrriis]JH_setLoaded');" + LS + "      \t });" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "    <iframe style=\"display:none;\" id=\"j_iframe\" name=\"j_iframe\"></iframe>" + LS + "    <form name=\"jhtml_form\" method=\"POST\" target=\"j_iframe\" action=\"jhtml_save\">" + LS + "      <textarea name=\"" + JHTMLEditorCKeditor.EDITOR_INSTANCE + "\">&lt;p&gt;&lt;/p&gt;</textarea>" + LS + "      <script type=\"text/javascript\">" + LS + "        CKEDITOR.replace('" + JHTMLEditorCKeditor.EDITOR_INSTANCE + "'" + (JHTMLEditorCKeditor.this.customOptions != null ? ",{" + LS + JHTMLEditorCKeditor.this.customOptions + LS + "        });" : ");") + LS + "      </script>" + LS + "    </form>" + LS + "  </body>" + LS + "</html>";
                    return 1.getInputStream(content);
                }
            };
        }
        if ("jhtml_save".equals(resourcePath)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String html = JHTMLEditor.convertLinksToLocal(httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(JHTMLEditorCKeditor.EDITOR_INSTANCE));
                    HTMLEditorSaveEvent e = null;
                    HTMLEditorListener[] hTMLEditorListenerArray = JHTMLEditorCKeditor.this.htmlEditor.getHTMLEditorListeners();
                    int n = hTMLEditorListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HTMLEditorListener listener = hTMLEditorListenerArray[n2];
                        if (e == null) {
                            e = new HTMLEditorSaveEvent(JHTMLEditorCKeditor.this.htmlEditor, html);
                        }
                        listener.saveHTML(e);
                        ++n2;
                    }
                }
            });
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Save successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 3.getInputStream(content);
                }
            };
        }
        if ("jhtml_sendData".equals(resourcePath)) {
            String data = httpRequest.getHTTPPostDataArray()[0].getHeaderMap().get(EDITOR_INSTANCE);
            this.tempResult = data;
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <body>" + LS + "    Send data successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 4.getInputStream(content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/upload.php".equals(resourcePath)) {
            return new WebServer.WebServerContent(){

                public InputStream getInputStream() {
                    String content = "<html>" + LS + "  <head>" + LS + "    <script type=\"text/javascript\">" + LS + "      alert('upload to local system are not allowed...');" + LS + "    </script>" + LS + "  </head>" + LS + "  <body>" + LS + "    Upload successful." + LS + "  </body>" + LS + "</html>" + LS;
                    return 5.getInputStream(content);
                }
            };
        }
        if ("editor/filemanager/connectors/php/connector.php".equals(resourcePath)) {
            Map<String, String> queryParameterMap = httpRequest.getQueryParameterMap();
            String command = queryParameterMap.get("Command");
            String content = null;
            if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                final String type = queryParameterMap.get("Type");
                String currentDir = queryParameterMap.get("CurrentFolder");
                File[] roots = File.listRoots();
                StringBuilder sb = new StringBuilder();
                sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                sb.append("<Connector command=\"").append(command).append("\" resourceType=\"").append(type).append("\">");
                sb.append("<CurrentFolder path=\"").append(currentDir).append("\" url=\"").append(WebServer.getDefaultWebServer().getResourcePathURL(currentDir, "")).append("\" />");
                if (("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) && currentDir.equals("/") && roots.length > 1) {
                    sb.append("<Folders>");
                    File[] fileArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        String rootPath = file.getAbsolutePath();
                        if (Utils.IS_WINDOWS && rootPath.endsWith("\\")) {
                            rootPath = rootPath.substring(0, rootPath.length() - 1);
                        }
                        sb.append("<Folder name=\"").append(Utils.escapeXML(rootPath)).append("\"/>");
                        ++n2;
                    }
                    sb.append("</Folders>");
                } else {
                    File file;
                    int n;
                    int n3;
                    File[] fileArray;
                    if ("GetFoldersAndFiles".equals(command) || "GetFolders".equals(command)) {
                        sb.append("<Folders>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return !pathname.isFile() && !pathname.isHidden() && pathname.listFiles() != null;
                            }
                        });
                        n3 = fileArray.length;
                        n = 0;
                        while (n < n3) {
                            file = fileArray[n];
                            sb.append("<Folder name=\"").append(Utils.escapeXML(file.getName())).append("\"/>");
                            ++n;
                        }
                        sb.append("</Folders>");
                    }
                    if ("GetFoldersAndFiles".equals(command)) {
                        sb.append("<Files>");
                        fileArray = new File(currentDir).listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                if (!pathname.isFile()) {
                                    return false;
                                }
                                if ("Image".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".bmp") || name.endsWith(".jpg") || name.endsWith(".gif") || name.endsWith(".png");
                                }
                                if ("Flash".equals(type)) {
                                    String name = pathname.getName().toLowerCase();
                                    return name.endsWith(".swf");
                                }
                                return true;
                            }
                        });
                        n3 = fileArray.length;
                        n = 0;
                        while (n < n3) {
                            file = fileArray[n];
                            sb.append("<File name=\"").append(Utils.escapeXML(file.getName())).append("\" size=\"").append(file.length() / 1000L).append("\"/>");
                            ++n;
                        }
                        sb.append("</Files>");
                    }
                }
                sb.append("</Connector>");
                content = sb.toString();
            }
            final String content_ = content;
            return new WebServer.WebServerContent(){

                public String getContentType() {
                    return "text/xml; charset=utf-8";
                }

                public InputStream getInputStream() {
                    return 8.getInputStream(content_);
                }
            };
        }
        return WebServer.getDefaultWebServer().getURLContent(WebServer.getDefaultWebServer().getClassPathResourceURL(JHTMLEditor.class.getName(), PACKAGE_PREFIX + resourcePath));
    }

    @Override
    public void clearDirtyIndicator() {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_clearDirtyIndicator();");
    }

    @Override
    public void setDirtyTrackingActive(boolean isDirtyTrackingActive) {
        this.htmlEditor.getWebBrowser().executeJavascript("JH_setDirtyTrackingActive(" + isDirtyTrackingActive + ");");
    }

    @Override
    public String getHTMLContent() {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        this.tempResult = this;
        webBrowser.executeJavascript("JH_sendData();");
        int timeout = Integer.parseInt(SweetSystemProperty.HTMLEDITOR_GETHTMLCONTENT_TIMEOUT.get("1500"));
        long start = System.currentTimeMillis();
        do {
            EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                public boolean getValue() {
                    return JHTMLEditorCKeditor.this.tempResult != JHTMLEditorCKeditor.this;
                }
            }, 50);
            if (this.tempResult == this) continue;
            return (String)this.tempResult;
        } while (System.currentTimeMillis() - start <= (long)timeout);
        return null;
    }

    @Override
    public void setHTMLContent(String html) {
        JWebBrowser webBrowser = this.htmlEditor.getWebBrowser();
        Browser nativeComponent = webBrowser.getNativeComponent();
        boolean isEnabled = nativeComponent.isEnabled();
        nativeComponent.setEnabled(false);
        webBrowser.executeJavascript("JH_setData('" + Utils.encodeURL(html) + "');");
        nativeComponent.setEnabled(isEnabled);
    }
}

