/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.components.BorderUtils;
import chrriis.dj.sweet.components.JWebBrowser;
import chrriis.dj.sweet.components.VLCAudio;
import chrriis.dj.sweet.components.VLCInput;
import chrriis.dj.sweet.components.VLCPlaylist;
import chrriis.dj.sweet.components.VLCPluginOptions;
import chrriis.dj.sweet.components.VLCVideo;
import chrriis.dj.sweet.components.WebBrowserObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVLCPlayer
extends Composite {
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JVLCPlayer.class.getPackage().getName().replace('.', '/')) + "/resource/VLCPlayer");
    private Composite webBrowserPanel;
    private JWebBrowser webBrowser;
    private Composite controlBarPane;
    private Button playButton;
    private Button pauseButton;
    private Button stopButton;
    private WebBrowserObject webBrowserObject;
    private volatile VLCPluginOptions options;
    private VLCAudio vlcAudio;
    private VLCInput vlcInput;
    private VLCPlaylist vlcPlaylist;
    private VLCVideo vlcVideo;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    WebBrowserObject getWebBrowserObject() {
        return this.webBrowserObject;
    }

    public JVLCPlayer(Composite parent, NSOption ... options) {
        super(parent, 0);
        this.setLayout(new GridLayout());
        this.webBrowserPanel = new Composite(this, 0);
        BorderUtils.addLoweredBevelBorderPaintListener(this.webBrowserPanel);
        this.webBrowserPanel.setLayout(new FillLayout());
        this.webBrowserPanel.setLayoutData(new GridData(4, 4, true, true));
        this.webBrowser = new JWebBrowser(this.webBrowserPanel, options);
        this.webBrowserObject = new NWebBrowserObject(this);
        this.vlcAudio = new VLCAudio(this);
        this.vlcInput = new VLCInput(this);
        this.vlcPlaylist = new VLCPlaylist(this);
        this.vlcVideo = new VLCVideo(this);
        this.controlBarPane = new Composite(this, 0);
        GridLayout controlBarPaneGridLayout = new GridLayout();
        controlBarPaneGridLayout.marginWidth = 0;
        controlBarPaneGridLayout.marginHeight = 0;
        this.controlBarPane.setLayout(controlBarPaneGridLayout);
        this.controlBarPane.setLayoutData(new GridData(4, 4, true, false));
        Composite buttonBarPanel = new Composite(this.controlBarPane, 0);
        GridLayout buttonBarPanelGridLayout = new GridLayout(3, false);
        buttonBarPanelGridLayout.marginWidth = 0;
        buttonBarPanelGridLayout.marginHeight = 0;
        buttonBarPanel.setLayout(buttonBarPanelGridLayout);
        buttonBarPanel.setLayoutData(new GridData(4, 4, true, false));
        Composite buttonPanel = new Composite(buttonBarPanel, 0);
        GridLayout buttonPanelGridLayout = new GridLayout(3, false);
        buttonPanelGridLayout.marginWidth = 0;
        buttonPanelGridLayout.marginHeight = 0;
        buttonPanel.setLayout(buttonPanelGridLayout);
        buttonPanel.setLayoutData(new GridData(0x1000000, 4, true, false));
        this.playButton = new Button(buttonPanel, 8);
        this.playButton.setImage(this.createImage("PlayIcon"));
        this.playButton.setEnabled(false);
        this.playButton.setToolTipText(this.RESOURCES.getString("PlayText"));
        this.playButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().play();
            }
        });
        this.pauseButton = new Button(buttonPanel, 8);
        this.pauseButton.setImage(this.createImage("PauseIcon"));
        this.pauseButton.setEnabled(false);
        this.pauseButton.setToolTipText(this.RESOURCES.getString("PauseText"));
        this.pauseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().togglePause();
            }
        });
        this.stopButton = new Button(buttonPanel, 8);
        this.stopButton.setImage(this.createImage("StopIcon"));
        this.stopButton.setEnabled(false);
        this.stopButton.setToolTipText(this.RESOURCES.getString("StopText"));
        this.stopButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JVLCPlayer.this.getVLCPlaylist().stop();
            }
        });
        this.setControlBarVisible(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JVLCPlayer.this.webBrowserObject.load(null);
            }
        });
    }

    private void adjustBorder() {
        FillLayout layout = (FillLayout)this.webBrowserPanel.getLayout();
        if (this.isControlBarVisible()) {
            layout.marginWidth = 2;
            layout.marginHeight = 2;
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.webBrowserPanel.layout();
    }

    private Image createImage(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new Image((Device)this.getDisplay(), JWebBrowser.class.getResourceAsStream(value));
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void load() {
        this.load((VLCPluginOptions)null);
    }

    public void load(String resourceLocation) {
        this.load(resourceLocation, null);
    }

    public void load(VLCPluginOptions options) {
        this.load_("", options);
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.load(clazz, resourcePath, null);
    }

    public void load(Class<?> clazz, String resourcePath, VLCPluginOptions options) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void load(String resourceLocation, VLCPluginOptions options) {
        if ("".equals(resourceLocation)) {
            resourceLocation = null;
        }
        this.load_(resourceLocation, options);
    }

    private void load_(String resourceLocation, VLCPluginOptions options) {
        if (options == null) {
            options = new VLCPluginOptions();
        }
        this.options = options;
        this.webBrowserObject.load(resourceLocation);
        VLCPlaylist playlist = this.getVLCPlaylist();
        if (resourceLocation != null && !"".equals(resourceLocation)) {
            playlist.clear();
            playlist.addItem(resourceLocation);
            playlist.play();
        }
        boolean hasContent = this.webBrowserObject.hasContent();
        this.playButton.setEnabled(hasContent);
        this.pauseButton.setEnabled(hasContent);
        this.stopButton.setEnabled(hasContent);
    }

    public boolean isControlBarVisible() {
        return this.controlBarPane.isVisible();
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.controlBarPane.setVisible(isControlBarVisible);
        ((GridData)this.controlBarPane.getLayoutData()).exclude = !isControlBarVisible;
        this.controlBarPane.getParent().layout();
        this.adjustBorder();
    }

    public VLCAudio getVLCAudio() {
        return this.vlcAudio;
    }

    public VLCInput getVLCInput() {
        return this.vlcInput;
    }

    public VLCPlaylist getVLCPlaylist() {
        return this.vlcPlaylist;
    }

    public VLCVideo getVLCVideo() {
        return this.vlcVideo;
    }

    void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private final JVLCPlayer vlcPlayer;

        public NWebBrowserObject(JVLCPlayer vlcPlayer) {
            super(vlcPlayer.webBrowser);
            this.vlcPlayer = vlcPlayer;
        }

        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            if (this.vlcPlayer.options != null) {
                objectHTMLConfiguration.setHTMLParameters(this.vlcPlayer.options.getParameters());
            }
            objectHTMLConfiguration.setWindowsClassID("9BE31822-FDAD-461B-AD51-BE1D1C159921");
            objectHTMLConfiguration.setWindowsInstallationURL("http://downloads.videolan.org/pub/videolan/vlc/latest/win32/axvlc.cab");
            objectHTMLConfiguration.setMimeType("application/x-vlc-plugin");
            objectHTMLConfiguration.setInstallationURL("http://www.videolan.org");
            objectHTMLConfiguration.setVersion("VideoLAN.VLCPlugin.2");
            return objectHTMLConfiguration;
        }

        public String getLocalFileURL(File localFile) {
            String s;
            block3: {
                String absolutePath = localFile.getAbsolutePath();
                if (absolutePath.startsWith("\\\\")) {
                    return absolutePath;
                }
                try {
                    s = "file://" + localFile.toURI().toURL().toString().substring("file:".length());
                }
                catch (Exception e) {
                    s = "file:///" + absolutePath;
                    if (!Utils.IS_WINDOWS) break block3;
                    s = s.replace('\\', '/');
                }
            }
            return this.encodeSpecialCharacters(s);
        }

        private String encodeSpecialCharacters(String s) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                boolean isToEncode = false;
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    switch (c) {
                        case '%': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '_': {
                            break;
                        }
                        default: {
                            isToEncode = true;
                        }
                    }
                }
                if (isToEncode) {
                    sb.append(Utils.encodeURL(String.valueOf(c)));
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

