/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.components.JWebBrowser;
import chrriis.dj.sweet.components.WebBrowserAdapter;
import chrriis.dj.sweet.components.WebBrowserEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class JWebBrowserWindow
extends Shell {
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JWebBrowserWindow.class.getPackage().getName().replace('.', '/')) + "/resource/WebBrowser");
    private JWebBrowser webBrowser;

    public JWebBrowserWindow(NSOption ... options) {
        this.setLayout(new FillLayout());
        this.webBrowser = new JWebBrowser((Composite)this, options);
        Menu fileMenu = this.webBrowser.getFileMenu();
        new MenuItem(fileMenu, 2);
        MenuItem fileCloseMenuItem = new MenuItem(fileMenu, 8);
        fileCloseMenuItem.setText(this.RESOURCES.getString("FileCloseMenu"));
        fileCloseMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowserWindow.this.dispose();
            }
        });
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void titleChanged(WebBrowserEvent e) {
                MessageFormat mf = new MessageFormat(JWebBrowserWindow.this.RESOURCES.getString("BrowserTitle"));
                JWebBrowserWindow.this.setText(mf.format(new Object[]{e.getWebBrowser().getPageTitle()}));
            }
        });
        Display display = this.getDisplay();
        String value = this.RESOURCES.getString("BrowserIcon");
        if (value.length() > 0) {
            this.setImage(new Image((Device)display, JWebBrowserWindow.class.getResourceAsStream(value)));
        }
        Rectangle bounds = display.getPrimaryMonitor().getBounds();
        bounds.width = bounds.width * 80 / 100;
        bounds.height = bounds.height * 80 / 100;
        this.setSize(bounds.width, bounds.height);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void setBarsVisible(boolean areBarsVisible) {
        this.webBrowser.setBarsVisible(areBarsVisible);
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        this.webBrowser.setStatusBarVisible(isStatusBarVisible);
    }

    public boolean isStatusBarVisisble() {
        return this.webBrowser.isStatusBarVisible();
    }

    public void setMenuBarVisible(boolean isMenuBarVisible) {
        this.webBrowser.setMenuBarVisible(isMenuBarVisible);
    }

    public boolean isMenuBarVisisble() {
        return this.webBrowser.isMenuBarVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        this.webBrowser.setButtonBarVisible(isButtonBarVisible);
    }

    public boolean isButtonBarVisisble() {
        return this.webBrowser.isButtonBarVisible();
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        this.webBrowser.setLocationBarVisible(isLocationBarVisible);
    }

    public boolean isLocationBarVisisble() {
        return this.webBrowser.isLocationBarVisible();
    }

    protected void checkSubclass() {
    }
}

