/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.Oid;
import java.security.Provider;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

class MechInfo {
    private Oid m_oid;
    private Oid[] m_names;
    private String _V2395ABD;
    private String _V108CA91;
    private String _V901D6C2;
    private Provider _V510CA83;
    private Class _V80013BE;
    private Class _V29ED8BF;
    private Class _V30FDA16;
    private static Properties M_oidAlias = new Properties();

    private MechInfo() {
    }

    MechInfo(Provider provider, String string) throws GSSException {
        this.m_oid = new Oid(string);
        this._V510CA83 = provider;
        MechInfo.updateOidAlias(provider, string);
        String string2 = MechInfo._M73F1AC8(provider, string, "_K872D1AC");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            this.m_names = new Oid[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.m_names[n] = new Oid(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            throw new GSSException(2);
        }
        this._V2395ABD = MechInfo._M73F1AC8(provider, string, "_K532D1BD");
        this._V108CA91 = MechInfo._M73F1AC8(provider, string, "_K1000A49");
        this._V901D6C2 = MechInfo._M73F1AC8(provider, string, "_K2102CC5");
        if (this._V2395ABD == null || this._V108CA91 == null || this._V901D6C2 == null) {
            throw new GSSException(2);
        }
    }

    C018FE95 _M4092FBA() throws GSSException {
        try {
            if (this._V30FDA16 == null) {
                this._V30FDA16 = Class.forName(this._V108CA91);
            }
            return (C018FE95)this._V30FDA16.newInstance();
        }
        catch (Exception exception) {
            throw new GSSException(16);
        }
    }

    private static String _M73F1AC8(Provider provider, String string, String string2) {
        String string3 = ((Properties)provider).getProperty("JGSS.Mech." + string + "." + string2);
        if (string3 != null) {
            return string3;
        }
        string3 = MechInfo.oidStrToAlias(string);
        if (string3 == null) {
            return null;
        }
        return ((Properties)provider).getProperty("JGSS.Mech." + string3 + "." + string2);
    }

    private static String aliasToOidStr(String string) {
        return M_oidAlias.getProperty(string);
    }

    GSSCredSpi getCredInstance() throws GSSException {
        try {
            if (this._V29ED8BF == null) {
                this._V29ED8BF = Class.forName(this._V901D6C2);
            }
            return (GSSCredSpi)this._V29ED8BF.newInstance();
        }
        catch (Exception exception) {
            throw new GSSException(16);
        }
    }

    static MechInfo[] getInfoForAllMechs(Provider provider) {
        String string = ((Properties)provider).getProperty("JGSS.Mechs");
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        MechInfo[] mechInfoArray = new MechInfo[stringTokenizer.countTokens()];
        int n = 0;
        while (n < mechInfoArray.length) {
            try {
                mechInfoArray[n] = new MechInfo(provider, stringTokenizer.nextToken());
            }
            catch (GSSException gSSException) {}
            ++n;
        }
        return mechInfoArray;
    }

    static String[] getMechsForProvider(Provider provider) {
        String string = ((Properties)provider).getProperty("JGSS.Mechs");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    GSSNameSpi getNameInstance() throws GSSException {
        try {
            if (this._V80013BE == null) {
                this._V29ED8BF = Class.forName(this._V2395ABD);
            }
            return (GSSNameSpi)this._V29ED8BF.newInstance();
        }
        catch (Exception exception) {
            throw new GSSException(16);
        }
    }

    Oid[] getNames() {
        return this.m_names;
    }

    Oid getOid() {
        return this.m_oid;
    }

    Provider getProvider() {
        return this._V510CA83;
    }

    static boolean implementsMech(Provider provider, String string) {
        String[] stringArray = MechInfo.getMechsForProvider(provider);
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static String oidStrToAlias(String string) {
        return M_oidAlias.getProperty(string);
    }

    boolean supportsName(Oid oid) {
        int n = 0;
        while (n < this.m_names.length) {
            if (this.m_names[n].equals(oid)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Mechanism oid:\t").append(this.m_oid);
        stringBuffer.append("\nMechanism alias:\t").append(MechInfo.oidStrToAlias(this.m_oid.toString()));
        stringBuffer.append("\nMy provider: ");
        if (this._V510CA83 == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this._V510CA83.getInfo());
        }
        stringBuffer.append("\nSupported Names:\t");
        int n = 0;
        while (n < this.m_names.length) {
            stringBuffer.append(this.m_names[n].toString()).append(" ");
            ++n;
        }
        stringBuffer.append("\nName Class:\t").append(this._V2395ABD);
        stringBuffer.append("\nCred Class:\t").append(this._V901D6C2);
        stringBuffer.append("\nCtxt Class:\t").append(this._V108CA91);
        return stringBuffer.toString();
    }

    private static synchronized void updateOidAlias(Provider provider, String string) {
        if (M_oidAlias.getProperty(string) != null) {
            return;
        }
        String string2 = ((Properties)provider).getProperty("JGSS.Mech." + string + ".Alias");
        if (string2 != null) {
            ((Hashtable)M_oidAlias).put(string, string2);
            ((Hashtable)M_oidAlias).put(string2, string);
        }
    }
}

