/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Fattr;
import com.sun.rpc.Xdr;
import java.util.Date;

class Fattr3
extends Fattr {
    int ftype;
    long mode;
    long nlink;
    long uid;
    long gid;
    long size;
    long used;
    long rdev;
    long fsid;
    long fileid;
    long atime;
    long mtime;
    long ctime;

    Fattr3() {
    }

    Fattr3(Xdr xdr) {
        this.getFattr(xdr);
    }

    void getFattr(Xdr xdr) {
        long l = this.mtime;
        this.ftype = xdr.xdr_int();
        this.mode = xdr.xdr_u_int();
        this.nlink = xdr.xdr_u_int();
        this.uid = xdr.xdr_u_int();
        if (this.uid == -2L) {
            this.uid = 60001L;
        }
        this.gid = xdr.xdr_u_int();
        if (this.gid == -2L) {
            this.gid = 60001L;
        }
        this.size = xdr.xdr_hyper();
        this.used = xdr.xdr_hyper();
        this.rdev = xdr.xdr_hyper();
        this.fsid = xdr.xdr_hyper();
        this.fileid = xdr.xdr_hyper();
        this.atime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        this.mtime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        this.ctime = xdr.xdr_u_int() * 1000L + xdr.xdr_u_int() / 1000000L;
        long l2 = this.mtime - l;
        if (l2 > 0L) {
            this.cachetime = l2;
            if (this.cachetime < 3000L) {
                this.cachetime = 3000L;
            } else if (this.cachetime > 60000L) {
                this.cachetime = 60000L;
            }
        }
        this.validtime = System.currentTimeMillis();
    }

    void putFattr(Xdr xdr) {
        xdr.xdr_int(this.ftype);
        xdr.xdr_u_int(this.mode);
        xdr.xdr_u_int(this.nlink);
        xdr.xdr_u_int(this.uid);
        xdr.xdr_u_int(this.gid);
        xdr.xdr_hyper(this.size);
        xdr.xdr_hyper(this.used);
        xdr.xdr_hyper(this.rdev);
        xdr.xdr_hyper(this.fsid);
        xdr.xdr_hyper(this.fileid);
        xdr.xdr_u_int(this.atime / 1000L);
        xdr.xdr_u_int(this.atime % 1000L * 1000000L);
        xdr.xdr_u_int(this.mtime / 1000L);
        xdr.xdr_u_int(this.mtime % 1000L * 1000000L);
        xdr.xdr_u_int(this.ctime / 1000L);
        xdr.xdr_u_int(this.ctime % 1000L * 1000000L);
    }

    public String toString() {
        return " ftype = " + this.ftype + "\n" + "  mode = 0" + Long.toOctalString(this.mode) + "\n" + " nlink = " + this.nlink + "\n" + "   uid = " + this.uid + "\n" + "   gid = " + this.gid + "\n" + "  size = " + this.size + "\n" + "  used = " + this.used + "\n" + "  rdev = 0x" + Long.toHexString(this.rdev) + "\n" + "  fsid = " + this.fsid + "\n" + "fileid = " + this.fileid + "\n" + " atime = " + new Date(this.atime) + "\n" + " mtime = " + new Date(this.mtime) + "\n" + " ctime = " + new Date(this.ctime);
    }
}

