/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.net.UnknownHostException;

public class CredUnix
extends Cred {
    private int uid;
    private int gid;
    private int[] gids;
    private String home;
    private int def_umask;
    public int status;
    static final int AUTH_UNIX = 1;
    static final int UID_NOBODY = 60001;
    static final int GID_NOBODY = 60001;
    private static final int PCNFSDPROG = 150001;
    private static final int PCNFSD_AUTH = 1;
    private static final int PCNFSD2_AUTH = 13;
    private static final int MAXREPLY = 512;
    static final int AUTH_RES_OK = 0;
    static final int AUTH_RES_FAKE = 1;
    static final int AUTH_RES_FAIL = 2;
    private Xdr cr = new Xdr(64);

    public CredUnix() {
        this(60001, 60001);
    }

    public CredUnix(int n, int n2) {
        this.uid = n;
        this.gid = n2;
    }

    private boolean callV1(String string, String string2, String string3) throws UnknownHostException, IOException {
        Rpc rpc2 = new Rpc(string, 0, 150001, 1, "udp", 512);
        Xdr xdr = new Xdr(512);
        rpc2.rpc_header(xdr, 1);
        xdr.xdr_string(string2);
        xdr.xdr_string(string3);
        Xdr xdr2 = rpc2.rpc_call(xdr, 10000, 2);
        this.status = xdr2.xdr_int();
        if (this.status == 2) {
            return false;
        }
        this.uid = xdr2.xdr_int();
        this.gid = xdr2.xdr_int();
        this.gids = null;
        this.home = null;
        this.def_umask = 0;
        return true;
    }

    private boolean callV2(String string, String string2, String string3) throws UnknownHostException, IOException {
        Rpc rpc2 = new Rpc(string, 0, 150001, 2, "udp", 512);
        Xdr xdr = new Xdr(512);
        rpc2.rpc_header(xdr, 13);
        xdr.xdr_string("(anyhost)");
        xdr.xdr_string(string2);
        xdr.xdr_string(string3);
        xdr.xdr_string("Java client");
        Xdr xdr2 = rpc2.rpc_call(xdr, 10000, 2);
        this.status = xdr2.xdr_int();
        if (this.status == 2) {
            return false;
        }
        this.uid = xdr2.xdr_int();
        this.gid = xdr2.xdr_int();
        this.gids = new int[xdr2.xdr_int()];
        int n = 0;
        while (n < this.gids.length) {
            this.gids[n] = xdr2.xdr_int();
            ++n;
        }
        this.home = xdr2.xdr_string();
        this.def_umask = xdr2.xdr_int();
        return true;
    }

    public void destroy(Rpc rpc2) {
    }

    private String disguise(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(byArray[n] & 0x7F ^ 0x5B);
            ++n;
        }
        return new String(byArray);
    }

    public boolean fetchCred(String string, String string2, String string3) {
        string2 = this.disguise(string2);
        string3 = this.disguise(string3);
        try {
            try {
                return this.callV2(string, string2, string3);
            }
            catch (MsgAcceptedException msgAcceptedException) {
                if (msgAcceptedException.error != 2) {
                    return false;
                }
                return this.callV1(string, string2, string3);
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    void getCred(Xdr xdr) {
        xdr.xdr_int();
        xdr.xdr_int();
        xdr.xdr_int();
        xdr.xdr_string();
        this.uid = xdr.xdr_int();
        this.gid = xdr.xdr_int();
        int n = xdr.xdr_int();
        if (n > 0) {
            this.gids = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gids[n2] = xdr.xdr_int();
                ++n2;
            }
        }
        xdr.xdr_int();
        xdr.xdr_int();
    }

    public int getGid() {
        return this.gid;
    }

    public int[] getGids() {
        return this.gids;
    }

    public String getHome() {
        return this.home;
    }

    public int getUid() {
        return this.uid;
    }

    public int getUmask() {
        return this.def_umask;
    }

    public void init(Connection connection, int n, int n2) {
    }

    synchronized void putCred(Xdr xdr) {
        xdr.xdr_int(1);
        this.cr.xdr_offset(0);
        this.cr.xdr_int((int)(System.currentTimeMillis() / 1000L));
        this.cr.xdr_string("javaclient");
        this.cr.xdr_int(this.uid);
        this.cr.xdr_int(this.gid);
        if (this.gids == null) {
            this.cr.xdr_int(0);
        } else {
            this.cr.xdr_int(this.gids.length);
            int n = 0;
            while (n < this.gids.length) {
                this.cr.xdr_int(this.gids[n]);
                ++n;
            }
        }
        xdr.xdr_bytes(this.cr);
        xdr.xdr_int(0);
        xdr.xdr_int(0);
    }

    public boolean refresh(Connection connection, int n, int n2) {
        return true;
    }

    public void setCred() {
        this.uid = 60001;
        this.gid = 60001;
        this.gids = null;
    }

    public void setCred(int n, int n2, int[] nArray) {
        this.uid = n;
        this.gid = n2;
        this.gids = nArray;
    }

    public String toString() {
        String string = "AUTH_UNIX:\n   uid=" + this.uid + ",gid=" + this.gid + "\n";
        if (this.gids != null) {
            string = String.valueOf(string) + "   gids=";
            int n = 0;
            while (n < this.gids.length) {
                string = String.valueOf(string) + this.gids[n] + " ";
                ++n;
            }
        }
        if (this.home != null) {
            string = String.valueOf(string) + "\n   home=" + this.home;
        }
        if (this.def_umask != 0) {
            string = String.valueOf(string) + "\n   umask=0" + Long.toOctalString(this.def_umask);
        }
        return string;
    }

    public int unwrap(Xdr xdr) {
        return 0;
    }

    public void validate(byte[] byArray, int n) {
    }

    public void wrap(Xdr xdr, byte[] byArray) {
    }
}

