/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base.dir;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.FilesystemConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.system.LocalIO;

public class DirLister
implements ActionListener {
    private int length;
    private String[] files;
    private String[] sizes;
    private int[] perms;
    private boolean isDirectory = true;
    public boolean finished = false;
    private BasicConnection con;
    private String sortMode = null;
    private Date[] dates = null;

    public DirLister(BasicConnection con) {
        this.con = con;
        this.init();
    }

    public DirLister(BasicConnection con, String sortMode) {
        this.con = con;
        this.sortMode = sortMode;
        this.init();
    }

    public DirLister(BasicConnection con, String sortMode, boolean hide) {
        this.con = con;
        this.sortMode = sortMode;
        this.init();
        int cnt = this.files.length;
        if (hide) {
            for (int i = 0; i < this.files.length; ++i) {
                if (!this.files[i].startsWith(".") || this.files[i].startsWith("..")) continue;
                this.files[i] = null;
                --cnt;
            }
            String[] newFiles = new String[cnt];
            String[] newSizes = new String[cnt];
            int[] newPerms = new int[cnt];
            int idx = 0;
            for (int i = 0; i < this.files.length; ++i) {
                if (this.files[i] == null) continue;
                newFiles[idx] = this.files[i];
                newSizes[idx] = this.sizes[i];
                newPerms[idx] = this.perms[i];
                ++idx;
            }
            this.files = newFiles;
            this.sizes = newSizes;
            this.perms = newPerms;
            this.length = this.files.length;
        }
    }

    public void init() {
        try {
            String outfile = Settings.ls_out;
            this.con.list();
            this.files = this.con.sortLs();
            this.sizes = this.con.sortSize();
            this.length = this.files.length;
            this.perms = this.con.getPermissions();
            this.isDirectory = true;
            if (this.sortMode != null) {
                if (!this.sortMode.equals("Date")) {
                    this.sortFirst();
                }
                this.sort(this.sortMode);
            } else if (this.sortMode == null) {
                this.sortFirst();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.isDirectory = false;
        }
        this.finished = true;
    }

    private void sort(String type) {
        Vector<String> fv = new Vector<String>();
        Vector<String> sv = new Vector<String>();
        Vector<Integer> pv = new Vector<Integer>();
        if (type.equals("Reverse")) {
            for (int i = 0; i < this.length; ++i) {
                fv.add(this.files[i]);
                sv.add(this.sizes[i]);
                if (this.perms == null) continue;
                pv.add(new Integer(this.perms[i]));
            }
            Collections.sort(fv, Collections.reverseOrder());
            Object[] filesTmp = fv.toArray();
            Object[] sizesTmp = sv.toArray();
            Object[] permsTmp = null;
            if (this.perms != null) {
                permsTmp = pv.toArray();
            }
            for (int i = 0; i < this.length; ++i) {
                this.files[i] = (String)filesTmp[i];
                this.sizes[i] = (String)sizesTmp[this.length - i - 1];
                if (this.perms == null) continue;
                this.perms[i] = (Integer)permsTmp[this.length - i - 1];
            }
        } else if (type.startsWith("Size")) {
            int cnt = 0;
            Hashtable<String, String> processed = new Hashtable<String, String>();
            boolean reverse = false;
            if (type.endsWith("/Re")) {
                reverse = true;
            }
            while (cnt < this.length) {
                int idx = 0;
                double current = 0.0;
                if (reverse) {
                    current = Double.MAX_VALUE;
                }
                for (int i = 0; i < this.length; ++i) {
                    if (processed.containsKey("" + i)) continue;
                    int si = Integer.parseInt(this.sizes[i]);
                    if (!reverse && (double)si >= current) {
                        idx = i;
                        current = si;
                        continue;
                    }
                    if (!reverse || !((double)si <= current)) continue;
                    idx = i;
                    current = si;
                }
                processed.put("" + idx, "" + this.sizes[idx]);
                fv.add(this.files[idx]);
                sv.add(this.sizes[idx]);
                if (this.perms != null) {
                    pv.add(new Integer(this.perms[idx]));
                }
                ++cnt;
            }
            for (int i = 0; i < this.length; ++i) {
                this.files[i] = (String)fv.elementAt(i);
                this.sizes[i] = (String)sv.elementAt(i);
                if (this.perms == null) continue;
                this.perms[i] = (Integer)pv.elementAt(i);
            }
        } else if (type.equals("Date")) {
            String style = "ftp";
            if ((!(this.con instanceof FtpConnection) || ((FtpConnection)this.con).dateVector == null || ((FtpConnection)this.con).dateVector.size() < 1) && this.con instanceof FilesystemConnection && ((FilesystemConnection)this.con).dateVector != null && ((FilesystemConnection)this.con).dateVector.size() >= 1) {
                style = "file";
            }
            Object[] date = null;
            date = style.equals("ftp") ? ((FtpConnection)this.con).dateVector.toArray() : ((FilesystemConnection)this.con).dateVector.toArray();
            block5: for (int j = 0; j < date.length; ++j) {
                for (int i = 0; i < date.length; ++i) {
                    Date x = (Date)date[i];
                    if (i == date.length - 1) continue block5;
                    if (!this.comp(x, (Date)date[i + 1])) continue;
                    Date swp = (Date)date[i + 1];
                    date[i + 1] = x;
                    date[i] = swp;
                    String s1 = this.files[i + 1];
                    String s2 = this.files[i];
                    this.files[i] = s1;
                    this.files[i + 1] = s2;
                    s1 = this.sizes[i + 1];
                    s2 = this.sizes[i];
                    this.sizes[i] = s1;
                    this.sizes[i + 1] = s2;
                    int s3 = this.perms[i + 1];
                    int s4 = this.perms[i];
                    this.perms[i] = s3;
                    this.perms[i + 1] = s4;
                }
            }
            this.dates = new Date[date.length];
            for (int i = 0; i < this.dates.length; ++i) {
                this.dates[i] = (Date)date[i];
            }
        } else if (type.equals("Normal")) {
            // empty if block
        }
    }

    private boolean comp(Date one, Date two) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(one);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.clear();
        c2.setTime(two);
        return c.getTime().compareTo(c2.getTime()) > 0;
    }

    public void sortFirst() {
        String[] tmpx = new String[this.length];
        for (int x = 0; x < this.length; ++x) {
            tmpx[x] = this.perms != null ? this.files[x] + "@@@" + this.sizes[x] + "@@@" + this.perms[x] : this.files[x] + "@@@" + this.sizes[x];
        }
        LocalIO.sortStrings(tmpx);
        for (int y = 0; y < this.length; ++y) {
            this.files[y] = tmpx[y].substring(0, tmpx[y].indexOf("@@@"));
            String tmp = tmpx[y].substring(tmpx[y].indexOf("@@@") + 3);
            this.sizes[y] = tmp.substring(0, tmp.lastIndexOf("@@@"));
            if (this.perms == null) continue;
            this.perms[y] = Integer.parseInt(tmpx[y].substring(tmpx[y].lastIndexOf("@@@") + 3));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean isOk() {
        return this.isDirectory;
    }

    public int getLength() {
        return this.length;
    }

    public String[] list() {
        return this.files;
    }

    public String[] sList() {
        return this.sizes;
    }

    public int[] getPermissions() {
        return this.perms;
    }

    public Date[] getDates() {
        return this.dates;
    }
}

