/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.hostchooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.LoadSet;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.FtpHost;
import net.sf.jftp.gui.framework.HButton;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HInsetPanel;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.framework.HPasswordField;
import net.sf.jftp.gui.framework.HTextField;
import net.sf.jftp.gui.tasks.HostList;
import net.sf.jftp.net.FilesystemConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.FtpURLConnection;
import net.sf.jftp.net.wrappers.StartConnection;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class HostChooser
extends HFrame
implements ActionListener,
WindowListener {
    public HTextField host = new HTextField("Hostname:", "localhost        ");
    public HTextField user = new HTextField("Username:", "anonymous        ");
    public HPasswordField pass = new HPasswordField("Password:", "none@nowhere.no");
    public HTextField port = new HTextField("Port:    ", "21");
    public HTextField cwd = new HTextField("Remote:  ", "<default>");
    public HTextField lcwd = new HTextField("Local:   ", Settings.defaultWorkDir);
    public HTextField dl = new HTextField("Max. connections:    ", "3");
    public HTextField crlf = new HTextField("Override server newline:    ", "<default>");
    private JCheckBox anonBox = new JCheckBox("Use anonymous login", false);
    private JCheckBox listBox = new JCheckBox("LIST compatibility mode", false);
    private JCheckBox dirBox = new JCheckBox("Use default directories", Settings.getUseDefaultDir());
    private JCheckBox modeBox = new JCheckBox("Use active Ftp (no need to)", false);
    private JCheckBox threadBox = new JCheckBox("Multiple connections", false);
    private HPanel okP = new HPanel();
    private HButton ok = new HButton("Connect");
    private HButton backMode = new HButton("Yes");
    private HButton frontMode = new HButton("No");
    private HFrame h = new HFrame();
    private HPanel listP = new HPanel();
    private HButton list = new HButton("Choose from or edit list...");
    private ComponentListener listener = null;
    private int mode = 0;
    private boolean useLocal = false;
    private boolean ext = Settings.showNewlineOption;

    public HostChooser(ComponentListener l, boolean local) {
        this.listener = l;
        this.useLocal = local;
        this.init();
    }

    public HostChooser(ComponentListener l) {
        this.listener = l;
        this.init();
    }

    public HostChooser() {
        this.init();
    }

    public void init() {
        this.setTitle("Ftp Connection...");
        this.setBackground(this.okP.getBackground());
        this.anonBox.setSelected(false);
        this.user.setEnabled(true);
        this.pass.text.setEnabled(true);
        try {
            LoadSet l = new LoadSet();
            String[] login = LoadSet.loadSet(Settings.login_def);
            if (login != null && login[0] != null) {
                this.host.setText(login[0]);
                this.user.setText(login[1]);
                if (login[3] != null) {
                    this.port.setText(login[3]);
                }
                if (login[4] != null) {
                    this.cwd.setText(login[4]);
                }
                if (login[5] != null) {
                    this.lcwd.setText(login[5]);
                }
            }
            if (Settings.getStorePasswords()) {
                if (login != null && login[2] != null) {
                    this.pass.setText(login[2]);
                }
            } else {
                this.pass.setText("");
            }
        }
        catch (Exception ex) {
            Log.debug("Error initializing connection values!");
        }
        HInsetPanel root = new HInsetPanel();
        root.setLayout(new MigLayout());
        root.add(this.host);
        root.add((Component)this.port, "wrap");
        root.add(this.user);
        root.add((Component)this.pass, "wrap");
        root.add((Component)this.anonBox, "wrap");
        root.add((Component)new JLabel(" "), "wrap");
        root.add((Component)this.dirBox, "wrap");
        root.add(this.lcwd);
        root.add((Component)this.cwd, "wrap");
        root.add((Component)new JLabel(" "), "wrap");
        root.add(this.listBox);
        root.add((Component)this.modeBox, "wrap");
        root.add(this.threadBox);
        root.add((Component)this.dl, "wrap");
        root.add((Component)new JLabel(" "), "wrap");
        if (this.ext) {
            root.add(this.crlf);
            JPanel x1 = new JPanel();
            x1.setLayout(new BorderLayout(2, 2));
            JLabel l1 = new JLabel("Unix: LF, Mac/MVS: CR, Win: CRLF");
            l1.setFont(new Font("Dialog", 0, 10));
            JLabel l2 = new JLabel("Don't change this unless you transfer text only");
            l2.setFont(new Font("Dialog", 0, 10));
            x1.add("North", l1);
            x1.add("South", l2);
            root.add((Component)x1, "wrap");
        }
        this.modeBox.setSelected(!Settings.getFtpPasvMode());
        this.threadBox.setSelected(Settings.getEnableMultiThreading());
        this.dirBox.setSelected(Settings.getUseDefaultDir());
        this.anonBox.addActionListener(this);
        this.threadBox.addActionListener(this);
        root.add(this.listP);
        this.listP.add(this.list);
        this.list.addActionListener(this);
        root.add((Component)this.okP, "align right");
        this.okP.add(this.ok);
        this.ok.addActionListener(this);
        this.dirBox.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.lcwd.setEnabled(!this.dirBox.isSelected());
        this.cwd.setEnabled(!this.dirBox.isSelected());
        this.pass.text.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add("Center", root);
        this.pack();
        this.setModal(false);
        this.setVisible(false);
        this.addWindowListener(this);
        this.prepareBackgroundMessage();
    }

    public void update() {
        this.fixLocation();
        this.setVisible(true);
        this.toFront();
        this.host.requestFocus();
    }

    public void update(String url) {
        try {
            FtpURLConnection uc = new FtpURLConnection(new URL(url));
            FtpConnection con = uc.getFtpConnection();
            JFtp.statusP.jftp.addConnection(url, con);
            uc.connect();
            int response = uc.getLoginResponse();
            if (response != 2) {
                this.setTitle("Wrong password!");
                this.host.setText(uc.getHost());
                this.port.setText(Integer.toString(uc.getPort()));
                this.user.setText(uc.getUser());
                this.pass.setText(uc.getPass());
                this.setVisible(true);
                this.toFront();
                this.host.requestFocus();
            } else {
                this.dispose();
                if (this.listener != null) {
                    this.listener.componentResized(new ComponentEvent(this, 0));
                }
                JFtp.mainFrame.setVisible(true);
                JFtp.mainFrame.toFront();
            }
        }
        catch (IOException ex) {
            Log.debug("Error!");
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok || e.getSource() == this.pass.text) {
            String ltmp;
            String dtmp;
            int x;
            this.setCursor(new Cursor(3));
            Object con = null;
            JFtp.setHost(this.host.getText());
            String htmp = StringUtils.cut(this.host.getText(), " ");
            String utmp = StringUtils.cut(this.user.getText(), " ");
            String ptmp = StringUtils.cut(this.pass.getText(), " ");
            String potmp = StringUtils.cut(this.port.getText(), " ");
            Settings.setProperty("jftp.ftpPasvMode", !this.modeBox.isSelected());
            Settings.setProperty("jftp.enableMultiThreading", this.threadBox.isSelected());
            Settings.setProperty("jftp.useDefaultDir", this.dirBox.isSelected());
            FtpConnection.LIST = this.listBox.isSelected() ? "LIST" : "LIST -laL";
            JFtp.hostinfo.hostname = htmp;
            JFtp.hostinfo.username = utmp;
            JFtp.hostinfo.password = ptmp;
            JFtp.hostinfo.port = potmp;
            JFtp.hostinfo.type = "ftp";
            boolean pasv = Settings.getFtpPasvMode();
            boolean threads = Settings.getEnableMultiThreading();
            Settings.maxConnections = x = Integer.parseInt(this.dl.getText().trim());
            Settings.save();
            if (this.dirBox.isSelected()) {
                dtmp = "<default>";
                ltmp = Settings.defaultWorkDir;
            } else {
                dtmp = this.cwd.getText();
                ltmp = this.lcwd.getText();
            }
            SaveSet s = new SaveSet(Settings.login_def, htmp, utmp, ptmp, potmp, dtmp, ltmp);
            if (JFtp.localDir instanceof FilesystemConnection && !JFtp.localDir.setPath(ltmp) && !JFtp.localDir.setPath(System.getProperty("user.home"))) {
                JFtp.localDir.setPath("/");
            }
            int response = StartConnection.startFtpCon(htmp, utmp, ptmp, Integer.parseInt(potmp), dtmp, this.useLocal, this.crlf.getText().trim());
            this.setCursor(new Cursor(0));
            this.dispose();
            JFtp.mainFrame.setVisible(true);
            JFtp.mainFrame.toFront();
            if (this.listener != null) {
                this.listener.componentResized(new ComponentEvent(this, 0));
            }
        } else if (e.getSource() == this.list) {
            HostList hl = new HostList(this);
            FtpHost selectedHost = hl.getFtpHost();
            if (selectedHost == null) {
                return;
            }
            this.host.setText(selectedHost.hostname);
            this.pass.setText(selectedHost.password);
            this.user.setText(selectedHost.username);
            this.port.setText(selectedHost.port);
            Settings.setProperty("jftp.useDefaultDir", true);
            this.dirBox.setSelected(Settings.getUseDefaultDir());
            this.lcwd.setEnabled(!this.dirBox.isSelected());
            this.cwd.setEnabled(!this.dirBox.isSelected());
        } else if (e.getSource() == this.dirBox) {
            if (!this.dirBox.isSelected()) {
                this.lcwd.setEnabled(true);
                this.cwd.setEnabled(true);
            } else {
                this.lcwd.setEnabled(false);
                this.cwd.setEnabled(false);
            }
        } else if (e.getSource() == this.anonBox) {
            if (!this.anonBox.isSelected()) {
                this.user.setEnabled(true);
                this.pass.text.setEnabled(true);
            } else {
                this.user.setText("anonymous");
                this.pass.setText("no@no.no");
                this.user.setEnabled(false);
                this.pass.text.setEnabled(false);
            }
        } else if (e.getSource() == this.threadBox) {
            if (this.threadBox.isSelected()) {
                this.dl.setEnabled(true);
            } else {
                this.dl.setEnabled(false);
            }
        } else if (e.getSource() == this.backMode) {
            this.mode = 1;
            this.h.setVisible(false);
        } else if (e.getSource() == this.frontMode) {
            this.mode = 2;
            this.h.setVisible(false);
        }
    }

    private void prepareBackgroundMessage() {
        HPanel p = new HPanel();
        p.add(this.backMode);
        p.add(this.frontMode);
        p.setLayout(new FlowLayout(1));
        this.backMode.addActionListener(this);
        this.frontMode.addActionListener(this);
        this.h.getContentPane().setLayout(new BorderLayout(10, 10));
        this.h.setTitle("Connection failed!");
        this.h.setLocation(150, 200);
        JTextArea text = new JTextArea();
        this.h.getContentPane().add("Center", text);
        this.h.getContentPane().add("South", p);
        text.setText(" ---------------- Output -----------------\n\nThe server is busy at the moment.\n\nDo you want JFtp to go to disappear and try to login\ncontinuously?\n\n(It will show up again when it has initiated a connection)\n\n");
        JFtp.log.setText("");
        text.setEditable(false);
        this.h.pack();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryFtpAgain(int response, String htmp, String ptmp, String utmp, String potmp, String dtmp, boolean useLocal) {
        if (response == -7 && Settings.reconnect) {
            this.setCursor(new Cursor(0));
            this.h.setVisible(true);
            while (this.mode == 0) {
                this.pause(10);
            }
        } else {
            if (response == 2) {
                if (response != -7) return;
                if (Settings.reconnect) return;
            }
            this.setCursor(new Cursor(0));
            if (useLocal) {
                JFtp.statusP.jftp.closeCurrentLocalTab();
                return;
            }
            JFtp.statusP.jftp.closeCurrentTab();
            return;
        }
        JFtp.mainFrame.setVisible(false);
        while (true) {
            int i;
            if (response == -7 && this.mode == 1) {
                System.out.print("Server is full, next attempt in ");
                i = 0;
            } else {
                if (this.mode == 1) {
                    JFtp.mainFrame.setVisible(true);
                    return;
                }
                JFtp.mainFrame.setVisible(false);
                this.setVisible(true);
                this.toFront();
                return;
            }
            for (int r = 5; i < r; --r) {
                System.out.print("" + r + "-");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            System.out.println("0...");
            response = StartConnection.startFtpCon(htmp, utmp, ptmp, Integer.parseInt(potmp), dtmp, useLocal);
        }
    }
}

