/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.tasks.LastConnections;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.wrappers.NfsConnection;
import net.sf.jftp.net.wrappers.SmbConnection;
import net.sf.jftp.system.logging.Log;

public class StartConnection {
    public static FtpConnection con = null;
    public static String keyfile = null;

    public static void setSshKeyfile(String file) {
        keyfile = file;
    }

    public static boolean startCon(String protocol, String htmp, String utmp, String ptmp, int potmp, String dtmp, boolean useLocal) {
        String[] searchValue = new String[10];
        Integer potmpInt = new Integer(potmp);
        String useLocalString = new String("false");
        if (useLocal) {
            useLocalString = "true";
        }
        if (!protocol.equals("FTP")) {
            if (protocol.equals("SMB")) {
                SmbConnection con = null;
                try {
                    con = new SmbConnection(htmp, dtmp, utmp, ptmp, (ConnectionListener)((Object)JFtp.remoteDir));
                    if (useLocal) {
                        JFtp.statusP.jftp.addLocalConnection(htmp, con);
                        if (con.isConnected()) {
                            JFtp.localDir.setPath("");
                            JFtp.localDir.fresh();
                        }
                    } else {
                        JFtp.statusP.jftp.addConnection(htmp, con);
                        if (con.isConnected()) {
                            JFtp.remoteDir.setPath("");
                            JFtp.remoteDir.fresh();
                        }
                    }
                    searchValue[0] = "SMB";
                    searchValue[1] = htmp;
                    searchValue[2] = utmp;
                    searchValue[3] = Settings.getStorePasswords() ? ptmp : "";
                    searchValue[4] = dtmp;
                    searchValue[5] = useLocalString;
                    searchValue[6] = LastConnections.SENTINEL;
                    StartConnection.updateFileMenu(searchValue);
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Log.debug("Could not create SMBConnection, does this distribution come with jcifs?");
                }
            } else {
                boolean status = true;
                NfsConnection con = new NfsConnection(htmp);
                if (!utmp.equals("<anonymous>")) {
                    status = con.login(utmp, ptmp);
                }
                if (useLocal) {
                    con.setLocalPath("/");
                    JFtp.statusP.jftp.addLocalConnection(htmp, con);
                } else {
                    JFtp.statusP.jftp.addConnection(htmp, con);
                }
                con.chdir(htmp);
                searchValue[0] = "NFS";
                searchValue[1] = htmp;
                searchValue[2] = utmp;
                searchValue[3] = Settings.getStorePasswords() ? ptmp : "";
                searchValue[4] = useLocalString;
                searchValue[5] = LastConnections.SENTINEL;
                StartConnection.updateFileMenu(searchValue);
                return status;
            }
        }
        return true;
    }

    public static int startFtpCon(String htmp, String utmp, String ptmp, int potmp, String dtmp, boolean useLocal) {
        return StartConnection.startFtpCon(htmp, utmp, ptmp, potmp, dtmp, useLocal, null);
    }

    public static int startFtpCon(String htmp, String utmp, String ptmp, int potmp, String dtmp, boolean useLocal, String crlf) {
        boolean pasv = Settings.getFtpPasvMode();
        boolean threads = Settings.getEnableMultiThreading();
        String[] searchValue = new String[10];
        con = new FtpConnection(htmp, potmp, dtmp, crlf);
        if (useLocal) {
            JFtp.statusP.jftp.addLocalConnection(htmp, con);
        } else {
            JFtp.statusP.jftp.addConnection(htmp, con);
        }
        int response = con.login(utmp, ptmp);
        if (response == 2) {
            Integer potmpInt = new Integer(potmp);
            String potmpString = potmpInt.toString();
            String useLocalString = new String("false");
            if (useLocal) {
                useLocalString = "true";
            }
            searchValue[0] = "FTP";
            searchValue[1] = htmp;
            searchValue[2] = utmp;
            searchValue[3] = Settings.getStorePasswords() ? ptmp : "";
            searchValue[4] = potmpString;
            searchValue[5] = dtmp;
            searchValue[6] = useLocalString;
            searchValue[7] = LastConnections.SENTINEL;
            StartConnection.updateFileMenu(searchValue);
        } else if (useLocal) {
            JFtp.statusP.jftp.closeCurrentLocalTab();
        } else {
            JFtp.statusP.jftp.closeCurrentTab();
        }
        return response;
    }

    private static void updateFileMenu(String[] searchValue) {
        int position = LastConnections.findString(searchValue, 9);
        String[][] newVals = new String[9][10];
        newVals = position >= 0 ? LastConnections.moveToFront(position, 9) : LastConnections.prepend(searchValue, 9, true);
    }
}

