/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.system.logging;

import net.sf.jftp.config.Settings;
import net.sf.jftp.system.logging.Logger;
import net.sf.jftp.system.logging.SystemLogger;

public class Log {
    private static Logger logger = new SystemLogger();
    private static Log log = new Log();
    private static StringBuffer cache = new StringBuffer();

    private Log() {
    }

    public static void setLogger(Logger logger) {
        Log.logger = logger;
    }

    public static void debug(String msg) {
        if (Settings.getDisableLog()) {
            return;
        }
        logger.debug(msg);
        cache.append(msg + "\n");
        if (!Settings.getEnableDebug()) {
            System.out.println("> " + msg);
        }
    }

    public static void debugRaw(String msg) {
        if (Settings.getDisableLog()) {
            return;
        }
        logger.debugRaw(msg);
        cache.append(msg);
        if (Settings.getEnableDebug()) {
            System.out.print(msg);
        }
    }

    public static void out(String msg) {
        if (!Settings.getEnableDebug()) {
            return;
        }
        System.out.println("> " + msg);
    }

    public static void devnull(Object msg) {
    }

    public static String getCache() {
        return cache.toString();
    }

    public static void clearCache() {
        cache = new StringBuffer();
    }
}

