/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.PropertyBodyHelper;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class AclReportMethod
extends XMLResponseMethodBase
implements DepthSupport {
    public static final int PRINCIPAL_PROPERTY_SEARCH = 1;
    private PropertyBodyHelper propertyBodyHelper = null;
    private int depth = Integer.MAX_VALUE;
    private int reportType = 0;

    public AclReportMethod(String path, Collection propertyNames, int depth, int reportType) {
        super(path);
        this.setDepth(depth);
        this.reportType = reportType;
        this.propertyBodyHelper = new PropertyBodyHelper();
        this.propertyBodyHelper.setPropertyNames(propertyNames);
    }

    public String getName() {
        return "REPORT";
    }

    public void setDepth(int depth) {
        this.checkNotUsed();
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("Depth")) {
            int depth = -1;
            if (headerValue.equals("0")) {
                depth = 0;
            }
            if (headerValue.equals("1")) {
                depth = 1;
            } else if (headerValue.equalsIgnoreCase("infinity")) {
                depth = Integer.MAX_VALUE;
            }
            this.setDepth(depth);
        } else {
            super.setRequestHeader(headerName, headerValue);
        }
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        switch (this.getDepth()) {
            case 0: {
                super.setRequestHeader("Depth", "0");
                break;
            }
            case 1: {
                super.setRequestHeader("Depth", "1");
                break;
            }
            case 0x7FFFFFFF: {
                super.setRequestHeader("Depth", "infinity");
            }
        }
    }

    protected String generateRequestBody() {
        XMLPrinter printer = new XMLPrinter();
        printer.writeXMLHeader();
        switch (this.reportType) {
            case 1: {
                this.generatePrincipalPropertySearchBody(printer);
                break;
            }
            default: {
                System.err.println("AclReportMethod: type not supported " + this.reportType);
            }
        }
        return printer.toString();
    }

    private void generatePrincipalPropertySearchBody(XMLPrinter printer) {
        printer.writeElement("D", "DAV:", "principal-property-search", 0);
        printer.writeElement("D", "property-search", 0);
        printer.writeElement("D", "prop", 0);
        printer.writeElement("D", "displayname", 2);
        printer.writeElement("D", "prop", 1);
        printer.writeElement("D", "caseless-substring", 2);
        printer.writeElement("D", "property-search", 1);
        this.propertyBodyHelper.wirtePropElement(printer);
        printer.writeElement("D", "principal-property-search", 1);
    }
}

