/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.Key;
import com.sonoransoft.codequill.LinkedList;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class CommandLine
extends TextField
implements KeyListener,
FocusListener {
    private LinkedList commandList = new LinkedList();
    private LinkedList searchList = new LinkedList();
    private LinkedList lineList = this.commandList;
    private int listSize = 16;
    public static final int NO_REQUEST = 0;
    public static final int SEARCH_FORWARD = 1;
    public static final int SEARCH_BACK = 2;
    public static final int PROCESS_COMMAND = 3;
    private int searchRequest = 0;
    private boolean traversable = true;

    CommandLine() {
        this.commandList.add("");
        this.searchList.add("");
        this.addFocusListener(this);
    }

    CommandLine(int n) {
        this.commandList.add("");
        this.searchList.add("");
        this.listSize = n;
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public int getSearchRequest() {
        int n = this.searchRequest;
        this.searchRequest = 0;
        return n;
    }

    public void requestSearchForward() {
        this.searchRequest = 1;
        this.lineList = this.searchList;
        this.clear();
        this.requestFocus();
    }

    public void requestCommand() {
        this.searchRequest = 3;
        this.lineList = this.commandList;
        this.clear();
        this.requestFocus();
    }

    public void requestSearchBack() {
        this.searchRequest = 2;
        this.lineList = this.searchList;
        this.clear();
        this.requestFocus();
    }

    public void setSaveDepth(int n) {
        this.listSize = n;
        this.lineList.first();
        while (this.lineList.getSize() > this.listSize) {
            this.lineList.remove();
        }
        this.lineList.last();
    }

    public String getSearchString() {
        if (this.getText().length() == 0) {
            this.searchList.last();
            this.searchList.previous();
            return (String)this.searchList.get();
        }
        return this.getText();
    }

    public String getCommandString() {
        return this.getText();
    }

    public void clear() {
        this.setText("");
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isTransferable() {
        return false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.addKeyListener(this);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.removeKeyListener(this);
    }

    public void keyPressed(KeyEvent keyEvent) {
        Key key = new Key(keyEvent);
        boolean bl = false;
        switch (key.getKeyCode()) {
            case 38: {
                if (this.lineList.previous()) {
                    this.setText((String)this.lineList.get());
                    this.setCaretPosition(this.getText().length());
                }
                bl = true;
                break;
            }
            case 40: {
                if (this.lineList.next()) {
                    this.setText((String)this.lineList.get());
                    this.setCaretPosition(this.getText().length());
                } else {
                    this.setText("");
                }
                bl = true;
                break;
            }
            case 10: {
                if (this.getText().length() != 0) {
                    if (this.lineList.getSize() > this.listSize) {
                        this.lineList.first();
                        this.lineList.remove();
                    }
                    this.lineList.last();
                    this.lineList.insert(this.getText());
                    break;
                }
                bl = true;
                break;
            }
            case 27: {
                this.clear();
                break;
            }
            case 9: {
                bl = true;
                break;
            }
            case 86: {
                if (!keyEvent.isControlDown()) break;
                this.paste();
                bl = true;
                break;
            }
            case 67: {
                if (!keyEvent.isControlDown()) break;
                this.copy();
                bl = true;
                break;
            }
            case 88: {
                if (!keyEvent.isControlDown()) break;
                this.cut();
                bl = true;
                break;
            }
            case 155: {
                if (keyEvent.isShiftDown()) {
                    this.paste();
                    bl = true;
                    break;
                }
                if (!keyEvent.isControlDown()) break;
                this.copy();
                bl = true;
                break;
            }
            case 127: {
                if (!keyEvent.isShiftDown()) break;
                this.cut();
                bl = true;
                break;
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    private void cut() {
        int n = this.getCaretPosition();
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        if (this.copy()) {
            String string = this.getText();
            String string2 = string.substring(0, n2);
            string2 = string2 + string.substring(n3);
            this.setText(string2);
            this.setCaretPosition(n2);
        }
    }

    private boolean copy() {
        String string = this.getSelectedText();
        if (string.length() > 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
            return true;
        }
        return false;
    }

    private void paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            CharSequence charSequence;
            int n = this.getCaretPosition();
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            CharSequence charSequence2 = this.getText();
            if (n2 != n3) {
                charSequence = charSequence2.substring(0, n2) + charSequence2.substring(n3);
                charSequence2 = charSequence;
            }
            charSequence = new StringBuffer((String)charSequence2);
            String string = this.getPasteText(transferable);
            if (string != null) {
                ((StringBuffer)charSequence).insert(n, string);
                this.setText(((StringBuffer)charSequence).toString());
                this.setCaretPosition(n + string.length());
            }
        }
    }

    private String getPasteText(Transferable transferable) {
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = new StringBuffer();
            String string = null;
            StringReader stringReader = new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor));
            BufferedReader bufferedReader = new BufferedReader(stringReader);
            string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return stringBuffer.toString();
    }

    private void resetMarkedArea() {
        int n = this.getCaretPosition();
        this.select(n, n);
        this.setCaretPosition(n);
    }

    public boolean isFocusTraversable() {
        return this.traversable;
    }

    public void setFocusTraversable(boolean bl) {
        this.traversable = bl;
    }
}

