/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.CodeQuill;
import com.sonoransoft.codequill.CqMessageDialog;
import com.sonoransoft.codequill.DecisionDialog;
import com.sonoransoft.codequill.EditSession;
import com.sonoransoft.codequill.ExitDialog;
import com.sonoransoft.codequill.LinkedList;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;

public class ExitClient {
    private EditSession editSession = null;
    private LinkedList sessionList;
    private ExitDialog dialog;
    private CodeQuill codeQuill;
    private String fileName;
    private Frame frame;

    ExitClient(Frame frame, CodeQuill codeQuill, LinkedList linkedList) {
        LinkedList linkedList2 = this.buildModifiedList(linkedList);
        this.codeQuill = codeQuill;
        this.sessionList = linkedList;
        this.frame = frame;
        this.dialog = new ExitDialog(frame, linkedList2);
        this.dialog.setVisible(true);
        int[] nArray = this.dialog.getSelection();
        int n = this.dialog.getRequest();
        this.dialog.dispose();
        switch (n) {
            case 4: {
                codeQuill.codeQuillExit(true);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                this.saveSelectedFiles(nArray, linkedList2);
                if (this.isFileModified(linkedList2)) break;
                codeQuill.codeQuillExit(true);
                break;
            }
            case 1: {
                this.saveAllFiles(linkedList2);
                if (this.isFileModified(linkedList2)) break;
                codeQuill.codeQuillExit(true);
                break;
            }
            case 3: {
                this.saveAsSelectedFiles(nArray, linkedList2);
                if (this.isFileModified(linkedList2)) break;
                codeQuill.codeQuillExit(true);
                break;
            }
            case 5: {
                linkedList2.setTo(nArray[0]);
                this.editSession = (EditSession)linkedList2.get();
                break;
            }
        }
    }

    private boolean isFileModified(LinkedList linkedList) {
        linkedList.push();
        linkedList.first();
        EditSession editSession = (EditSession)linkedList.get();
        while (editSession != null) {
            if (editSession.isModified()) {
                linkedList.pop();
                return true;
            }
            editSession = (EditSession)linkedList.getNext();
        }
        linkedList.pop();
        return false;
    }

    private LinkedList buildModifiedList(LinkedList linkedList) {
        LinkedList linkedList2 = new LinkedList();
        linkedList.push();
        linkedList.first();
        EditSession editSession = (EditSession)linkedList.get();
        while (editSession != null) {
            if (editSession.isModified()) {
                linkedList2.append(editSession);
            }
            editSession = (EditSession)linkedList.getNext();
        }
        linkedList.pop();
        return linkedList2;
    }

    private void saveAllFiles(LinkedList linkedList) {
        linkedList.first();
        EditSession editSession = (EditSession)linkedList.get();
        while (editSession != null) {
            if (editSession.getName() == null) {
                this.saveAsSession(editSession);
            } else {
                switch (editSession.write()) {
                    case '\u0000': {
                        break;
                    }
                    default: {
                        this.postMessage("Could not save file");
                    }
                }
            }
            editSession = (EditSession)linkedList.getNext();
        }
    }

    private void saveSelectedFiles(int[] nArray, LinkedList linkedList) {
        int n = 0;
        while (n < nArray.length) {
            linkedList.setTo(nArray[n]);
            EditSession editSession = (EditSession)linkedList.get();
            if (editSession.getName() == null) {
                this.saveAsSession(editSession);
            } else {
                switch (editSession.write()) {
                    case '\u0000': {
                        break;
                    }
                    default: {
                        this.postMessage("Could not save file");
                    }
                }
            }
            ++n;
        }
    }

    private void saveAsSelectedFiles(int[] nArray, LinkedList linkedList) {
        int n = 0;
        while (n < nArray.length) {
            linkedList.setTo(nArray[n]);
            EditSession editSession = (EditSession)linkedList.get();
            this.saveAsSession(editSession);
            ++n;
        }
    }

    private void saveAsSession(EditSession editSession) {
        String string = "";
        FileDialog fileDialog = new FileDialog(this.frame, "Save As", 1);
        fileDialog.setDirectory(string);
        if (editSession.getName() == null) {
            fileDialog.setFile("unnamed");
        } else {
            fileDialog.setFile(editSession.getName());
        }
        ((Component)fileDialog).setVisible(true);
        String string2 = fileDialog.getFile();
        string = fileDialog.getDirectory();
        fileDialog.dispose();
        if (string2 != null && string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(string2);
            char c = editSession.write(stringBuffer.toString(), false);
            if (c != '\u0000') {
                if (c == '\u0001') {
                    DecisionDialog decisionDialog = new DecisionDialog(this.frame, "codeQuill - Warning", "File exists. Overwrite the file?", false);
                    decisionDialog.setVisible(true);
                    if (decisionDialog.getDecision()) {
                        c = editSession.write(stringBuffer.toString(), true);
                        if (c != '\u0000') {
                            this.postMessage("Could not save file");
                        }
                    } else {
                        this.postMessage("Could not save file");
                    }
                    decisionDialog.dispose();
                } else {
                    this.postMessage("Could not save file");
                }
            }
        }
    }

    public EditSession getEditSession() {
        return this.editSession;
    }

    void postMessage(String string) {
        CqMessageDialog cqMessageDialog = new CqMessageDialog(this.frame, "codeQuill message", string);
        cqMessageDialog.setVisible(true);
        cqMessageDialog.dispose();
    }
}

