/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CDocument
extends AbstractTableModel
implements TableModel {
    int type = 0;
    public static int UNKNOWN = 0;
    public static int CSS = 1;
    public static int CSS2 = 2;
    public static int HTML = 3;
    boolean changed = false;
    private File file;
    protected String filecontent;
    protected String[] linkedf;
    private JTable table;
    private JTextArea textarea;
    private JTree tree;
    private DefaultTreeModel treemodel;
    private DefaultMutableTreeNode top;
    private final TableModel cleartable = new DefaultTableModel();
    private final Frame hidenframe = new Frame();
    private JOptionPane elnamepanel;
    private JDialog elnamedialog;
    ChangeListener changelistener;
    CRule onerule = new CRule("");
    static /* synthetic */ Class class$CRuleValue;
    static /* synthetic */ Class class$CRule;

    public CDocument() {
        this.setType(CSS);
        this.initCDocument(null, null);
    }

    public CDocument(File file, Vector vector) {
        this(file, vector, UNKNOWN);
    }

    public CDocument(File file, Vector vector, int n) {
        this.setType(n);
        int n2 = vector.size();
        Object[] objectArray = new Object[n2];
        vector.copyInto(objectArray);
        this.initCDocument(file, objectArray);
    }

    public CDocument(File file, Object[] objectArray) {
        this(file, objectArray, UNKNOWN);
    }

    public CDocument(File file, Object[] objectArray, int n) {
        this.setType(n);
        this.initCDocument(file, objectArray);
    }

    public CDocument(String string) {
        this.setType(CSS);
        this.initCDocument(null, this.defDocument(string));
    }

    public CDocument(Vector vector) {
        this(vector, UNKNOWN);
    }

    public CDocument(Vector vector, int n) {
        this.setType(n);
        int n2 = vector.size();
        Object[] objectArray = new Object[n2];
        vector.copyInto(objectArray);
        this.initCDocument(null, objectArray);
    }

    public CDocument(Object[] objectArray) {
        this(objectArray, UNKNOWN);
    }

    public CDocument(Object[] objectArray, int n) {
        this.setType(n);
        this.initCDocument(null, objectArray);
    }

    public void addElement(CElement cElement) {
        int n = this.tree.getMinSelectionRow();
        int n2 = this.treemodel.getChildCount(this.top);
        if (n < 0 || n > n2) {
            n = n2;
        }
        this.treemodel.insertNodeInto(new DefaultMutableTreeNode(cElement), this.top, n);
        if (n2 == 0) {
            this.tree.expandRow(0);
        }
    }

    String askElValue(Frame frame) {
        AddDialog addDialog = new AddDialog(frame);
        String string = addDialog.ask();
        return string;
    }

    public void changed() {
        this.changed = true;
        try {
            this.changelistener.stateChanged(new ChangeEvent(this));
        }
        catch (NullPointerException nullPointerException) {}
    }

    public Vector children() {
        Vector<TreeNode> vector = new Vector<TreeNode>(this.top.getChildCount());
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void createTree() {
        this.top = new DefaultMutableTreeNode(this);
        this.treemodel = new DefaultTreeModel(this.top);
        this.tree = new JTree(this.treemodel){

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(32, 32);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                CDocument.this.treeSelectionChanged();
            }
        });
        this.treemodel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                if (CDocument.this.currentNode() == CDocument.this.top) {
                    CDocument.this.treeSelectionChanged();
                }
                CDocument.this.changed();
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                if (CDocument.this.currentNode() == CDocument.this.top) {
                    CDocument.this.treeSelectionChanged();
                }
                CDocument.this.changed();
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                CDocument.this.changed();
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
        this.tree.setCellRenderer(new CTreeRenderer(this.getType()));
        this.tree.setCellEditor(new CTreeEditor(this.tree, (DefaultTreeCellRenderer)this.tree.getCellRenderer()));
        this.tree.setEditable(true);
        this.setupPopupMenu();
    }

    public CElement currentElement() {
        Object object = this.currentNode().getUserObject();
        if (object instanceof CElement) {
            return (CElement)object;
        }
        return null;
    }

    public TableModel currentModel() {
        Object object = this.currentNode().getUserObject();
        if (object instanceof TableModel) {
            return (TableModel)object;
        }
        return null;
    }

    public DefaultMutableTreeNode currentNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    private Object[] defDocument(String string) {
        Object[] objectArray = new Object[]{new CElement(string)};
        return objectArray;
    }

    public int delSelectedElements() {
        int n = this.tree.getMinSelectionRow();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        int n2 = -1;
        if (treePathArray == null) {
            return 0;
        }
        n2 = treePathArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.removeNode((MutableTreeNode)treePathArray[n3].getLastPathComponent());
            ++n3;
        }
        try {
            this.tree.setSelectionRow(n - 1);
        }
        catch (Exception exception) {}
        return n2;
    }

    protected void finalize() {
    }

    public File getAssocFile() {
        return this.file;
    }

    protected String getAssocFileContent() {
        return this.filecontent;
    }

    public Class getColumnClass(int n) {
        return class$CRule != null ? class$CRule : (class$CRule = CDocument.class$("CRule"));
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int n) {
        return "Summary document information";
    }

    public int getElementCount() {
        return this.top.getChildCount();
    }

    public int getRowCount() {
        int n;
        try {
            n = this.linkedf.length;
        }
        catch (NullPointerException nullPointerException) {
            n = 0;
        }
        return 3 + n;
    }

    public String getShortStringType() {
        return CDocument.getShortTypeName(this.getType());
    }

    public static String getShortTypeName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Unknown";
                break;
            }
            case 1: {
                string = "CSS1";
                break;
            }
            case 2: {
                string = "CSS2";
                break;
            }
            case 3: {
                string = "HTML";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public String getStringType() {
        return CDocument.getTypeName(this.getType());
    }

    public JTable getTable() {
        return this.table;
    }

    public JTextArea getTextArea() {
        return this.textarea;
    }

    public JTree getTree() {
        return this.tree;
    }

    public int getType() {
        return this.type;
    }

    public static String getTypeName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "Unknown";
                break;
            }
            case 1: {
                string = "Cascade Style Sheets 1";
                break;
            }
            case 2: {
                string = "Cascade Style Sheets 2";
                break;
            }
            case 3: {
                string = "HyperText Markup Language (HTML)";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public Object getValueAt(int n, int n2) {
        String string = "";
        switch (n) {
            case 0: {
                string = "File name: " + this.title();
                break;
            }
            case 1: {
                string = "File type: " + CDocument.getTypeName(this.getType());
                break;
            }
            case 2: {
                string = "Selectors count: " + this.getElementCount();
                break;
            }
            default: {
                string = "Attached css (" + (n - 2) + "): " + this.linkedf[n - 3];
            }
        }
        this.onerule.setCol(0, string);
        return this.onerule;
    }

    private void initCDocument(File file, Object[] objectArray) {
        this.createTree();
        this.table = new CJTable(this.cleartable){

            public void editingStopped(ChangeEvent changeEvent) {
                super.editingStopped(changeEvent);
                try {
                    CDocument.this.updateTextArea(CDocument.this.currentElement().toText());
                    CDocument.this.changed();
                }
                catch (NullPointerException nullPointerException) {}
            }
        };
        this.setAssocFile(file);
        this.textarea = new CJTextArea();
        if (objectArray != null) {
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.addElement((CElement)objectArray[n2]);
                }
                catch (ClassCastException classCastException) {
                    System.err.println("Class cast exception, object ignored. Object[] must contain a CElement objects.");
                }
                ++n2;
            }
        }
        this.tree.expandRow(0);
        this.tree.revalidate();
        this.changed = false;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    String[] linked() {
        return HTMLLinker.listLinkedFiles(this.getAssocFileContent());
    }

    public boolean removeElement(String string) {
        Enumeration<TreeNode> enumeration = this.top.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            String string2 = ((CElement)defaultMutableTreeNode.getUserObject()).toString();
            if (string.toLowerCase().compareTo(string2.toLowerCase()) != 0) continue;
            this.removeNode(defaultMutableTreeNode);
            return true;
        }
        return false;
    }

    void removeNode(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode.isLeaf() && mutableTreeNode != this.top) {
            this.treemodel.removeNodeFromParent(mutableTreeNode);
        }
    }

    public void renameSelectedElement() {
        this.tree.startEditingAtPath(this.tree.getSelectionPath());
    }

    public void setAssocFile(File file) {
        this.file = file;
        try {
            ((CRuleValueEditor)this.getTable().getDefaultEditor(class$CRuleValue != null ? class$CRuleValue : (class$CRuleValue = CDocument.class$("CRuleValue")))).setDocumentPath(this.getAssocFile().getParent());
            this.tree.treeDidChange();
        }
        catch (Exception exception) {}
    }

    protected void setAssocFileContent(String string) {
        this.filecontent = string;
        this.linkedf = this.linked();
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changelistener = changeListener;
    }

    public boolean setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        return bl2;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    private void setupPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Clone");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)CDocument.this.tree.getPathForRow(CDocument.this.tree.getLeadSelectionRow()).getLastPathComponent();
                CElement cElement = (CElement)defaultMutableTreeNode.getUserObject();
                CDocument.this.addElement((CElement)cElement.clone());
                CDocument.this.tree.treeDidChange();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Rename");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CDocument.this.renameSelectedElement();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Delete");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CDocument.this.delSelectedElements();
            }
        });
        jPopupMenu.add(jMenuItem);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem("Add Element");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = CDocument.this.askElValue(CDocument.this.hidenframe);
                if (string != null && string.length() > 0) {
                    CDocument.this.addElement(new CElement(string));
                }
            }
        });
        jPopupMenu2.add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Select all");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CDocument.this.tree.getRowCount();
                CDocument.this.tree.setSelectionInterval(0, n);
            }
        });
        jPopupMenu2.add(jMenuItem2);
        this.tree.addMouseListener(new TreePopupListener(jPopupMenu, jPopupMenu2, this.tree));
    }

    public String title() {
        String string;
        try {
            string = this.file.getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "Untitled";
        }
        return string;
    }

    public String toString() {
        String string;
        String string2 = "  (" + this.getShortStringType() + ")";
        try {
            string = String.valueOf(this.file.getName()) + string2;
        }
        catch (NullPointerException nullPointerException) {
            string = "Untitled" + string2;
        }
        return string;
    }

    public String toText() {
        Enumeration<TreeNode> enumeration = this.top.children();
        String string = "";
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            string = String.valueOf(string) + ((CElement)defaultMutableTreeNode.getUserObject()).toText();
            string = String.valueOf(string) + "\r\n";
        }
        return string;
    }

    public String toText(Vector vector) {
        int n = vector.size();
        Enumeration<TreeNode> enumeration = this.top.children();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            CElement cElement = (CElement)defaultMutableTreeNode.getUserObject();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                CElement cElement2 = (CElement)vector.elementAt(n2);
                if (cElement2.getSelector().toLowerCase().equals(cElement.getSelector().toLowerCase())) {
                    stringBuffer.append(cElement2.toText());
                    stringBuffer.append("\r\n");
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) continue;
            stringBuffer.append(cElement.toText()).append("\r\n");
        }
        return stringBuffer.toString();
    }

    void treeSelectionChanged() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.currentNode();
        if (defaultMutableTreeNode != null) {
            TableModel tableModel = this.currentModel();
            if (tableModel instanceof TableModel) {
                this.table.setModel(tableModel);
            }
            if (this.table instanceof CJTable) {
                ((CJTable)this.table).setPrefInToMin(1);
            }
            if (tableModel instanceof CElement) {
                this.updateTextArea(((CElement)tableModel).toText());
            }
            if (tableModel instanceof CDocument) {
                this.table.editingCanceled(new ChangeEvent(this));
                this.updateTextArea(((CDocument)tableModel).toText());
            }
        } else {
            this.table.editingCanceled(new ChangeEvent(this));
            this.table.setModel(this);
            this.updateTextArea(this.toText());
        }
    }

    public void updateTextArea(String string) {
        this.textarea.setText(string);
        this.textarea.setCaretPosition(0);
    }
}

