/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class StringChooseDialog
extends JDialog {
    protected JButton okb;
    protected JButton cancelb;
    protected JRadioButton[] var;
    protected ButtonGroup grp = new ButtonGroup();
    protected PlainLabel prompt;
    protected JTextField input;
    protected StringPair[] map;
    protected String rv;
    ItemListener sl = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JRadioButton jRadioButton = (JRadioButton)itemEvent.getItem();
                StringChooseDialog.this.rv = jRadioButton.getActionCommand();
                if (!StringChooseDialog.this.rv.equals("INPUT")) {
                    StringChooseDialog.this.input.setEnabled(false);
                    StringChooseDialog.this.input.setText(jRadioButton.getActionCommand());
                } else {
                    StringChooseDialog.this.input.setEnabled(true);
                }
            }
        }
    };
    Action ok_a = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            StringChooseDialog.this.ok();
        }
    };
    Action cancel_a = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            StringChooseDialog.this.cancel();
        }
    };

    public StringChooseDialog(Frame frame, String string, String string2, StringPair[] stringPairArray) {
        super(frame, string, true);
        this.setup(stringPairArray, string2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createListPane(), "Center");
        this.getContentPane().add((Component)this.createButtonPane(), "South");
        this.getRootPane().setDefaultButton(this.okb);
        this.getRootPane().registerKeyboardAction(this.cancel_a, DialogTextIn.esc, 2);
    }

    public String ask() {
        this.show();
        return this.getValue();
    }

    void cancel() {
        this.rv = null;
        this.dispose();
    }

    JPanel createButtonPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.okb);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.cancelb);
        return jPanel;
    }

    JPanel createListPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        jPanel.add(this.prompt);
        jPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        jPanel.add(this.input);
        jPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        int n = 0;
        while (n < this.var.length) {
            this.var[n].setAlignmentX(0.0f);
            jPanel.add(this.var[n]);
            ++n;
        }
        return jPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public String getValue() {
        if (this.rv.equals("INPUT")) {
            return this.input.getText();
        }
        return this.rv;
    }

    public static void main(String[] stringArray) {
        StringPair[] stringPairArray = new StringPair[]{new StringPair("Default", "one"), new StringPair("Absolute", "two"), new StringPair("Castom", "INPUT")};
        StringChooseDialog stringChooseDialog = new StringChooseDialog((Frame)new JFrame(), "title", "Come on!", stringPairArray);
        System.out.println(stringChooseDialog.ask());
    }

    void ok() {
        this.dispose();
    }

    private void setup(StringPair[] stringPairArray, String string) {
        this.map = stringPairArray;
        this.setupButtons();
        this.setupInput();
        this.setupList(this.map);
        this.prompt = new PlainLabel(string);
    }

    void setupButtons() {
        this.okb = new JButton("Ok");
        this.okb.addActionListener(this.ok_a);
        this.cancelb = new JButton("Cancel");
        this.cancelb.addActionListener(this.cancel_a);
    }

    void setupInput() {
        this.input = new JTextField();
        this.input.setAlignmentX(0.0f);
        this.input.setMaximumSize(new Dimension(this.input.getMaximumSize().width, this.input.getPreferredSize().height));
        DialogTextIn.popupForText(this.input);
        Keymap keymap = JTextComponent.addKeymap("superMap", this.input.getKeymap());
        keymap.removeKeyStrokeBinding(DialogTextIn.enter);
        keymap.addActionForKeyStroke(DialogTextIn.enter, this.ok_a);
        this.input.setKeymap(keymap);
    }

    private void setupList(StringPair[] stringPairArray) {
        this.var = new JRadioButton[stringPairArray.length];
        int n = 0;
        while (n < stringPairArray.length) {
            this.var[n] = new JRadioButton(stringPairArray[n].left);
            this.var[n].setFocusPainted(false);
            this.var[n].setFont(PlainLabel.modifyStyle(this.var[n].getFont(), 0));
            this.var[n].setActionCommand(stringPairArray[n].right);
            this.var[n].addItemListener(this.sl);
            this.grp.add(this.var[n]);
            ++n;
        }
        if (this.var.length > 0) {
            this.var[0].setSelected(true);
        }
    }

    public void show() {
        ComponentTools.transferSize(this.cancelb, this.okb);
        this.pack();
        ComponentTools.setPos(this);
        super.show();
    }
}

