/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Observable;
import java.util.Observer;
import sunw.hotjava.misc.StreamCopier;
import sunw.hotjava.misc.URLConnector;
import sunw.hotjava.ui.ProgressDialog;

public final class URLSaver
implements Runnable,
Observer {
    private ProgressDialog progressDialog;
    private String targetFile;
    private URL url;
    private URLConnector connector;
    private Thread thread;
    private Frame frame;
    private String dialogLabel;
    private long bytesTransferred;

    public URLSaver(Frame frame, URL uRL, String string, String string2) {
        this(frame, uRL, null, string, string2);
    }

    public URLSaver(Frame frame, URL uRL, URLConnector uRLConnector, String string, String string2) {
        this.url = uRL;
        this.connector = uRLConnector;
        this.targetFile = string;
        this.frame = frame;
        this.dialogLabel = string2;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public String getFileName() {
        return this.targetFile;
    }

    public URL getURL() {
        return this.url;
    }

    public URLConnector getConnector() {
        return this.connector;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public synchronized void run() {
        URLConnection uRLConnection;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            uRLConnection = this.connector != null ? this.connector.openConnection(this.url) : this.url.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            return;
        }
        this.progressDialog = new ProgressDialog(this.frame, this.dialogLabel, this);
        this.progressDialog.start();
        try {
            outputStream = new FileOutputStream(this.targetFile);
            outputStream = new BufferedOutputStream(outputStream);
            long l = uRLConnection.getContentLength();
            this.progressDialog.setTotalBytes(l);
        }
        catch (IOException iOException) {
            this.progressDialog.stop();
            return;
        }
        StreamCopier streamCopier = new StreamCopier(inputStream, outputStream);
        streamCopier.addObserver(this);
        this.bytesTransferred = streamCopier.transfer();
        streamCopier.deleteObserver(this);
        this.progressDialog.stop();
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            outputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof StreamCopier) {
            this.bytesTransferred = ((Integer)object).intValue();
        }
    }
}

