/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import sunw.hotjava.tags.ImageMap;
import sunw.html.Attributes;
import sunw.html.DTD;
import sunw.html.Element;
import sunw.html.Parser;
import sunw.html.Tag;

public class ImageMapParser
extends Parser
implements Runnable {
    URL docURL;
    ImageMap imap;

    ImageMapParser(URL uRL) {
        this.docURL = uRL;
    }

    ImageMapParser(String string) {
        try {
            this.docURL = new URL(string);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
    }

    public void run() {
        Thread.currentThread().setName("ImageMapParser " + this.docURL);
        Reader reader = null;
        try {
            InputStream inputStream = this.docURL.openStream();
            reader = new InputStreamReader(inputStream);
            this.parse(reader, DTD.getDTD("html32"));
            return;
        }
        catch (IOException iOException) {
            if (reader != null) {
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException2) {
                    return;
                }
            }
            return;
        }
    }

    protected void handleStartTag(Tag tag) {
        Element element = tag.getElement();
        Attributes attributes = tag.getAttributes();
        if ("map".equals(element.getName())) {
            String string = attributes.get("name");
            try {
                URL uRL = new URL(this.docURL, "#" + string);
                this.imap = new ImageMap(uRL);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                this.imap = null;
                return;
            }
        }
    }

    protected void handleEndTag(Tag tag) {
        Element element = tag.getElement();
        if ("map".equals(element.getName())) {
            this.imap = null;
        }
    }

    protected void handleEmptyTag(Tag tag) {
        Element element = tag.getElement();
        Attributes attributes = tag.getAttributes();
        if ("area".equals(element.getName()) && this.imap != null) {
            String string = attributes.get("shape");
            String string2 = attributes.get("coords");
            String string3 = attributes.get("href");
            String string4 = attributes.get("nohref");
            String string5 = attributes.get("alt");
            String string6 = attributes.get("target");
            this.imap.addArea(this.docURL, string, string2, string3, string4 != null, string5, string6);
        }
    }
}

