/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sunw.html.DTDConstants;
import sunw.html.Element;

public final class AttributeList
implements DTDConstants,
Serializable {
    String name;
    int type;
    Vector values;
    int modifier;
    String value;
    AttributeList next;
    static Hashtable attributeTypes = new Hashtable();

    AttributeList() {
    }

    AttributeList(String string) {
        this.name = string;
    }

    AttributeList(String string, int n, int n2, String string2, Vector vector, AttributeList attributeList) {
        this.name = string;
        this.type = n;
        this.modifier = n2;
        this.value = string2;
        this.values = vector;
        this.next = attributeList;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getModifier() {
        return this.modifier;
    }

    public Enumeration getValues() {
        if (this.values != null) {
            return this.values.elements();
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public AttributeList getNext() {
        return this.next;
    }

    public String toString() {
        return this.name;
    }

    public void print(Element element) {
        System.out.println("<ATTLIST " + element.getName() + " ");
        AttributeList attributeList = this;
        while (attributeList != null) {
            System.out.print("\t" + attributeList.getName() + " ");
            if (attributeList.values != null) {
                System.out.print("(");
                Enumeration enumeration = attributeList.values.elements();
                while (enumeration.hasMoreElements()) {
                    System.out.print(enumeration.nextElement());
                    if (!enumeration.hasMoreElements()) continue;
                    System.out.print("|");
                }
                System.out.print(") ");
            } else {
                System.out.print(String.valueOf(AttributeList.type2name(attributeList.getType())) + " ");
            }
            switch (attributeList.modifier) {
                case 2: {
                    System.out.println("#REQUIRED");
                    break;
                }
                case 3: {
                    System.out.println("#CURRENT");
                    break;
                }
                case 4: {
                    System.out.println("#CONREF");
                    break;
                }
                case 5: {
                    System.out.println("#IMPLIED");
                    break;
                }
                case 1: {
                    System.out.print("#FIXED ");
                }
                default: {
                    System.out.println("\"" + attributeList.value + "\"");
                }
            }
            attributeList = attributeList.next;
        }
        System.out.println(">");
    }

    static void defineAttributeType(String string, int n) {
        Integer n2 = new Integer(n);
        attributeTypes.put(string, n2);
        attributeTypes.put(n2, string);
    }

    static int name2type(String string) {
        Integer n = (Integer)attributeTypes.get(string);
        if (n == null) {
            return 1;
        }
        return n;
    }

    static String type2name(int n) {
        return (String)attributeTypes.get(new Integer(n));
    }

    static {
        AttributeList.defineAttributeType("CDATA", 1);
        AttributeList.defineAttributeType("ENTITY", 2);
        AttributeList.defineAttributeType("ENTITIES", 3);
        AttributeList.defineAttributeType("ID", 4);
        AttributeList.defineAttributeType("IDREF", 5);
        AttributeList.defineAttributeType("IDREFS", 6);
        AttributeList.defineAttributeType("NAME", 7);
        AttributeList.defineAttributeType("NAMES", 8);
        AttributeList.defineAttributeType("NMTOKEN", 9);
        AttributeList.defineAttributeType("NMTOKENS", 10);
        AttributeList.defineAttributeType("NOTATION", 11);
        AttributeList.defineAttributeType("NUMBER", 12);
        AttributeList.defineAttributeType("NUMBERS", 13);
        AttributeList.defineAttributeType("NUTOKEN", 14);
        AttributeList.defineAttributeType("NUTOKENS", 15);
        attributeTypes.put("fixed", new Integer(1));
        attributeTypes.put("required", new Integer(2));
        attributeTypes.put("current", new Integer(3));
        attributeTypes.put("conref", new Integer(4));
        attributeTypes.put("implied", new Integer(5));
    }
}

