/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnAware;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.PickListDescriptor;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.view.ChoiceView;
import java.awt.Color;
import java.awt.Font;

public class ChoiceControl
extends ChoiceView
implements NavigationListener,
DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware {
    private DataSet dataSet;
    private String columnName;
    private boolean addNotifyCalled = false;

    public ChoiceControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(77));
        }
        super.setModel(singletonModel);
    }

    public void setItems(DataSet dataSet, String string) {
        if (dataSet != null && string != null) {
            try {
                DataSetView dataSetView = dataSet.cloneDataSetView();
                dataSetView.open();
                dataSetView.first();
                String[] stringArray = new String[dataSetView.getRowCount()];
                int n = 0;
                while (dataSetView.inBounds()) {
                    stringArray[n++] = dataSetView.getString(string);
                    dataSetView.next();
                }
                this.setItems(stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateSelection();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.updateSelection();
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.updateSelection();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
                this.setModel(new BasicSingletonContainer());
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column, this));
            PickListDescriptor pickListDescriptor = column.getPickList();
            if (pickListDescriptor != null) {
                this.fillFromPickList(pickListDescriptor);
            }
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color color = column.getBackground();
        Color color2 = column.getForeground();
        Font font = column.getFont();
        if (color != null) {
            this.setBackground(color);
        }
        if (color2 != null) {
            this.setForeground(color2);
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    private void fillFromPickList(PickListDescriptor pickListDescriptor) {
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean bl) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(bl) : false;
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }
}

