/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.DocContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;

abstract class Box
implements Serializable {
    protected transient DocContainer doc;
    protected String link = null;
    protected String linkTargetFrame = null;
    protected String anchor = null;
    protected Color color = Color.black;
    protected int attrib = 0;
    protected int ox;
    protected int oy;
    protected int width;
    protected int height;
    protected boolean breakBefore = true;
    private Box nextBox;
    public static final int ATTRIB_NONE = 0;
    public static final int ATTRIB_ALIGN_LEFT = 1;
    public static final int ATTRIB_ALIGN_CENTER = 2;
    public static final int ATTRIB_ALIGN_RIGHT = 3;
    public static final int ATTRIB_WRAP_LEFT = 4;
    public static final int ATTRIB_WRAP_RIGHT = 5;
    public static final int ATTRIB_WRAP_CLEAR_LEFT = 6;
    public static final int ATTRIB_WRAP_CLEAR_RIGHT = 7;
    public static final int ATTRIB_WRAP_CLEAR_ALL = 8;
    public static final int ATTRIB_INDENT_INC = 9;
    public static final int ATTRIB_INDENT_DEC = 10;
    public static final int ATTRIB_INDENT_PRE = 11;

    Box(DocContainer d) {
        this.doc = d;
        this.oy = -1000;
        this.ox = -1000;
        this.height = 0;
        this.width = 0;
        this.nextBox = null;
    }

    Box() {
    }

    void setDocContainer(DocContainer d) {
        this.doc = d;
    }

    Box getNext() {
        return this.nextBox;
    }

    void setNext(Box b) {
        this.nextBox = b;
    }

    void paint(Graphics g) {
    }

    void layout(int visWidth, boolean firstOnLine) {
    }

    void move(int x, int y) {
        this.ox = x;
        this.oy = y;
    }

    Point location() {
        return new Point(this.ox, this.oy);
    }

    Dimension size() {
        return new Dimension(this.width, this.height);
    }

    protected void resize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    Box mouseClicked(int x, int y) {
        if (this.link != null) {
            return this;
        }
        return null;
    }

    Box mouseMoved(int x, int y) {
        if (this.link != null) {
            return this;
        }
        return null;
    }

    int getBaseLine() {
        return this.height;
    }

    void setAttrib(int a) {
        this.attrib = a;
    }

    int getAttrib() {
        return this.attrib;
    }

    void setLink(String href, String targetFrame) {
        this.link = href;
        this.linkTargetFrame = targetFrame;
    }

    String getLinkTargetFrame() {
        return this.linkTargetFrame;
    }

    String getLink() {
        return this.link;
    }

    String getOutputString() {
        return null;
    }

    void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    Box getAnchorBox(String anchor) {
        if (anchor.equals(this.anchor)) {
            return this;
        }
        return null;
    }

    void setColor(Color c) {
        this.color = c;
    }

    void setBreakable(boolean flag) {
        this.breakBefore = flag;
    }

    boolean isBreakable() {
        return this.breakBefore;
    }
}

