/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.AppletStatus;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BrowserAppletThreadGroup;
import ice.htmlbrowser.BrowserClassLoader;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.Queue;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class BoxApplet
extends Box
implements ActiveBox,
AppletStub,
AppletContext,
Runnable {
    Thread handlerThread;
    Thread loaderThread;
    DocContainer dc;
    protected AppletStatus status = new AppletStatus();
    public static final int APPLET_DISPOSE = 0;
    public static final int APPLET_LOAD = 1;
    public static final int APPLET_INIT = 2;
    public static final int APPLET_START = 3;
    public static final int APPLET_STOP = 4;
    public static final int APPLET_DESTROY = 5;
    public static final int APPLET_QUIT = 6;
    public static final int APPLET_ERROR = 7;
    Queue queue = new Queue();
    private static Hashtable classloaders = new Hashtable();
    boolean loadAbortRequest = false;
    Dimension appletSize = new Dimension(100, 100);
    private Object lockObject = new Object();
    private int h_space = 0;
    private int v_space = 0;
    private Applet applet;
    private String[] archiveList = null;
    private int appletw;
    private int appleth;
    private String apname;
    private BrowserClassLoader loader = null;
    private String baseTargetFrame = "_self";
    private URL appletCodeBase;
    private Vector paramNames;
    private Vector paramValues;
    private static boolean debug = false;

    BoxApplet(DocContainer d, String apname, String cbase, int w, int h) {
        super(d);
        this.dc = d;
        if (apname.endsWith(".class") || apname.endsWith(".CLASS")) {
            apname = apname.substring(0, apname.lastIndexOf(46));
        }
        this.apname = apname;
        this.appletCodeBase = null;
        if (cbase != null) {
            if (!cbase.endsWith("/")) {
                cbase = String.valueOf(cbase).concat(String.valueOf("/"));
            }
            try {
                this.appletCodeBase = new URL(this.doc.getDocumentBase(), cbase);
            }
            catch (MalformedURLException e) {
                this.appletCodeBase = null;
            }
        }
        if (this.appletCodeBase == null) {
            String temp = this.doc.getDocumentBase().toString();
            if (!temp.endsWith("/")) {
                temp = temp.substring(0, temp.lastIndexOf("/") + 1);
            }
            try {
                this.appletCodeBase = new URL(temp);
            }
            catch (MalformedURLException e) {
                return;
            }
        }
        this.paramNames = new Vector();
        this.paramValues = new Vector();
        this.appletw = w;
        this.appleth = h;
        this.resize(w, h);
    }

    public void init() {
        String tgname = String.valueOf("applet-").concat(String.valueOf(this.apname));
        this.handlerThread = new Thread(new BrowserAppletThreadGroup(String.valueOf("group ").concat(String.valueOf(tgname))), this, String.valueOf("group ").concat(String.valueOf(tgname)));
        this.handlerThread.start();
    }

    public void queueEvent(int id) {
        this.queueEvent(new Integer(id));
    }

    protected synchronized void queueEvent(Object evt) {
        this.queue.push(evt);
        this.notify();
    }

    synchronized int getNextEvent() throws InterruptedException {
        while (this.queue.empty()) {
            this.wait();
        }
        Object evt = this.queue.pop();
        if (evt instanceof Integer) {
            return (Integer)evt;
        }
        return -1;
    }

    public void run() {
        Thread curThread = Thread.currentThread();
        if (curThread == this.loaderThread) {
            this.runLoader();
            return;
        }
        while (true) {
            int evt;
            try {
                evt = this.getNextEvent();
            }
            catch (InterruptedException e) {
                BoxApplet.debug(".bail");
                return;
            }
            BoxApplet.debug(String.valueOf("EVENT = ").concat(String.valueOf(evt)));
            try {
                switch (evt) {
                    case 1: {
                        if (!this.okToLoad()) break;
                        if (this.loaderThread == null) {
                            this.setLoaderThread(new Thread(this));
                            this.loaderThread.start();
                            this.loaderThread.join();
                            this.setLoaderThread(null);
                        }
                        break;
                    }
                    case 2: {
                        if (!this.status.loaded) {
                            BoxApplet.debug(".notloaded");
                            break;
                        }
                        this.applet.resize(this.appletw, this.appleth);
                        this.applet.init();
                        this.doc.validate();
                        this.status.inited = true;
                        this.notifyMe();
                        BoxApplet.debug(".inited");
                        break;
                    }
                    case 3: {
                        if (!this.status.inited) {
                            BoxApplet.debug(".notinited");
                            break;
                        }
                        if (this.status.running) {
                            BoxApplet.debug(".alreadyrunning");
                            break;
                        }
                        this.applet.resize(this.appletw, this.appleth);
                        this.applet.start();
                        this.doc.validate();
                        this.applet.setVisible(true);
                        this.status.running = true;
                        this.notifyMe();
                        BoxApplet.debug(".started");
                        break;
                    }
                    case 4: {
                        if (!this.status.running) {
                            BoxApplet.debug(".notrunning");
                            break;
                        }
                        this.applet.stop();
                        this.status.running = false;
                        BoxApplet.debug(".notify");
                        this.notifyMe();
                        BoxApplet.debug(".stopped");
                        break;
                    }
                    case 5: {
                        if (!this.status.inited) {
                            BoxApplet.debug(".notinited");
                            break;
                        }
                        this.applet.setVisible(false);
                        this.applet.stop();
                        this.applet.destroy();
                        this.status.running = false;
                        this.status.destroyed = true;
                        this.notifyMe();
                        BoxApplet.debug(".destroyed");
                        break;
                    }
                    case 0: {
                        if (!this.status.destroyed) {
                            BoxApplet.debug(".notdestroyed");
                            break;
                        }
                        this.doc.remove(this.applet);
                        this.status.loaded = false;
                        this.status.running = false;
                        this.status.disposed = true;
                        this.notifyMe();
                        BoxApplet.debug(".disposed");
                        break;
                    }
                    case 6: {
                        return;
                    }
                }
            }
            catch (Exception e) {
                BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf(".exception2").concat(String.valueOf(e.getClass().getName()))).concat(String.valueOf("\n"))).concat(String.valueOf(e.getMessage())));
            }
            catch (ThreadDeath e) {
                BoxApplet.debug(".death");
                return;
            }
            catch (Error e) {
                BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf(".error2").concat(String.valueOf(e.getClass().getName()))).concat(String.valueOf("\n"))).concat(String.valueOf(e.getMessage())));
            }
            this.clearLoadAbortRequest();
        }
    }

    private void runLoader() {
        if (this.status.loaded) {
            BoxApplet.debug(".alreadyloaded");
            return;
        }
        this.status.disposed = false;
        this.status.destroyed = false;
        try {
            this.loader = BoxApplet.getClassLoader(this.getCodeBase());
            if (Thread.interrupted()) {
                this.status.disposed = true;
                return;
            }
        }
        catch (IOException e) {
            this.status.disposed = true;
            BoxApplet.debug(e.getMessage());
            return;
        }
        if (this.archiveList != null) {
            BoxApplet.debug("setting archiveList");
            this.loader.setArchiveList(this.archiveList);
            BoxApplet.debug("Loaders atciveList set");
        }
        if (this.apname == null) {
            String msg = ".nocode";
            this.status.disposed = true;
            BoxApplet.debug(msg);
            this.doc.repaint();
        } else {
            this.apname = this.apname.endsWith(".class") ? this.apname.substring(0, this.apname.length() - 6).replace('/', '.') : (this.apname.endsWith(".java") ? this.apname.substring(0, this.apname.length() - 5).replace('/', '.') : this.apname.substring(0, this.apname.length()).replace('/', '.'));
        }
        try {
            try {
                BoxApplet.debug(String.valueOf(String.valueOf("getting <").concat(String.valueOf(this.apname))).concat(String.valueOf(">")));
                this.applet = (Applet)this.loader.loadClass(this.apname).newInstance();
                if (Thread.interrupted()) {
                    this.status.disposed = true;
                    this.applet = null;
                    BoxApplet.debug(".death");
                    Object var4_9 = null;
                    return;
                }
                Object var4_10 = null;
            }
            catch (ClassNotFoundException e) {
                this.status.disposed = true;
                String msg = String.valueOf(".notfound ").concat(String.valueOf(this.apname));
                System.err.println(String.valueOf(String.valueOf(msg).concat(String.valueOf("\n"))).concat(String.valueOf(e.getMessage())));
                Object var4_11 = null;
                return;
            }
            catch (InstantiationException e) {
                this.status.disposed = true;
                String msg = String.valueOf(".nocreate ").concat(String.valueOf(this.apname));
                BoxApplet.debug(msg);
                Object var4_12 = null;
                return;
            }
            catch (IllegalAccessException e) {
                this.status.disposed = true;
                String msg = String.valueOf(".noconstruct ").concat(String.valueOf(this.apname));
                BoxApplet.debug(msg);
                Object var4_13 = null;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.status.disposed = true;
                BoxApplet.debug(String.valueOf(".appleterror ").concat(String.valueOf(this.apname)));
                System.err.println(e.getMessage());
                Object var4_14 = null;
                return;
            }
            catch (ThreadDeath e) {
                this.status.disposed = true;
                BoxApplet.debug(".death");
                Object var4_15 = null;
                return;
            }
            catch (Error e) {
                this.status.disposed = true;
                BoxApplet.debug(String.valueOf(".error ").concat(String.valueOf(e.getMessage())));
                System.err.println(String.valueOf("\n").concat(String.valueOf(e.getMessage())));
                e.printStackTrace();
                Object var4_16 = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_17 = null;
            throw throwable;
        }
        this.applet.setStub(this);
        this.applet.setVisible(false);
        this.doc.setAWTComponent(this, this.applet);
        BoxApplet.debug(".loaded");
        this.status.loaded = true;
        this.doc.validate();
    }

    static synchronized BrowserClassLoader getClassLoader(URL codebase) throws IOException {
        BrowserClassLoader c = (BrowserClassLoader)classloaders.get(codebase);
        if (c == null) {
            c = new BrowserClassLoader(codebase);
            classloaders.put(codebase, c);
        }
        BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf("getClassLoader for ").concat(String.valueOf(codebase))).concat(String.valueOf("\n    "))).concat(String.valueOf(c)));
        return c;
    }

    protected synchronized void stopLoading() {
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        } else {
            this.setLoadAbortRequest();
        }
    }

    protected synchronized boolean okToLoad() {
        return !this.loadAbortRequest;
    }

    protected synchronized void clearLoadAbortRequest() {
        this.loadAbortRequest = false;
    }

    protected synchronized void setLoadAbortRequest() {
        this.loadAbortRequest = true;
    }

    private synchronized void setLoaderThread(Thread loaderThread) {
        this.loaderThread = loaderThread;
    }

    public void appletResize(int width, int height) {
        this.appletSize.width = width;
        this.appletSize.height = height;
        BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("appletResize ").concat(String.valueOf(width))).concat(String.valueOf(", "))).concat(String.valueOf(height))).concat(String.valueOf("\n  applet is "))).concat(String.valueOf(this.applet.getSize())));
    }

    void addParam(String name, String value) {
        this.paramNames.addElement(name);
        this.paramValues.addElement(value);
    }

    Applet getApplet() {
        return this.applet;
    }

    void paint(Graphics g) {
    }

    public void activeShow() {
        this.queueEvent(3);
    }

    public void activeHide() {
        this.queueEvent(4);
        while (this.status.running) {
            Object object = this.lockObject;
            synchronized (object) {
                Object var4_3;
                try {
                    try {
                        this.lockObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    var4_3 = null;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    throw throwable;
                }
            }
        }
    }

    private void notifyMe() {
        Object object = this.lockObject;
        synchronized (object) {
            try {
                this.lockObject.notify();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    public void activeInterrupt() {
    }

    protected void resize(int w, int h) {
        BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("resize ").concat(String.valueOf(w))).concat(String.valueOf(", "))).concat(String.valueOf(h))).concat(String.valueOf(" applet = "))).concat(String.valueOf(this.applet)));
        super.resize(w + this.h_space * 2, h + this.v_space * 2);
        if (this.applet != null) {
            this.applet.resize(w, h);
        }
    }

    void setHSpace(int h) {
        this.width += (-this.h_space + h) * 2;
        this.h_space = h;
    }

    void setVSpace(int v) {
        this.height += (-this.v_space + v) * 2;
        this.v_space = v;
    }

    void setArchiveList(String[] list) {
        this.archiveList = list;
    }

    void setTarget(String target) {
        this.baseTargetFrame = target;
    }

    public boolean isActive() {
        return this.status.running;
    }

    public URL getDocumentBase() {
        return this.doc.getDocumentBase();
    }

    public URL getCodeBase() {
        return this.appletCodeBase;
    }

    public String getParameter(String param) {
        String name;
        int i;
        int n = this.paramNames.size();
        for (i = 0; i < n && !param.equalsIgnoreCase(name = (String)this.paramNames.elementAt(i)); ++i) {
        }
        if (i == n) {
            return null;
        }
        return new String((String)this.paramValues.elementAt(i));
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public AudioClip getAudioClip(URL url) {
        return null;
    }

    public Image getImage(URL url) {
        Image img = null;
        if (this.loader != null) {
            img = this.loader.getImage(url);
            this.dc.addImage(img);
        }
        return img;
    }

    public Applet getApplet(String name) {
        int n = this.doc.getComponentCount();
        while (n > 0) {
            Applet a;
            Component c;
            if (!((c = this.doc.getComponent(--n)) instanceof Applet) || !name.equals((a = (Applet)c).getClass().getName())) continue;
            return a;
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Component> v = new Vector<Component>();
        int n = this.doc.getComponentCount();
        while (n > 0) {
            Component c;
            if (!((c = this.doc.getComponent(--n)) instanceof Applet)) continue;
            v.addElement(c);
        }
        return v.elements();
    }

    public void showDocument(URL url) {
        this.showDocument(url, this.baseTargetFrame);
    }

    public void showDocument(URL url, String target) {
        BoxApplet.debug(String.valueOf(String.valueOf(String.valueOf(String.valueOf("showDocument( ").concat(String.valueOf(url))).concat(String.valueOf(", "))).concat(String.valueOf(target))).concat(String.valueOf(") ")));
        this.doc.getParentDocument().gotoLocation(url, target);
    }

    public void showStatus(String status) {
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println(String.valueOf("BoxApplet:: ").concat(String.valueOf(msg)));
        }
    }
}

