/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.net.URL;

class BrowserControl
extends Panel
implements ActionListener,
TextListener {
    private TextField textURL;
    private Browser bb;
    private boolean font_toggle;

    BrowserControl(Browser bb) {
        this.bb = bb;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        ((Component)p).setFont(new Font("SansSerif", 1, 14));
        Button b = new Button("Back");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Forward");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Reload");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Stop");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Font");
        b.addActionListener(this);
        p.add(b);
        Panel p2 = new Panel();
        p2.setLayout(new FlowLayout(0));
        this.textURL = new TextField(80);
        this.textURL.addActionListener(this);
        p2.add(this.textURL);
        this.add("South", p2);
        this.add("North", p);
        bb.addTextListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getSource() == this.textURL) {
            this.bb.gotoLocation(this.textURL.getText());
        } else if (command.equals("Font")) {
            Font f = !this.font_toggle ? new Font("Serif", 0, 16) : new Font("SansSerif", 0, 12);
            this.font_toggle = !this.font_toggle;
            this.bb.setProportionalFont(f);
        } else if (command.equals("Back")) {
            this.bb.goBack();
        } else if (command.equals("Forward")) {
            this.bb.goForward();
        } else if (command.equals("Reload")) {
            this.bb.reload();
        } else if (command.equals("Stop")) {
            this.bb.stopLoading();
        }
    }

    public void textValueChanged(TextEvent e) {
        if (e.getSource() == this.bb) {
            URL url = this.bb.getDocumentBase();
            if (url != null) {
                ((TextComponent)this.textURL).setText(url.toString());
            } else {
                ((TextComponent)this.textURL).setText(" ");
            }
        }
    }
}

