/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.AuthDialog;
import ice.htmlbrowser.Htuu;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class BrowserTools
implements FilenameFilter {
    private static String cwd;
    private FileDialog fd;
    private static transient Hashtable authCache;
    private Frame frameHandle;

    public BrowserTools(Frame f) {
        this.frameHandle = f;
    }

    public BrowserTools(Component c) {
        this.frameHandle = BrowserTools.findFrame(c);
    }

    public synchronized String authInfo(String realm) {
        String info = (String)authCache.get(realm);
        if (info == null) {
            AuthDialog ad = new AuthDialog(this.frameHandle, realm);
            String name = ad.getName();
            String pw = ad.getPassword();
            if (name == null || pw == null) {
                info = null;
            } else {
                info = String.valueOf("Basic ").concat(String.valueOf(Htuu.encode(String.valueOf(String.valueOf(name).concat(String.valueOf(":"))).concat(String.valueOf(pw)))));
                authCache.put(realm, info);
            }
        }
        return info;
    }

    public void saveFromStream(InputStream in) {
        BufferedInputStream bis = new BufferedInputStream(in);
        this.fd = new FileDialog(this.frameHandle, "Save to file", 1);
        if (cwd == null) {
            this.updateCwd(System.getProperty("user.dir"));
        }
        this.fd.setDirectory(cwd);
        this.fd.setFilenameFilter(this);
        this.fd.show();
        if (this.fd.getFilenameFilter() != this) {
            throw new RuntimeException("Internal Error");
        }
        System.out.println(String.valueOf(String.valueOf(String.valueOf("Dir: ").concat(String.valueOf(this.fd.getDirectory()))).concat(String.valueOf(" File: "))).concat(String.valueOf(this.fd.getFile())));
        if (this.fd.getFile() == null) {
            return;
        }
        this.updateCwd(this.fd.getDirectory());
        try {
            int c;
            File dir = new File(this.fd.getDirectory());
            File ofile = new File(dir, this.fd.getFile());
            FileOutputStream fos = new FileOutputStream(ofile);
            while ((c = bis.read()) != -1) {
                fos.write(c);
            }
            ((FilterInputStream)bis).close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(String.valueOf("StreamTools: ").concat(String.valueOf(e)));
        }
        catch (IOException e) {
            System.err.println(String.valueOf("StreamTools: ").concat(String.valueOf(e)));
        }
    }

    public static Frame findFrame(Component comp) {
        for (Component c = comp; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public static void nukeAuthCache(String realm) {
        authCache.remove(realm);
    }

    public boolean accept(File dir, String name) {
        return true;
    }

    private synchronized void updateCwd(String dir) {
        cwd = dir;
    }

    static {
        authCache = new Hashtable();
    }
}

