/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserTools;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

class BrowserURLLoader {
    private static Hashtable imgCache = new Hashtable();
    URL url;
    URL archiveURL;
    URLConnection uc = null;
    private boolean connected;
    private int size = 0;
    private InputStream instream = null;
    private Component awtRef;
    private static boolean hasDoneAuth = false;

    BrowserURLLoader() {
    }

    public BrowserURLLoader(URL u) {
        this.url = u;
    }

    public BrowserURLLoader(URL u, Component awtRef) {
        this(u);
        this.awtRef = awtRef;
    }

    public BrowserURLLoader(URL u, URL archive) {
        this(u);
        this.archiveURL = archive;
    }

    public byte[] loadURL() throws IOException {
        byte[] data = null;
        boolean totRead = false;
        boolean fLen = false;
        boolean cc = false;
        if (this.uc == null) {
            this.getUC();
        }
        this.size = 0;
        try {
            int r;
            InputStream in = this.getInputStream();
            DataInputStream input = new DataInputStream(in);
            byte[] buf = new byte[4096];
            do {
                int i;
                r = 0;
                while ((r = input.read(buf)) == 0) {
                }
                if (r <= 0) continue;
                byte[] buf2 = data;
                data = new byte[this.size + r];
                for (i = 0; i < this.size; ++i) {
                    data[i] = buf2[i];
                }
                for (i = 0; i < r; ++i) {
                    data[i + this.size] = buf[i];
                }
                this.size += r;
            } while (r >= 0);
            input.close();
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        return data;
    }

    public Image getImage() {
        Image img;
        block5: {
            Toolkit tk = Toolkit.getDefaultToolkit();
            img = (Image)imgCache.get(this.url);
            if (img != null) break block5;
            if (hasDoneAuth) {
                try {
                    Object cont = this.getContent();
                    if (cont instanceof ImageProducer) {
                        ImageProducer prod = (ImageProducer)cont;
                        img = tk.createImage(prod);
                        imgCache.put(this.url, img);
                        break block5;
                    }
                    System.err.println(String.valueOf("URL Content not ImageProducer : ").concat(String.valueOf(cont)));
                }
                catch (IOException prod) {}
            } else {
                img = tk.getImage(this.url);
            }
        }
        return img;
    }

    public int getSize() {
        return this.size;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.getUC().connect();
        this.connected = true;
    }

    public void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        if (this.uc instanceof HttpURLConnection) {
            ((HttpURLConnection)this.uc).disconnect();
        }
        this.uc = null;
        this.instream = null;
    }

    public String getContentType() {
        try {
            this.getInputStream();
        }
        catch (IOException e) {
            System.err.println(String.valueOf("Internal error in BrowserURLConnection\n").concat(String.valueOf(e.getMessage())));
            e.printStackTrace();
        }
        if (this.uc == null) {
            return null;
        }
        return this.uc.getContentType();
    }

    public Object getContent() throws IOException {
        this.getInputStream();
        Object o = this.uc.getContent();
        return o;
    }

    public InputStream getInputStream() throws IOException {
        if (this.instream != null) {
            return this.instream;
        }
        InputStream in = null;
        this.connect();
        try {
            boolean valid = false;
            int retries = 0;
            String realm = "";
            if (this.uc instanceof HttpURLConnection) {
                try {
                    HttpURLConnection cfr_ignored_0 = (HttpURLConnection)this.uc;
                    HttpURLConnection.setFollowRedirects(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            do {
                try {
                    in = this.uc.getInputStream();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.uc instanceof HttpURLConnection) {
                    HttpURLConnection hc = (HttpURLConnection)this.uc;
                    if (hc.getResponseCode() == 401) {
                        int rStop;
                        String auth_info;
                        BrowserTools bt = new BrowserTools(this.awtRef);
                        this.disconnect();
                        ++retries;
                        String authChallenge = hc.getHeaderField("WWW-Authenticate");
                        int rStart = authChallenge.indexOf("realm", 0);
                        if (rStart != -1) {
                            rStart += "realm".length();
                        }
                        if ((auth_info = bt.authInfo(realm = authChallenge.substring((rStart = authChallenge.indexOf("\"", rStart)) + 1, rStop = authChallenge.indexOf("\"", rStart + 1)))) == null) {
                            BrowserTools.nukeAuthCache(realm);
                            retries = 10;
                            InputStream inputStream = in;
                            return inputStream;
                        }
                        this.uc = this.getUC();
                        hc = (HttpURLConnection)this.uc;
                        hc.setRequestProperty("Authorization", auth_info);
                        try {
                            HttpURLConnection.setFollowRedirects(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        String type = this.uc.getContentType();
                        if (retries > 5) {
                            BrowserTools.nukeAuthCache(realm);
                        }
                    } else {
                        if (hc.getResponseCode() == 404) {
                            throw new IOException("URL Not Found");
                        }
                        valid = true;
                        if (retries <= 5 && retries > 0) {
                            hasDoneAuth = true;
                        }
                    }
                } else {
                    valid = true;
                }
                if (retries <= 5) continue;
                InputStream inputStream = null;
                return inputStream;
            } while (!valid);
        }
        catch (IOException e) {
            IOException newe = new IOException(String.valueOf(String.valueOf(e.getMessage()).concat(String.valueOf("\n"))).concat(String.valueOf("in BrowserURLConnection.getInputStream()")));
            newe.fillInStackTrace();
            e.printStackTrace();
            throw newe;
        }
        return in;
    }

    public URL getURL() {
        if (this.uc == null) {
            return null;
        }
        return this.uc.getURL();
    }

    public URLConnection openConnection() throws IOException {
        URLConnection uc;
        if (this.connected) {
            this.disconnect();
        }
        if ((uc = this.getUC()) instanceof HttpURLConnection) {
            try {
                HttpURLConnection cfr_ignored_0 = (HttpURLConnection)uc;
                HttpURLConnection.setFollowRedirects(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return uc;
    }

    private URLConnection getUC() throws IOException {
        if (this.uc == null) {
            this.uc = this.url.openConnection();
        }
        return this.uc;
    }
}

