/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

class Lex {
    private BufferedReader reader = null;
    private boolean flagPreformatted = false;
    private boolean flagPlainText = false;
    private char[] tokenChars = new char[1024];
    private int tokenLength = 0;
    private int curChar;
    private int tokenType = -1;
    private boolean flagBreakBefore = false;
    private int commentCount = 0;
    static final int TOKEN_WORD = 2;
    static final int TOKEN_TAG = 3;
    static final int TOKEN_COMMENT = 4;
    private static Hashtable isochars = new Hashtable();

    Lex() {
    }

    void setReader(Reader r) throws IOException {
        this.reader = new BufferedReader(r);
        this.curChar = this.reader.read();
    }

    void setPreformatted(boolean flag) {
        this.flagPreformatted = flag;
    }

    boolean isPreformatted() {
        return this.flagPreformatted;
    }

    void setPlainText(boolean flag) {
        this.flagPlainText = flag;
    }

    int getNextToken() {
        if (this.reader == null) {
            return -1;
        }
        if (this.curChar < 0) {
            return this.finishReader();
        }
        try {
            this.flagBreakBefore = false;
            this.tokenLength = 0;
            if (this.findFirstNonBlank() > 0) {
                if (this.flagPreformatted) {
                    int n = this.tokenType = 2;
                    return n;
                }
                this.flagBreakBefore = true;
            }
            if (this.flagPreformatted) {
                if (this.curChar == 10 || this.curChar == 13) {
                    this.tokenType = 2;
                    int oldChar = this.curChar;
                    this.curChar = this.reader.read();
                    if (oldChar == 10 && this.curChar == 13 || oldChar == 13 && this.curChar == 10) {
                        this.curChar = this.reader.read();
                    }
                    this.tokenChars[0] = 10;
                    this.tokenLength = 1;
                    int n = this.tokenType;
                    return n;
                }
                if (this.curChar == 9) {
                    this.tokenType = 2;
                    this.curChar = this.reader.read();
                    this.tokenChars[0] = 32;
                    this.tokenLength = 1;
                    int oldChar = this.tokenType;
                    return oldChar;
                }
            }
            if (!this.flagPlainText && this.curChar == 60) {
                this.curChar = this.reader.read();
                this.commentCount = 0;
                this.findTagEnd();
                this.tokenType = this.commentCount == 3 ? 4 : 3;
            } else if (!this.flagPlainText && this.curChar == 38) {
                this.findSpecialEnd();
                this.makeSpecial();
                this.tokenType = 2;
            } else {
                this.findWordEnd();
                this.tokenType = 2;
            }
        }
        catch (IOException e) {
            this.finishReader();
        }
        return this.tokenType;
    }

    int getTokenType() {
        return this.tokenType;
    }

    String getTokenString() {
        return new String(this.tokenChars, 0, this.tokenLength);
    }

    boolean isTokenBreakable() {
        return this.flagBreakBefore && !this.flagPreformatted;
    }

    private int finishReader() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        this.tokenType = -1;
        return -1;
    }

    private int findFirstNonBlank() throws IOException {
        int count = 0;
        if (this.flagPreformatted) {
            while (this.curChar > 0 && this.curChar == 32) {
                if (this.flagPreformatted) {
                    this.tokenChars[this.tokenLength++] = (char)this.curChar;
                }
                this.curChar = this.reader.read();
                ++count;
            }
        } else {
            while (this.curChar > 0 && (this.curChar == 32 || this.curChar == 10 || this.curChar == 13 || this.curChar == 9)) {
                this.curChar = this.reader.read();
                ++count;
            }
        }
        return count;
    }

    private int findTagEnd() throws IOException {
        int count = 0;
        while (this.curChar > 0 && this.commentCount < 3) {
            if (this.curChar == 62) {
                this.curChar = this.reader.read();
                break;
            }
            if (count == 0 && this.curChar == 33 || count == 1 && this.curChar == 45 || count == 2 && this.curChar == 45) {
                ++this.commentCount;
            }
            try {
                this.tokenChars[this.tokenLength] = (char)this.curChar;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                int len;
                int elementCount = len = this.tokenChars.length;
                char[] tctmp = this.tokenChars;
                this.tokenChars = new char[len += 1024];
                System.arraycopy(tctmp, 0, this.tokenChars, 0, elementCount);
                this.tokenChars[this.tokenLength] = (char)this.curChar;
            }
            ++this.tokenLength;
            this.curChar = this.reader.read();
            ++count;
        }
        if (this.commentCount == 3) {
            int prev1 = 0;
            int prev2 = 0;
            while (this.curChar > 0) {
                if (this.curChar == 62 && (prev1 == 45 || prev1 == 33) && prev2 == 45) {
                    this.curChar = this.reader.read();
                    break;
                }
                prev2 = prev1;
                prev1 = this.curChar;
                this.curChar = this.reader.read();
                ++count;
            }
        }
        while (this.curChar > 0 && this.curChar == 13) {
            this.curChar = this.reader.read();
        }
        return count;
    }

    private int findWordEnd() throws IOException {
        int count = 0;
        while (this.curChar > 0 && (this.curChar != 32 || this.flagPreformatted) && (this.curChar != 60 && this.curChar != 38 || this.flagPlainText) && this.curChar != 10 && this.curChar != 13 && this.curChar != 9 && this.tokenLength < this.tokenChars.length) {
            this.tokenChars[this.tokenLength++] = (char)this.curChar;
            this.curChar = this.reader.read();
            ++count;
        }
        return count;
    }

    private int findSpecialEnd() throws IOException {
        int count = 0;
        while (this.curChar > 0) {
            if (this.curChar == 59) {
                this.curChar = this.reader.read();
                break;
            }
            if (this.curChar == 32 || this.curChar == 60 || this.curChar == 10 || this.curChar == 13 || this.curChar == 9) break;
            this.tokenChars[this.tokenLength++] = (char)this.curChar;
            this.curChar = this.reader.read();
            ++count;
        }
        return count;
    }

    void makeSpecial() {
        if (this.tokenLength < 2) {
            return;
        }
        String s = new String(this.tokenChars, 1, this.tokenLength - 1);
        int symbol = 32;
        Integer o = (Integer)isochars.get(s);
        if (s.equalsIgnoreCase("LT")) {
            symbol = 60;
        } else if (s.equalsIgnoreCase("GT")) {
            symbol = 62;
        } else if (s.equalsIgnoreCase("AMP")) {
            symbol = 38;
        } else if (s.equalsIgnoreCase("QUOT")) {
            symbol = 34;
        } else if (s.equalsIgnoreCase("COPY")) {
            symbol = 169;
        } else if (s.equalsIgnoreCase("REG")) {
            symbol = 174;
        } else if (s.length() > 2 && s.charAt(0) == '#') {
            symbol = (char)Tag.decStrToInt(s.substring(1));
        } else if (o != null) {
            symbol = (char)o.intValue();
        } else {
            return;
        }
        this.tokenChars[0] = symbol;
        this.tokenLength = 1;
    }

    static {
        isochars.put("nbsp", new Integer(160));
        isochars.put("iexcl", new Integer(161));
        isochars.put("cent", new Integer(162));
        isochars.put("pound", new Integer(163));
        isochars.put("curren", new Integer(164));
        isochars.put("yen", new Integer(165));
        isochars.put("brvbar", new Integer(166));
        isochars.put("sect", new Integer(167));
        isochars.put("uml", new Integer(168));
        isochars.put("copy", new Integer(169));
        isochars.put("ordf", new Integer(170));
        isochars.put("laquo", new Integer(171));
        isochars.put("not", new Integer(172));
        isochars.put("shy", new Integer(173));
        isochars.put("reg", new Integer(174));
        isochars.put("macr", new Integer(175));
        isochars.put("deg", new Integer(176));
        isochars.put("plusmn", new Integer(177));
        isochars.put("sup2", new Integer(178));
        isochars.put("sup3", new Integer(179));
        isochars.put("acute", new Integer(180));
        isochars.put("micro", new Integer(181));
        isochars.put("para", new Integer(182));
        isochars.put("middot", new Integer(183));
        isochars.put("cedil", new Integer(184));
        isochars.put("sup1", new Integer(185));
        isochars.put("ordm", new Integer(186));
        isochars.put("raquo", new Integer(187));
        isochars.put("frac14", new Integer(188));
        isochars.put("frac12", new Integer(189));
        isochars.put("frac34", new Integer(190));
        isochars.put("iquest", new Integer(191));
        isochars.put("Agrave", new Integer(192));
        isochars.put("Aacute", new Integer(193));
        isochars.put("Acirc", new Integer(194));
        isochars.put("Atilde", new Integer(195));
        isochars.put("Auml", new Integer(196));
        isochars.put("Aring", new Integer(197));
        isochars.put("AElig", new Integer(198));
        isochars.put("Ccedil", new Integer(199));
        isochars.put("Egrave", new Integer(200));
        isochars.put("Eacute", new Integer(201));
        isochars.put("Ecirc", new Integer(202));
        isochars.put("Euml", new Integer(203));
        isochars.put("Igrave", new Integer(204));
        isochars.put("Iacute", new Integer(205));
        isochars.put("Icirc", new Integer(206));
        isochars.put("Iuml", new Integer(207));
        isochars.put("ETH", new Integer(208));
        isochars.put("Ntilde", new Integer(209));
        isochars.put("Ograve", new Integer(210));
        isochars.put("Oacute", new Integer(211));
        isochars.put("Ocirc", new Integer(212));
        isochars.put("Otilde", new Integer(213));
        isochars.put("Ouml", new Integer(214));
        isochars.put("times", new Integer(215));
        isochars.put("Oslash", new Integer(216));
        isochars.put("Ugrave", new Integer(217));
        isochars.put("Uacute", new Integer(218));
        isochars.put("Ucirc", new Integer(219));
        isochars.put("Uuml", new Integer(220));
        isochars.put("Yacute", new Integer(221));
        isochars.put("THORN", new Integer(222));
        isochars.put("szlig", new Integer(223));
        isochars.put("agrave", new Integer(224));
        isochars.put("aacute", new Integer(225));
        isochars.put("acirc", new Integer(226));
        isochars.put("atilde", new Integer(227));
        isochars.put("auml", new Integer(228));
        isochars.put("aring", new Integer(229));
        isochars.put("aelig", new Integer(230));
        isochars.put("ccedil", new Integer(231));
        isochars.put("egrave", new Integer(232));
        isochars.put("eacute", new Integer(233));
        isochars.put("ecirc", new Integer(234));
        isochars.put("euml", new Integer(235));
        isochars.put("igrave", new Integer(236));
        isochars.put("iacute", new Integer(237));
        isochars.put("icirc", new Integer(238));
        isochars.put("iuml", new Integer(239));
        isochars.put("eth", new Integer(240));
        isochars.put("ntilde", new Integer(241));
        isochars.put("ograve", new Integer(242));
        isochars.put("oacute", new Integer(243));
        isochars.put("ocirc", new Integer(244));
        isochars.put("otilde", new Integer(245));
        isochars.put("ouml", new Integer(246));
        isochars.put("divide", new Integer(247));
        isochars.put("oslash", new Integer(248));
        isochars.put("ugrave", new Integer(249));
        isochars.put("uacute", new Integer(250));
        isochars.put("ucirc", new Integer(251));
        isochars.put("uuml", new Integer(252));
        isochars.put("yacute", new Integer(253));
        isochars.put("thorn", new Integer(254));
        isochars.put("yuml", new Integer(255));
    }
}

