/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4;
import java.util.Vector;

public class Imap4Cmd {
    static final int OPEN = 0;
    static final int CLOSED = 1;
    static final int TIMEOUT = 2;
    static final int NONE = 0;
    static final int OK = 1;
    static final int NO = 2;
    static final int BAD = 3;
    private String cmdID = null;
    private String resp = null;
    private Vector text;
    private int status = 0;
    private int result = 0;

    Imap4Cmd(String cmdID) {
        this.cmdID = new String(cmdID);
        this.text = new Vector();
    }

    public String getCmdID() {
        return this.cmdID;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public int getResult() {
        return this.result;
    }

    public int getSize() {
        return this.text.size();
    }

    public String get(int i) {
        String text = null;
        if (i >= 0 && i < this.text.size()) {
            text = (String)this.text.elementAt(i);
        }
        return text;
    }

    public String getResponse() {
        if (this.resp == null) {
            switch (this.status) {
                case 2: {
                    this.resp = new String(String.valueOf(String.valueOf("IMAP4 Command timeout after [").concat(String.valueOf(Imap4.getIdleTime()))).concat(String.valueOf("] seconds.")));
                    break;
                }
                case 0: {
                    this.resp = new String("IMAP4 Command is still awaiting a response.");
                    break;
                }
                case 1: {
                    this.resp = new String("IMAP4 Command was closed with no response.");
                }
            }
        }
        return this.resp;
    }

    protected void add(String rec) {
        boolean go = true;
        if (rec.startsWith(String.valueOf(this.cmdID).concat(String.valueOf(" ")))) {
            String line = new String(rec.substring(this.cmdID.length() + 1).toUpperCase());
            if (line.startsWith("BAD")) {
                go = false;
                this.result = 3;
                this.resp = rec;
                this.status = 1;
            } else if (line.startsWith("OK")) {
                go = false;
                this.result = 1;
                this.resp = rec;
                this.status = 1;
            } else if (line.startsWith("NO")) {
                go = false;
                this.result = 2;
                this.resp = rec;
                this.status = 1;
            }
        }
        if (go) {
            this.text.addElement(rec);
        }
    }
}

