/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4;
import innoval.mail.Imap4Cmd;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4FileWriter;
import java.io.File;
import java.util.Vector;

public class Imap4Message {
    private Imap4 imap = null;
    private Vector header = new Vector();
    private Vector realhdr = new Vector();
    private Vector detail = new Vector();
    private Vector body = new Vector();
    private int index = 0;
    private int bytes = 0;
    private int maxBytes = -1;
    private boolean large = false;
    private String uid = null;
    private String recdate = null;
    private String maxText = null;

    Imap4Message(Imap4 imap) {
        this.imap = imap;
    }

    Imap4Message(Imap4 imap, int index) {
        this.imap = imap;
        this.index = index;
    }

    public void setLarge(boolean large) {
        this.large = large;
    }

    public String getSubject() {
        return this.getHeader("SUBJECT");
    }

    public String getTo() {
        return this.getHeader("TO");
    }

    public String getFrom() {
        return this.getHeader("FROM");
    }

    public String getDate() {
        return this.getHeader("DATE");
    }

    public String getReceivedDate() {
        return this.recdate;
    }

    public String getUID() {
        return this.uid;
    }

    public String getHeader(String hdr) {
        String text = "";
        int spot = this.header.indexOf(hdr.toUpperCase());
        if (spot >= 0) {
            text = new String((String)this.detail.elementAt(spot));
        }
        return text;
    }

    public int getHeaderCount() {
        return this.header.size();
    }

    public String getHeader(int num) {
        String text = "";
        if (num >= 0 && num < this.getHeaderCount()) {
            text = new String(String.valueOf(String.valueOf((String)this.realhdr.elementAt(num)).concat(String.valueOf(": "))).concat(String.valueOf((String)this.detail.elementAt(num))));
        }
        return text;
    }

    public int getIndex() {
        return this.index;
    }

    public int getBodyCount() {
        return this.body.size();
    }

    public String getBody(int num) {
        String text = "";
        if (num >= 0 && num < this.getBodyCount()) {
            text = (String)this.body.elementAt(num);
        }
        return text;
    }

    public int getSize() {
        return this.bytes;
    }

    public void setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    public void setMaxText(String text) {
        this.maxText = text;
    }

    protected void parseHeader(String text) {
        if (text.startsWith("*") && text.toUpperCase().indexOf("RFC822.SIZE") > 0) {
            this.parseIndex(text);
            this.parseUID(text);
            this.parseBytes(text);
        } else if (text.toUpperCase().indexOf("INTERNALDATE") > 0) {
            this.parseRecDate(text);
        } else if (Imap4Message.isHeaderLine(text)) {
            this.parseHeaderLine(text);
        } else if (text.trim().length() > 0) {
            this.addHeaderLine(text);
        }
    }

    private void parseIndex(String text) {
        int spot = (text = new String(text.substring(2).trim())).indexOf(" ");
        if (spot > 0) {
            text = new String(text.substring(0, spot).trim());
        }
        try {
            this.index = Integer.valueOf(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void parseUID(String text) {
        int spot = text.indexOf(" UID ");
        if (spot > 0) {
            if ((spot = (text = new String(text.substring(spot + 5).trim())).indexOf(32)) > 0) {
                text = new String(text.substring(0, spot));
            }
            this.uid = new String(text);
        }
    }

    private void parseBytes(String text) {
        int spot = text.toUpperCase().indexOf("RFC822.SIZE");
        if (spot > 0) {
            if ((spot = (text = new String(text.substring(spot + 12))).indexOf(32)) > 0) {
                text = new String(text.substring(0, spot));
            }
            try {
                this.bytes = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void parseRecDate(String text) {
        if ((text = new String(text.replace('\"', ' ').replace(')', ' ').trim())).toUpperCase().startsWith("INTERNALDATE")) {
            text = new String(text.substring(12).trim());
            text = new String(String.valueOf(text.substring(0, 12).replace('-', ' ')).concat(String.valueOf(text.substring(12))));
            this.recdate = new String(text);
        }
    }

    private void parseHeaderLine(String text) {
        int spot = text.indexOf(58);
        String hdr = text.substring(0, spot);
        String data = "";
        if (text.length() > spot + 2) {
            data = new String(text.substring(spot + 2));
        }
        this.realhdr.addElement(hdr);
        this.header.addElement(hdr.toUpperCase());
        this.detail.addElement(data);
    }

    private void addHeaderLine(String text) {
        while (text.length() > 0 && (text.charAt(0) == ' ' || text.charAt(0) == '\t')) {
            text = new String(text.substring(1));
        }
        if (this.detail.size() > 0) {
            int spot = this.detail.size() - 1;
            String rec = (String)this.detail.elementAt(spot);
            rec = new String(String.valueOf(rec).concat(String.valueOf(text)));
            this.detail.setElementAt(rec, spot);
        }
    }

    public void readMessage(int index) throws Imap4Exception {
        this.index = index;
        this.readMessage();
    }

    public void readMessage() throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Reading message [").concat(String.valueOf(this.index))).concat(String.valueOf("]...")));
        if (this.index > 0) {
            if (this.getHeaderCount() > 0) {
                this.readBody();
            } else {
                this.readWholeMessage();
            }
        } else {
            throw new Imap4Exception("Message index number is unknown");
        }
    }

    public void readWholeMessage() throws Imap4Exception {
        this.imap.setText(String.valueOf(String.valueOf("Reading message [").concat(String.valueOf(this.index))).concat(String.valueOf("]...")));
        this.readHeaders();
        this.readBody();
    }

    public void readHeaders() throws Imap4Exception {
        Imap4Cmd cmd = null;
        this.header.removeAllElements();
        cmd = this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf("FETCH ").concat(String.valueOf(this.index))).concat(String.valueOf(" (RFC822.SIZE "))).concat(String.valueOf("UID RFC822.HEADER INTERNALDATE)")));
        if (cmd.getResult() == 1) {
            for (int i = 0; i < cmd.getSize(); ++i) {
                this.parseHeader(cmd.get(i));
            }
        } else {
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    public void readBody() throws Imap4Exception {
        Imap4Cmd cmd = null;
        this.body.removeAllElements();
        cmd = this.maxBytes > 0 ? this.imap.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf("PARTIAL ").concat(String.valueOf(this.index))).concat(String.valueOf(" (RFC822.TEXT 1 "))).concat(String.valueOf(this.maxBytes))).concat(String.valueOf(")"))) : this.imap.issueCmd(String.valueOf(String.valueOf("FETCH ").concat(String.valueOf(this.index))).concat(String.valueOf(" RFC822.TEXT")));
        if (cmd.getResult() == 1) {
            int bytes = this.parseBodyBytes(cmd.get(0));
            int i = 1;
            String rec = null;
            for (int cnt = 0; (cnt < bytes || bytes < 0) && i < cmd.getSize(); cnt += rec.length() + 2) {
                rec = cmd.get(i++);
                this.body.addElement(rec);
            }
        } else {
            throw new Imap4Exception(cmd.getResponse());
        }
    }

    private int parseBodyBytes(String text) {
        int bytes = -1;
        int spot = text.indexOf(123);
        int spot1 = text.indexOf(125);
        if (spot1 > 0) {
            try {
                bytes = Integer.valueOf(text.substring(spot + 1, spot1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bytes;
    }

    public void writeMessage(File file) throws Imap4Exception {
        Imap4FileWriter out;
        if (this.getHeaderCount() == 0) {
            this.readHeaders();
        }
        if (this.getBodyCount() == 0) {
            this.readBody();
        }
        if ((out = new Imap4FileWriter()).open(file)) {
            boolean go = true;
            for (int i = 0; i < this.getHeaderCount(); ++i) {
                if (!go) {
                    go = Imap4Message.isHeaderLine(this.getHeader(i));
                }
                if (!(!go || this.large && this.getHeader(i).toLowerCase().startsWith("content-type:"))) {
                    out.lineOut(String.valueOf(this.getHeader(i)).concat(String.valueOf("\n")));
                    continue;
                }
                go = false;
            }
            out.lineOut("\n");
            for (int i = 0; i < this.getBodyCount(); ++i) {
                out.lineOut(String.valueOf(this.getBody(i)).concat(String.valueOf("\n")));
            }
            if (this.getSize() >= this.maxBytes && this.maxText != null) {
                out.lineOut(this.maxText);
            }
            out.close();
        }
    }

    public static boolean isHeaderLine(String text) {
        boolean ret_code = false;
        int spot = text.indexOf(58);
        int spot1 = text.indexOf(32);
        int spot2 = text.indexOf(9);
        if (!(spot <= 0 || spot1 >= 0 && spot >= spot1 || spot2 >= 0 && spot >= spot2)) {
            ret_code = true;
        }
        return ret_code;
    }

    public void delete() throws Imap4Exception {
        if (this.index > 0) {
            Imap4Cmd cmd = null;
            cmd = this.imap.issueCmd(String.valueOf(String.valueOf("STORE ").concat(String.valueOf(this.index))).concat(String.valueOf(" +FLAGS (\\Deleted)")));
            if (cmd.getResult() != 1) {
                throw new Imap4Exception(cmd.getResponse());
            }
        } else {
            throw new Imap4Exception("The message index file is unknown.");
        }
    }
}

