/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.CharacterSet;
import innoval.mailer.PopFileReader;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.jstreet;
import java.io.File;
import java.util.Vector;

public class CharacterSets {
    static final String DEFAULT = new String("us-ascii");
    static final String DEFINBOUND = new String("iso-8859-1");
    private Vector set = null;
    private jstreet Jstreet;

    CharacterSets(jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.set = new Vector();
        this.init();
    }

    private void init() {
        CharacterSet charset = null;
        charset = new CharacterSet("us-ascii");
        charset.setDesc("MIME default");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-1");
        charset.setDesc("ISO Latin-1");
        charset.setChars("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb     \u00c1\u00c2\u00c0\u00a9    \u00a2\u00a5       \u00e3\u00c3       \u00a4\u00f0\u00d0\u00ca\u00cb\u00c8 \u00cd\u00ce\u00cf    \u00a6\u00cc \u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5\u00fe\u00de\u00da\u00db\u00d9\u00fd\u00dd\u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-2");
        charset.setDesc("ISO Latin-2");
        charset.setChars("\u00c7\u00fc\u00e9\u00e2\u00e4  \u00e7 \u00eb  \u00ee \u00c4 \u00c9  \u00f4\u00f6    \u00d6\u00dc   \u00d7 \u00e1\u00ed\u00f3\u00fa                 \u00c1\u00c2                        \u00a4\u00f0\u00d0 \u00cb  \u00cd\u00ce        \u00d3\u00df\u00d4      \u00da  \u00fd\u00dd \u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8     \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-3");
        charset.setDesc("ISO Latin-3");
        charset.setChars("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0 \u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4 \u00c9  \u00f4\u00f6\u00f2\u00fb\u00f9 \u00d6\u00dc \u00a3 \u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1     \u00bd         \u00c1\u00c2\u00c0                       \u00a4  \u00ca\u00cb\u00c8\u00b9\u00cd\u00ce\u00cf     \u00cc \u00d3\u00df\u00d4\u00d2  \u00b5  \u00da\u00db\u00d9   \u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8\u00b7 \u00b3\u00b2 \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-4");
        charset.setDesc("ISO Latin-4");
        charset.setChars(" \u00fc\u00e9\u00e2\u00e4 \u00e5  \u00eb  \u00ee \u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6 \u00fb  \u00d6\u00dc\u00f8 \u00d8\u00d7 \u00e1\u00ed \u00fa                 \u00c1\u00c2               \u00e3\u00c3       \u00a4 \u00d0 \u00cb  \u00cd\u00ce         \u00df\u00d4 \u00f5\u00d5   \u00da\u00db   \u00af\u00b4\u00ad    \u00a7\u00f7\u00b8\u00b0\u00a8     \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-5");
        charset.setDesc("Cyrillic");
        charset.setChars("         \u00f1 \u00f7                  \u00e5                                                    \u00a1    \u00a7                       \u00ad    \u00fd         \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-6");
        charset.setDesc("Arabic");
        charset.setChars("                                                                               \u00a4                               \u00ee\u00ad              \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-7");
        charset.setDesc("Modern Greek");
        charset.setChars("                            \u00a3             \u00ac\u00bd  \u00ab\u00bb        \u00a9                               \u00da    \u00a6   \u00e2    \u00ec       \u00af \u00ad\u00b1   \u00a7  \u00b0\u00a8\u00b7 \u00b3\u00b2 \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-8");
        charset.setDesc("Hebrew");
        charset.setChars("                            \u00a3 \u00aa          \u00ae\u00ac\u00bd\u00bc \u00ab\u00bb        \u00a9    \u00a2\u00a5                \u00a4     \u00e1       \u00a6        \u00b5       \u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00ba\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-9");
        charset.setDesc("ISO Latin-5");
        charset.setChars("\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7 \u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb     \u00c1\u00c2\u00c0\u00a9    \u00a2\u00a5       \u00e3\u00c3       \u00a4  \u00ca\u00cb\u00c8\u00fd\u00cd\u00ce\u00cf    \u00a6\u00cc \u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5  \u00da\u00db\u00d9  \u00af\u00b4\u00ad\u00b1 \u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2 \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("iso-8859-10");
        charset.setDesc("ISO Latin-6");
        charset.setChars(" \u00fc\u00e9\u00e2\u00e4 \u00e5  \u00eb \u00ef\u00ee \u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6 \u00fb  \u00d6\u00dc\u00f8 \u00d8  \u00e1\u00ed\u00f3\u00fa                 \u00c1\u00c2               \u00e3\u00c3        \u00f0\u00a9 \u00cb  \u00cd\u00ce\u00cf       \u00d3\u00df\u00d4 \u00f5\u00d5 \u00fe\u00de\u00da\u00db \u00fd\u00dd  \u00ad    \u00a7  \u00b0 \u00b7    \u00a0");
        this.set.addElement(charset);
        charset = new CharacterSet("koi8-r");
        charset.setDesc("Russian Standard");
        charset.setChars("         \u00a3                    \u00c8                 \u0090\u0091\u0092\u0081\u0087   \u00bf\u00b5\u00a1\u00a8\u00ae  \u0083\u0084\u0089\u0088\u0086\u0080\u008a  \u00ab\u00a5\u00bb\u00b8\u00b1\u00a0\u00be    \u00b3     \u0085\u0082\u008d\u008c  \u008b                      \u009f \u009c \u009e  \u009d\u0094\u009a");
        this.set.addElement(charset);
        this.addCharSets(this.Jstreet.getSystemDir());
        this.addCharSets(this.Jstreet.getAccountDir());
    }

    private void addCharSets(String dir) {
        File file = new File(dir, jstreet.CHARSETFILE);
        PopFileReader in = null;
        String text = "";
        String name = null;
        int spot = 0;
        CharacterSet charset = null;
        if (file.exists() && (in = new PopFileReader()).open(file)) {
            while (text != null) {
                text = in.lineIn();
                if (text == null || text.length() <= 1) continue;
                if (text.charAt(0) == '+') {
                    spot = (text = new String(text.substring(1).trim())).indexOf(40);
                    if (spot >= 0) {
                        name = new String(text.substring(0, spot).trim());
                        if ((spot = (text = new String(text.substring(spot + 1))).indexOf(41)) >= 0) {
                            text = new String(text.substring(0, spot).trim());
                        }
                    }
                    charset = new CharacterSet(text.toLowerCase());
                    if (name == null || name.length() <= 0) continue;
                    charset.setDesc(name);
                    continue;
                }
                if (text.charAt(0) != '>' || charset == null) continue;
                charset.setChars(text.substring(1));
                this.addCharSet(charset);
            }
            in.close();
        }
    }

    public void addCharSet(CharacterSet charset) {
        CharacterSet element = null;
        boolean found = false;
        for (int i = 0; i < this.set.size(); ++i) {
            element = (CharacterSet)this.set.elementAt(i);
            if (!element.getSet().equals(charset.getSet())) continue;
            found = true;
            break;
        }
        if (found) {
            element.setDesc(charset.getDesc());
            element.setChars(charset.getChars());
        } else {
            this.set.addElement(charset);
        }
    }

    public int size() {
        return this.set.size();
    }

    public CharacterSet getCharSet(int i) {
        if (i >= 0 && i < this.size()) {
            return (CharacterSet)this.set.elementAt(i);
        }
        return null;
    }

    public String getName(int i) {
        String text = null;
        CharacterSet charset = this.getCharSet(i);
        text = charset != null ? charset.getSetName() : new String("");
        return text;
    }

    public CharacterSet findSet(String name) {
        CharacterSet tset = null;
        boolean found = false;
        for (int i = 0; i < this.size(); ++i) {
            tset = (CharacterSet)this.set.elementAt(i);
            if (!name.equalsIgnoreCase(tset.getSet())) continue;
            found = true;
            break;
        }
        if (!found) {
            tset = null;
        }
        return tset;
    }

    public CharacterSet getDefault() {
        CharacterSet set = null;
        String name = this.Jstreet.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.CHARSET, DEFAULT);
        set = this.findSet(name);
        if (set == null) {
            set = this.findSet(DEFAULT);
        }
        return set;
    }

    public CharacterSet getDecodeDefault() {
        CharacterSet set = null;
        String name = this.Jstreet.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.INCHARSET, DEFAULT);
        set = this.findSet(name);
        if (set == null) {
            set = this.findSet(DEFAULT);
        }
        return set;
    }

    public String fromLatin1(String text) {
        CharacterSet set = this.findSet(DEFINBOUND);
        if (set != null) {
            text = set.untranslateString(text);
        }
        return text;
    }
}

