/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.Address;
import innoval.mailer.MsgBox;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class GetNickname
extends Dialog
implements KeyListener,
ActionListener {
    private boolean ret_code;
    private String nickname;
    private Frame frame;
    private AddrBook addrbook;
    private Address addr;
    private Button okButton;
    private Button cancelButton;
    private TextField nickField;

    GetNickname(Frame frame, AddrBook addrbook, Address addr) {
        super(frame, "Get a Unique Address Book Nickname", true);
        this.addrbook = addrbook;
        this.addr = addr;
        this.setupDialog();
        this.show();
    }

    private void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 10, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 150, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Fullname:", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        label = new Label(this.addr.fullname);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(label, con);
        label = new Label("Nickname", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(label, con);
        this.nickField = new TextField(this.addr.nickname);
        this.nickField.addKeyListener(this);
        this.add(this.nickField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        con.gridwidth = 2;
        grid.setConstraints(this.nickField, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 4;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.checkNickname()) {
                this.ret_code = true;
                this.dispose();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private boolean checkNickname() {
        MsgBox msg;
        boolean ret_code = true;
        if (ret_code && this.nickField.getText().trim().length() == 0) {
            msg = new MsgBox(this.addrbook, "Please enter a nickname value.");
            this.nickField.requestFocus();
            ret_code = false;
        }
        if (ret_code && this.addrbook.getAddressBook().checkNickname(this.nickField.getText().trim())) {
            msg = new MsgBox(this.addrbook, "The specified nickname is not unique within the current address book.");
            ret_code = false;
            this.nickField.requestFocus();
        }
        if (ret_code) {
            this.nickname = new String(this.nickField.getText().trim());
        }
        return ret_code;
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public String getText() {
        return this.nickname;
    }
}

