/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mail.Imap4;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4Folder;
import innoval.mail.Imap4Message;
import innoval.mailer.DownLoadImapMail;
import innoval.mailer.FilterExecute;
import innoval.mailer.GenPopName;
import innoval.mailer.MsgBox;
import innoval.mailer.NewInboxMessage;
import innoval.mailer.NoteList;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.SettingsAdvanced;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.UIDLHandler;
import innoval.mailer.jstreet;
import java.awt.Frame;
import java.awt.Label;
import java.io.File;

public class ImapRetrieve {
    private String server;
    private String userid;
    private String password;
    private Imap4 imap;
    private Imap4Folder folder;
    private int notes;
    private int filtered;
    private int downloaded;
    private int port;
    private int maxBytes;
    private int connectTime = 60;
    private int lastMessage;
    private String mailbox = new String("");
    private String inchar = new String("");
    private jstreet parent;
    private DownLoadImapMail downloadmail;
    private File popname;
    private File currentPopfile;
    private NoteList notelist;
    private boolean deleteMessages;
    private boolean stop;
    private boolean newonly = false;
    private boolean active;

    ImapRetrieve(jstreet parent, NoteList notelist, String serv, String user, String pw, int pnum) {
        this.server = serv;
        this.userid = user;
        this.password = pw;
        this.port = pnum;
        this.parent = parent;
        this.notelist = notelist;
        this.active = true;
        this.setTimeout();
    }

    public void setMailBox(String mailbox) {
        this.mailbox = new String(mailbox);
    }

    private void setTimeout() {
        try {
            this.connectTime = Integer.valueOf(this.parent.getProfile().ReadString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.POPTIMEOUT, "60"));
        }
        catch (NumberFormatException e) {
            this.connectTime = 60;
        }
    }

    public void setStop(boolean val) {
        this.stop = val;
    }

    public void setMaxKiloBytes(int maxBytes) {
        this.maxBytes = maxBytes * 1024;
    }

    public void setNewOnly(boolean newonly) {
        this.newonly = newonly;
    }

    public void setDelete(boolean val) {
        this.deleteMessages = val;
    }

    public int Notes() {
        return this.notes;
    }

    public int Filtered() {
        return this.filtered;
    }

    public int Downloaded() {
        return this.downloaded;
    }

    public void GetMail(jstreet parent, Label text, File file) {
        this.downloadmail = new DownLoadImapMail(this, parent, text, file);
        this.downloadmail.start();
    }

    public void BreakMail(Frame parent, Label text) {
        if (this.downloadmail != null) {
            text.setText("Halting message download...");
            this.downloadmail.setStop(true);
            this.downloadmail = null;
        }
    }

    public int goGetMail(DownLoadImapMail thread, Label text, File file) {
        boolean logon = false;
        boolean large = false;
        boolean go = true;
        Imap4Message msg = null;
        String retCode = null;
        NewInboxMessage newmsg = null;
        Object pop = null;
        UIDLHandler huidl = null;
        int i = 0;
        int count = 0;
        int total = 0;
        int deleted = 0;
        int mailmapstyle = 0;
        String mailmapEmail = this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPEMAIL, "");
        boolean uidl = true;
        this.downloaded = 0;
        this.filtered = 0;
        this.notes = 0;
        if (!thread.stop) {
            jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.REFRESHEXIT);
        }
        if (mailmapEmail.length() > 0) {
            mailmapstyle = Integer.valueOf(this.parent.getProfile().ReadString(SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.MAILMAPSTYLE, "0"));
        }
        if (!thread.stop) {
            logon = this.imapConnect(text);
        }
        if (logon) {
            total = this.folder.getMessageCount();
            if (!thread.stop && total > 0) {
                huidl = new UIDLHandler(this.parent);
                text.setText("Retrieving messages...");
                while (!thread.stop && i < total) {
                    try {
                        msg = this.folder.getMessage(++i);
                        this.popname = new File(new GenPopName(file.getAbsolutePath()).getName());
                        if (huidl != null) {
                            huidl.addNew(msg.getUID());
                        }
                        go = true;
                    }
                    catch (Imap4Exception e) {
                        go = false;
                        System.out.println(e.toString());
                    }
                    if (go) {
                        if (!thread.stop && mailmapEmail.length() > 0) {
                            text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Mailmapping [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                            go = PopFileProcedure.mailMap(msg, mailmapEmail, mailmapstyle);
                        } else {
                            go = true;
                        }
                    }
                    if (!thread.stop && go && this.newonly) {
                        boolean bl = go = !huidl.findId(msg.getUID());
                    }
                    if (thread.stop || !go) continue;
                    text.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(i))).concat(String.valueOf("] of ["))).concat(String.valueOf(total))).concat(String.valueOf("].")));
                    if (msg.getSize() > this.maxBytes && this.maxBytes > 0) {
                        large = true;
                        msg.setMaxBytes(this.maxBytes);
                        msg.setMaxText(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\n\n<html><body><hr>\n<center>ATTENTION: This notice was added by The J Street Mailer.</center>\n<center><hr width=200></center>\nThe remainder of this message has been left on your server because its \nsize [").concat(String.valueOf(msg.getSize()))).concat(String.valueOf(" bytes] exceeds the limit imposed in your General Settings ["))).concat(String.valueOf(this.maxBytes))).concat(String.valueOf(" \n"))).concat(String.valueOf("bytes]. Please use the \"Preview Mail\" option to view the mail remaining on "))).concat(String.valueOf("your message server.\n<hr>\n")));
                    } else {
                        large = false;
                    }
                    try {
                        msg.writeMessage(this.popname);
                    }
                    catch (Imap4Exception e) {
                        System.out.println(e.toString());
                    }
                    if (!thread.stop && this.popname.exists() && this.popname.length() > (long)0) {
                        if (uidl) {
                            huidl.addId(msg.getUID());
                        }
                        ++this.downloaded;
                        if (this.deleteMessages && !large) {
                            try {
                                msg.delete();
                                ++deleted;
                            }
                            catch (Imap4Exception e) {
                                System.out.println(e.toString());
                            }
                        }
                        FilterExecute runFilters = new FilterExecute(this.parent, this.popname.getParent(), this.popname.getName());
                        retCode = runFilters.getReturnCode();
                        runFilters = null;
                    }
                    if (!thread.stop && this.popname.exists() && this.popname.length() > (long)0) {
                        if (newmsg == null) {
                            newmsg = new NewInboxMessage(this.parent);
                        }
                        if (retCode != null && retCode.startsWith("cc")) {
                            newmsg.add(this.popname, Integer.valueOf(retCode.substring(2, 3)));
                        } else {
                            newmsg.add(this.popname);
                        }
                        this.popname.delete();
                        this.popname = null;
                        ++count;
                        continue;
                    }
                    if (!this.popname.exists() || this.popname.length() != (long)0) continue;
                    this.popname.delete();
                    break;
                }
            }
        }
        if (huidl != null) {
            huidl.saveServer();
            huidl = null;
        }
        this.notes = count;
        this.filtered = this.downloaded - this.notes;
        if (this.deleteMessages && deleted > 0) {
            try {
                if (this.folder != null) {
                    this.folder.removeMessages();
                }
            }
            catch (Imap4Exception e) {
                System.out.println(e.toString());
            }
        }
        try {
            if (this.folder != null) {
                this.folder.close();
            }
            this.imap.close();
        }
        catch (Imap4Exception e) {
            System.out.println(e.toString());
        }
        this.downloadmail = null;
        if (!thread.stop) {
            jstreet.runExitProgram(this.parent, SettingsAdvanced.SAVEADVANCED, SettingsAdvanced.REFRESHFEXIT);
        }
        this.parent.RetrieveComplete();
        return count;
    }

    private boolean imapConnect(Label text) {
        boolean ret_code = false;
        this.imap = new Imap4();
        this.imap.setDebug(false);
        this.imap.setNoop(true);
        this.imap.setLabel(text);
        this.imap.setUserid(this.userid);
        this.imap.setPassword(this.password);
        this.imap.setPort(this.port);
        this.imap.setServer(this.server);
        try {
            if (this.imap.open()) {
                this.folder = new Imap4Folder(this.imap, "", this.mailbox);
                ret_code = this.folder.open();
            }
        }
        catch (Imap4Exception e) {
            MsgBox msgBox = new MsgBox(this.parent, e.toString());
        }
        return ret_code;
    }
}

