/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.MsgBox;
import innoval.mailer.NoteWinBrowser;
import innoval.mailer.NoteWinHotJava;
import innoval.mailer.NoteWinText;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.io.File;

public class NoteWin
extends Panel
implements ClipboardOwner {
    static final int NEXTMESSAGE = 0;
    static final int PREVMESSAGE = 1;
    static final int NEXTUNREAD = 2;
    static final int PREVUNREAD = 3;
    static final int COLORCODE = 4;
    static final int DELETE = 5;
    static final int FORWARD = 6;
    static final int TOGGLEHEADERS = 7;
    static final int FOLDERMOVE = 8;
    static final int PRINT = 9;
    static final int REPLY = 10;
    static final int STICKYNOTES = 11;
    static final int TOGGLEWORDWRAP = 12;
    static final int TOGGLEFONT = 13;
    static final int TOGGLEWINDOW = 14;
    static final int MSG_BROWSER = 0;
    static final int MSG_TEXTAREA = 1;
    static final int MSG_HOTJAVA = 2;
    static final String[] COMMANDS = new String[]{"NEXTMESSAGE", "PREVMESSAGE", "NEXTUNREAD", "PREVUNREAD", "COLORCODE", "DELETE", "FORWARD", "TOGGLEHEADERS", "FOLDERMOVE", "PRINT", "REPLY", "STICKYNOTES", "TOGGLEWORDWRAP", "TOGGLEFONT", "TOGGLEWINDOW"};
    private jstreet parent;
    private int msgViewStyle = 1;
    private NoteWinBrowser browser = null;
    private NoteWinHotJava hotjava = null;
    private NoteWinText textarea = null;
    private File popfile = null;
    private int headerState = 2;
    private int fontSize = 1;
    private int reloads = 0;
    private boolean clear = false;
    private boolean formatState = true;
    private boolean decodeState = true;

    NoteWin(jstreet frame) {
        super(new BorderLayout());
        this.parent = frame;
    }

    public int getViewStyle() {
        return this.msgViewStyle;
    }

    public void setViewStyle(int val, Label text) {
        this.setVisible(false);
        if (this.msgViewStyle == 1 && this.textarea != null) {
            this.remove(this.textarea);
        } else if (this.msgViewStyle == 2 && this.hotjava != null) {
            this.remove(this.hotjava);
        } else if (this.msgViewStyle == 0 && this.browser != null) {
            this.remove(this.browser);
        }
        this.msgViewStyle = val;
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea = this.formatState ? new NoteWinText(this.parent, this.formatState) : new NoteWinText(this.parent);
                if (this.textarea != null) {
                    if (this.browser != null || this.hotjava != null) {
                        this.removeNotify();
                        this.addNotify();
                    }
                    this.add("Center", this.textarea);
                    this.textarea.setHeaderState(this.headerState, text);
                    this.textarea.setFontSize(this.fontSize);
                    this.textarea.setDecodeState(this.decodeState, text);
                    this.textarea.setFormatState(this.formatState, text);
                    if (this.popfile == null) break;
                    this.textarea.load(this.popfile, text);
                    break;
                }
                System.out.println("Error creating message text window.");
                break;
            }
            case 0: {
                this.browser = new NoteWinBrowser(this.parent);
                if (this.browser != null) {
                    if (this.textarea != null || this.hotjava != null) {
                        this.removeNotify();
                        this.addNotify();
                    }
                    this.add("Center", this.browser);
                    this.browser.setHeaderState(this.headerState, text);
                    this.browser.setFontSize(this.fontSize, text);
                    this.browser.setDecodeState(this.decodeState, text);
                    this.browser.setFormatState(this.formatState, text);
                    if (this.popfile == null) break;
                    this.browser.load(this.popfile, text);
                    break;
                }
                System.out.println("Error creating message browser window.");
                break;
            }
            case 2: {
                try {
                    this.hotjava = new NoteWinHotJava(this.parent);
                    if (this.hotjava != null) {
                        if (this.textarea != null || this.browser != null) {
                            this.removeNotify();
                            this.addNotify();
                        }
                        this.setVisible(false);
                        this.add("Center", this.hotjava);
                        this.validate();
                        this.hotjava.setHeaderState(this.headerState, text);
                        this.hotjava.setFontSize(this.fontSize, text);
                        this.hotjava.setDecodeState(this.decodeState, text);
                        this.hotjava.setFormatState(this.formatState, text);
                        if (this.popfile != null) {
                            this.hotjava.load(this.popfile, text);
                        }
                        this.setVisible(true);
                        break;
                    }
                    System.out.println("Error creating message Hot Java window.");
                    break;
                }
                catch (ClassNotFoundException e) {
                    this.noHotJavaError();
                    this.parent.setViewStyle(0);
                }
            }
        }
        this.setVisible(true);
        this.validate();
        this.clear = false;
    }

    public void setHeaderState(int val, Label text) {
        this.headerState = val;
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.setHeaderState(val, text);
                break;
            }
            case 0: {
                this.browser.setHeaderState(val, text);
                break;
            }
            case 2: {
                this.setViewStyle(this.msgViewStyle, text);
            }
        }
    }

    public int getHeaderState() {
        return this.headerState;
    }

    public void setFontSize(int val, Label text) {
        this.fontSize = val;
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.setFontSize(val);
                break;
            }
            case 0: {
                this.browser.setFontSize(val, text);
                break;
            }
            case 2: {
                this.setViewStyle(this.msgViewStyle, text);
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFormatState(boolean val, Label text) {
        this.formatState = val;
        switch (this.msgViewStyle) {
            case 1: {
                this.setViewStyle(1, text);
                break;
            }
            case 0: {
                this.browser.setFormatState(val, text);
                break;
            }
            case 2: {
                this.setViewStyle(this.msgViewStyle, text);
            }
        }
    }

    public boolean getFormatState() {
        return this.formatState;
    }

    public void setDecodeState(boolean val, Label text) {
        this.decodeState = val;
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.setDecodeState(val, text);
                break;
            }
            case 0: {
                this.browser.setDecodeState(val, text);
                break;
            }
            case 2: {
                this.setViewStyle(this.msgViewStyle, text);
            }
        }
    }

    public boolean getDecodeState() {
        return this.decodeState;
    }

    public File getFile() {
        return this.popfile;
    }

    public String getPopFile() {
        String pname = "";
        if (this.popfile != null) {
            pname = new String(this.popfile.getName());
        }
        return pname;
    }

    public void clear() {
        this.stopLoading();
        if (!this.clear) {
            this.popfile = null;
            this.clear = true;
            switch (this.msgViewStyle) {
                case 1: {
                    this.textarea.clear();
                    break;
                }
                case 0: {
                    this.browser.clear();
                    break;
                }
                case 2: {
                    this.hotjava.clear();
                    this.newHotJavaWindow(new Label());
                }
            }
        }
    }

    public void stopLoading() {
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.stopLoading();
                break;
            }
            case 0: {
                this.browser.stopLoading();
                break;
            }
            case 2: {
                this.hotjava.stopLoading();
            }
        }
    }

    public synchronized void load(File file, Label text) {
        this.popfile = file;
        this.clear = false;
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.stopLoading();
                this.textarea.load(file, text);
                break;
            }
            case 0: {
                this.browser.stopLoading();
                this.browser.load(file, text);
                break;
            }
            case 2: {
                this.hotjava.stopLoading();
                this.newHotJavaWindow(text);
                this.hotjava.load(file, text);
            }
        }
    }

    public void newHotJavaWindow(Label text) {
        this.remove(this.hotjava);
        this.hotjava = null;
        try {
            this.hotjava = new NoteWinHotJava(this.parent);
            if (this.hotjava != null) {
                this.setVisible(false);
                this.removeNotify();
                this.addNotify();
                this.add("Center", this.hotjava);
                this.validate();
                this.setVisible(true);
                this.hotjava.setHeaderState(this.headerState, text);
                this.hotjava.setFontSize(this.fontSize, text);
                this.hotjava.setDecodeState(this.decodeState, text);
                this.hotjava.setFormatState(this.formatState, text);
            } else {
                System.out.println("Error creating message Hot Java window.");
            }
        }
        catch (ClassNotFoundException e) {
            this.noHotJavaError();
            this.setViewStyle(0, text);
        }
    }

    private void noHotJavaError() {
        MsgBox msg = new MsgBox(this.parent, "The HotJavaBrowserBean.class was not found in your classpath.  Please add the HotJavaBean.jar file to your classpath and try again.  In the mean time, the ICE Browser window will be used as your message browser window.");
    }

    public void reload() {
        switch (this.msgViewStyle) {
            case 1: {
                this.textarea.reload();
                break;
            }
            case 0: {
                this.browser.reload();
                break;
            }
            case 2: {
                this.setViewStyle(this.msgViewStyle, new Label());
            }
        }
    }

    public String[] getKeyCmd() {
        String[] str = null;
        switch (this.msgViewStyle) {
            case 1: {
                str = this.textarea.getKeyCmd();
                break;
            }
            case 0: {
                str = this.browser.getKeyCmd();
                break;
            }
            case 2: {
                str = this.hotjava.getKeyCmd();
            }
        }
        return str;
    }

    public static int determineCommand(KeyEvent key, String[] keyCmd) {
        String text = KeyEvent.getKeyModifiersText(key.getModifiers()).trim();
        String keystring = KeyEvent.getKeyText(key.getKeyCode()).trim();
        int cmd = -1;
        if (text.length() > 0) {
            text = new String(String.valueOf(text).concat(String.valueOf("+")));
        }
        text = new String(String.valueOf(text).concat(String.valueOf(keystring)));
        text = new String(text.toUpperCase().trim());
        for (int i = 0; i < keyCmd.length; ++i) {
            if (!text.equals(keyCmd[i])) continue;
            cmd = i;
            break;
        }
        return cmd;
    }

    public void lostOwnership(Clipboard board, Transferable trans) {
    }

    public boolean copy() {
        boolean ret_code = false;
        String str = null;
        switch (this.msgViewStyle) {
            case 1: {
                str = this.textarea.getSelectedText();
                break;
            }
            case 0: {
                str = new String("");
                break;
            }
            case 2: {
                str = this.hotjava.getSelection().text;
            }
        }
        if (str != null) {
            StringSelection s = new StringSelection(str);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, s);
            if (str.length() > 0) {
                ret_code = true;
            }
        }
        return ret_code;
    }

    public String getSelectedText() {
        String str = null;
        switch (this.msgViewStyle) {
            case 1: {
                str = this.textarea.getSelectedText();
                break;
            }
            case 2: {
                str = this.hotjava.getSelection().text;
            }
        }
        return str;
    }
}

