/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FilterExecute;
import innoval.mailer.GenPopName;
import innoval.mailer.MaintainPop;
import innoval.mailer.MessageDownloadThread;
import innoval.mailer.MessageViewThread;
import innoval.mailer.MsgBox;
import innoval.mailer.NewInboxMessage;
import innoval.mailer.NotesLabel;
import innoval.mailer.Pop3;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.PreviewList;
import innoval.mailer.PreviewMailDelete;
import innoval.mailer.PreviewMailLoad;
import innoval.mailer.PreviewMailRetrieve;
import innoval.mailer.PreviewStartup;
import innoval.mailer.ViewFormattedMessage;
import innoval.mailer.ViewWindow;
import innoval.mailer.jstreet;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCMultiColumnList;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;

public class PreviewMail
extends Frame
implements JCActionListener,
ActionListener,
MouseListener {
    static final String TITLE = new String("Preview Mail");
    static final String TEMP_FILE = new String("@@@@$$$$.@$@");
    static final String COL_WIDTHS = new String("PreviewColumnWidths");
    static final int WINCX = 500;
    static final int WINCY = 300;
    static final int ALLMSGS = 0;
    static final int FIRST50 = 1;
    static final int FIRST25 = 2;
    static final int FIRST10 = 3;
    static final int LAST50 = 4;
    static final int LAST25 = 5;
    static final int LAST10 = 6;
    private Pop3 pop3 = null;
    private Vector delrecs = null;
    private Vector retrrecs = null;
    private boolean countonly = false;
    private boolean headers;
    private boolean done = false;
    private jstreet parent;
    private int messages;
    public PreviewMailLoad previewload = null;
    private PreviewMailDelete previewdel = null;
    private PreviewMailRetrieve previewretr = null;
    private PreviewList msgList = null;
    private MaintainPop maintainpop = null;
    public Label text = null;
    private NotesLabel msgs = null;
    private String server = null;
    private String userid = null;
    private String password = null;
    private String port = null;
    public PopupMenu messagePopup = null;
    private MenuBar menu;
    private Menu menuFile;
    private MenuItem IDM_FILE_PEEK;
    private MenuItem IDM_FILE_VIEW;
    private MenuItem IDM_FILE_VIEWFORMATTED;
    private MenuItem IDM_FILE_DOWNLOAD;
    private MenuItem IDM_FILE_RETRIEVE;
    private MenuItem IDM_FILE_MARKRETRIEVE;
    private MenuItem IDM_FILE_MARK;
    private MenuItem IDM_FILE_MARKALL;
    private MenuItem IDM_FILE_UNMARK;
    private MenuItem IDM_FILE_UNMARKALL;
    private MenuItem IDM_FILE_DELETE;
    private MenuItem IDM_FILE_REFRESH;
    private MenuItem IDM_FILE_BREAK;
    private MenuItem IDM_MFILE_PEEK;
    private MenuItem IDM_MFILE_VIEW;
    private MenuItem IDM_MFILE_VIEWFORMATTED;
    private MenuItem IDM_MFILE_DOWNLOAD;
    private MenuItem IDM_MFILE_RETRIEVE;
    private MenuItem IDM_MFILE_MARKRETRIEVE;
    private MenuItem IDM_MFILE_MARK;
    private MenuItem IDM_MFILE_MARKALL;
    private MenuItem IDM_MFILE_UNMARK;
    private MenuItem IDM_MFILE_UNMARKALL;
    private MenuItem IDM_MFILE_DELETE;

    public PreviewMail(jstreet parent) {
        this.parent = parent;
        this.messages = 0;
        this.setTitle(TITLE);
        this.enableEvents(64L);
    }

    public void setCount(boolean val) {
        this.countonly = val;
    }

    public void setHeaders(boolean val) {
        this.headers = val;
    }

    public void setMessages(int msgs) {
        this.messages = msgs;
    }

    public void setServer(String val) {
        this.server = new String(val);
    }

    public String getServer() {
        return this.server;
    }

    public void setUserid(String val) {
        this.userid = new String(val);
    }

    public String getUserid() {
        return this.userid;
    }

    public void setPassword(String val) {
        this.password = new String(val);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPort(String val) {
        this.port = new String(val);
    }

    public String getPort() {
        return this.port;
    }

    public void start() {
        PreviewStartup startup = new PreviewStartup(this);
        startup.show();
        if (startup.proceed()) {
            this.initWindow();
            this.show();
            this.load();
        } else {
            this.Close();
        }
    }

    private void initWindow() {
        Panel panel = new Panel();
        this.setupMenu();
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + 500, this.getInsets().top + this.getInsets().bottom + 300);
        Dimension dim = this.getToolkit().getScreenSize();
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        this.msgList = new PreviewList();
        this.msgList.addActionListener(this);
        this.msgList.getViewport().addMouseListener(this);
        this.setupMessagePopup();
        this.msgList.setBackground(SystemColor.control);
        this.setColumnWidths(this.msgList);
        this.msgList.setColumnButtons(JCUtilConverter.toStringList(" ,Msg,Subject,From,To,Date,Size"));
        this.msgList.setColumnAlignment(1, 5);
        this.msgList.setColumnAlignment(6, 5);
        this.msgList.setSpacing(2);
        this.msgList.setNumColumns(7);
        this.msgList.setRowHeight(20);
        this.msgList.setAllowMultipleSelections(true);
        this.text = new Label("");
        this.msgs = new NotesLabel("");
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gb);
        try {
            PreviewMail.addComponent(panel, this.text, 0, 0, 8, 1, 1, 17, 1, 1);
            PreviewMail.addComponent(panel, this.msgs, 8, 0, 0, 1, 1, 13, 0, 0);
        }
        catch (Exception e) {
            MsgBox msgBox = new MsgBox(this, String.valueOf("Error").concat(String.valueOf(e)));
        }
        this.add("South", panel);
        this.add("Center", this.msgList);
    }

    public void setColumnWidths(JCMultiColumnList list) {
        String text = this.parent.getProfile().ReadString(jstreet.DEFAULT, COL_WIDTHS, "");
        if (text.length() == 0) {
            text = new String("20,50,200,100,100,100,100");
        }
        list.setColumnWidths(JCUtilConverter.toIntList(text, ','));
    }

    public void saveColumnWidths(JCMultiColumnList list) {
        if (list != null) {
            int[] col = list.getColumnWidths();
            String text = new String("");
            for (int i = 0; i < col.length; ++i) {
                text = i == 0 ? new String(String.valueOf(text).concat(String.valueOf(col[i]))) : new String(String.valueOf(String.valueOf(text).concat(String.valueOf(","))).concat(String.valueOf(col[i])));
            }
            this.parent.getProfile().WriteString(jstreet.DEFAULT, COL_WIDTHS, text, true);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int i;
        if (e.getModifiers() == 4 && this.msgList.countItems() > 0 && (i = this.calcItem(e.getY())) < this.msgList.countItems()) {
            if (!this.msgList.isSelected(i)) {
                this.deSelectAll();
                this.msgList.select(i);
            }
            this.messagePopup.show(this.msgList, e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void deSelectAll() {
        int[] index = this.msgList.getSelectedIndexes();
        if (index != null) {
            for (int i = 0; i < index.length; ++i) {
                this.msgList.deselect(index[i]);
            }
        }
    }

    public int calcItem(int y) {
        int height;
        int item = this.msgList.getTopRow();
        int base = height = this.msgList.getRowHeight();
        while (y > base) {
            base += height;
            ++item;
        }
        return item;
    }

    private void setupMenu() {
        this.menu = new MenuBar();
        this.menuFile = new Menu("File");
        this.IDM_FILE_PEEK = new MenuItem("View first 50 lines of the selected message...");
        this.IDM_FILE_PEEK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_PEEK);
        this.IDM_FILE_VIEW = new MenuItem("View the selected message (unformatted)...");
        this.IDM_FILE_VIEW.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_VIEW);
        this.IDM_FILE_VIEWFORMATTED = new MenuItem("View the selected message (formatted)...");
        this.IDM_FILE_VIEWFORMATTED.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_VIEWFORMATTED);
        this.menuFile.addSeparator();
        this.IDM_FILE_DOWNLOAD = new MenuItem("Retrieve selected message to a file...");
        this.IDM_FILE_DOWNLOAD.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_DOWNLOAD);
        this.IDM_FILE_RETRIEVE = new MenuItem("Retrieve selected message(s) to inbox");
        this.IDM_FILE_RETRIEVE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_RETRIEVE);
        this.IDM_FILE_MARKRETRIEVE = new MenuItem("Retrieve marked message(s) to inbox");
        this.IDM_FILE_MARKRETRIEVE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARKRETRIEVE);
        this.menuFile.addSeparator();
        this.IDM_FILE_MARK = new MenuItem("Mark selected message(s)");
        this.IDM_FILE_MARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARK);
        this.IDM_FILE_MARKALL = new MenuItem("Mark all");
        this.IDM_FILE_MARKALL.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_MARKALL);
        this.menuFile.addSeparator();
        this.IDM_FILE_UNMARK = new MenuItem("Unmark selected message(s)");
        this.IDM_FILE_UNMARK.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_UNMARK);
        this.IDM_FILE_UNMARKALL = new MenuItem("Unmark all");
        this.IDM_FILE_UNMARKALL.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_UNMARKALL);
        this.menuFile.addSeparator();
        this.IDM_FILE_DELETE = new MenuItem("Delete marked message(s)");
        this.IDM_FILE_DELETE.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_DELETE);
        this.menuFile.addSeparator();
        this.IDM_FILE_REFRESH = new MenuItem("Refresh the list of messages");
        this.IDM_FILE_REFRESH.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_REFRESH);
        this.menuFile.addSeparator();
        this.IDM_FILE_BREAK = new MenuItem("Stop message refresh");
        this.IDM_FILE_BREAK.addActionListener(this);
        this.IDM_FILE_BREAK.setEnabled(false);
        this.menuFile.add(this.IDM_FILE_BREAK);
        this.menu.add(this.menuFile);
        this.setMenuBar(this.menu);
    }

    public void setupMessagePopup() {
        this.messagePopup = new PopupMenu();
        this.IDM_MFILE_PEEK = new MenuItem("View first 50 lines of the selected message...");
        this.IDM_MFILE_PEEK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_PEEK);
        this.IDM_MFILE_VIEW = new MenuItem("View the selected message (unformatted)...");
        this.IDM_MFILE_VIEW.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_VIEW);
        this.IDM_MFILE_VIEWFORMATTED = new MenuItem("View the selected message (formatted)...");
        this.IDM_MFILE_VIEWFORMATTED.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_VIEWFORMATTED);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_DOWNLOAD = new MenuItem("Retrieve selected message to a file...");
        this.IDM_MFILE_DOWNLOAD.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_DOWNLOAD);
        this.IDM_MFILE_RETRIEVE = new MenuItem("Retrieve selected message(s) to inbox");
        this.IDM_MFILE_RETRIEVE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_RETRIEVE);
        this.IDM_MFILE_MARKRETRIEVE = new MenuItem("Retrieve marked message(s) to inbox");
        this.IDM_MFILE_MARKRETRIEVE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARKRETRIEVE);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_MARK = new MenuItem("Mark selected message(s)");
        this.IDM_MFILE_MARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARK);
        this.IDM_MFILE_MARKALL = new MenuItem("Mark all");
        this.IDM_MFILE_MARKALL.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_MARKALL);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_UNMARK = new MenuItem("Unmark selected message(s)");
        this.IDM_MFILE_UNMARK.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_UNMARK);
        this.IDM_MFILE_UNMARKALL = new MenuItem("Unmark all");
        this.IDM_MFILE_UNMARKALL.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_UNMARKALL);
        this.messagePopup.addSeparator();
        this.IDM_MFILE_DELETE = new MenuItem("Delete marked message(s)");
        this.IDM_MFILE_DELETE.addActionListener(this);
        this.messagePopup.add(this.IDM_MFILE_DELETE);
        this.msgList.add(this.messagePopup);
    }

    public void enableMenu(boolean parm) {
        this.IDM_FILE_PEEK.setEnabled(parm);
        this.IDM_FILE_VIEW.setEnabled(parm);
        this.IDM_FILE_VIEWFORMATTED.setEnabled(parm);
        this.IDM_FILE_DOWNLOAD.setEnabled(parm);
        this.IDM_FILE_RETRIEVE.setEnabled(parm);
        this.IDM_FILE_MARKRETRIEVE.setEnabled(parm);
        this.IDM_FILE_MARK.setEnabled(parm);
        this.IDM_FILE_MARKALL.setEnabled(parm);
        this.IDM_FILE_UNMARK.setEnabled(parm);
        this.IDM_FILE_UNMARKALL.setEnabled(parm);
        this.IDM_FILE_DELETE.setEnabled(parm);
        this.IDM_FILE_REFRESH.setEnabled(parm);
        this.IDM_FILE_BREAK.setEnabled(!parm);
        this.IDM_MFILE_PEEK.setEnabled(parm);
        this.IDM_MFILE_VIEW.setEnabled(parm);
        this.IDM_MFILE_VIEWFORMATTED.setEnabled(parm);
        this.IDM_MFILE_DOWNLOAD.setEnabled(parm);
        this.IDM_MFILE_RETRIEVE.setEnabled(parm);
        this.IDM_MFILE_MARKRETRIEVE.setEnabled(parm);
        this.IDM_MFILE_MARK.setEnabled(parm);
        this.IDM_MFILE_MARKALL.setEnabled(parm);
        this.IDM_MFILE_UNMARK.setEnabled(parm);
        this.IDM_MFILE_UNMARKALL.setEnabled(parm);
        this.IDM_MFILE_DELETE.setEnabled(parm);
    }

    public static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int fill, int anchor, int weightx, int weighty) throws AWTException {
        LayoutManager lm = container.getLayout();
        if (!(lm instanceof GridBagLayout)) {
            throw new AWTException(String.valueOf("Invalid layout").concat(String.valueOf(lm)));
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        container.add(component, gbc);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.IDM_FILE_VIEW || e.getSource() == this.IDM_MFILE_VIEW) {
            this.viewMessage();
        } else if (e.getSource() == this.IDM_FILE_VIEWFORMATTED || e.getSource() == this.IDM_MFILE_VIEWFORMATTED) {
            this.formatMessage();
        } else if (e.getSource() == this.IDM_FILE_RETRIEVE || e.getSource() == this.IDM_MFILE_RETRIEVE) {
            this.retrieveMessages(false);
        } else if (e.getSource() == this.IDM_FILE_MARKRETRIEVE || e.getSource() == this.IDM_MFILE_MARKRETRIEVE) {
            this.retrieveMessages(true);
        } else if (e.getSource() == this.IDM_FILE_PEEK || e.getSource() == this.IDM_MFILE_PEEK) {
            this.peekMessage();
        } else if (e.getSource() == this.IDM_FILE_DOWNLOAD || e.getSource() == this.IDM_MFILE_DOWNLOAD) {
            this.downloadMessage();
        } else if (e.getSource() == this.IDM_FILE_DELETE || e.getSource() == this.IDM_MFILE_DELETE) {
            if (this.markedRecords().size() > 0) {
                MsgBox msgbox = new MsgBox((Container)this, "Delete the marked message(s)?", 3);
                if (msgbox.ret_code == 0) {
                    this.deleteRecords();
                }
            }
        } else if (e.getSource() == this.IDM_FILE_MARK || e.getSource() == this.IDM_MFILE_MARK) {
            this.markSelectedRecords(true);
        } else if (e.getSource() == this.IDM_FILE_UNMARK || e.getSource() == this.IDM_MFILE_UNMARK) {
            this.markSelectedRecords(false);
        } else if (e.getSource() == this.IDM_FILE_MARKALL || e.getSource() == this.IDM_MFILE_MARKALL) {
            this.markAllRecords(true);
        } else if (e.getSource() == this.IDM_FILE_UNMARKALL || e.getSource() == this.IDM_MFILE_UNMARKALL) {
            this.markAllRecords(false);
        } else if (e.getSource() == this.IDM_FILE_BREAK) {
            if (this.previewload != null) {
                this.text.setText("Halting message download...");
                this.previewload.setStop(true);
            }
        } else if (e.getSource() == this.IDM_FILE_REFRESH) {
            PreviewStartup startup = new PreviewStartup(this);
            startup.show();
            if (startup.proceed()) {
                this.setMaintain(false);
                if (this.pop3 != null) {
                    this.pop3.Logoff();
                    this.pop3 = null;
                }
                this.load();
            }
        }
    }

    public void actionPerformed(JCActionEvent e) {
        if (this.IDM_FILE_PEEK.isEnabled()) {
            this.peekMessage();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void Close() {
        this.done = true;
        if (this.maintainpop != null) {
            this.setMaintain(false);
            this.maintainpop.setStop(true);
            this.maintainpop = null;
        }
        if (this.pop3 != null) {
            this.pop3.setStop(true);
            this.pop3.Logoff();
            this.pop3 = null;
        }
        this.saveColumnWidths(this.msgList);
        ((Component)this).setVisible(false);
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.parent.toFront();
        this.parent.preview = null;
    }

    private void markSelectedRecords(boolean parm) {
        int[] sel = this.msgList.getSelectedIndexes();
        if (sel != null && sel.length > 0) {
            for (int i = 0; i < sel.length; ++i) {
                this.markRecord(sel[i], parm);
            }
        }
    }

    private void markAllRecords(boolean parm) {
        for (int i = 0; i < this.msgList.countItems(); ++i) {
            this.markRecord(i, parm);
        }
    }

    private void markRecord(int index, boolean parm) {
        Vector item = (Vector)this.msgList.getItem(index);
        String val = null;
        if (parm) {
            val = new String(String.valueOf(String.valueOf("[IMG=").concat(String.valueOf(jstreet.MARK_FILE))).concat(String.valueOf("]")));
            item.setElementAt(JCString.parse(this, val), 0);
        } else {
            item.setElementAt(null, 0);
        }
        this.msgList.paintRow(index);
    }

    public void downloadMessage() {
        if (this.msgList.getSelectedItem() != null) {
            MessageDownloadThread downthread = new MessageDownloadThread(this);
            downthread.start();
        }
    }

    public void downloadTheMessage() {
        int index = this.msgList.getSelectedIndex();
        Vector item = null;
        int msgnum = 0;
        PopFileProcedure pop = null;
        String fname = null;
        File tempfile = null;
        FileDialog fdlg = null;
        item = (Vector)this.msgList.getSelectedItem();
        if (item != null) {
            fdlg = new FileDialog((Frame)this, "Save to file", 1);
            fdlg.show();
            fname = fdlg.getFile();
            if (fname != null) {
                this.setMaintain(false);
                tempfile = new File(fdlg.getDirectory(), fname);
                msgnum = Integer.valueOf((String)item.elementAt(1));
                this.text.setText(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]...")));
                pop = this.pop3.getMessage(msgnum, tempfile, 0, this.text);
                if (pop != null) {
                    if (!this.headers) {
                        this.UpdateRecord(item, index, pop);
                    }
                    this.text.setText(String.valueOf(String.valueOf(String.valueOf("Message [").concat(String.valueOf(msgnum))).concat(String.valueOf("] was "))).concat(String.valueOf("downloaded successfully.")));
                    pop = null;
                } else {
                    this.text.setText(String.valueOf(String.valueOf("Errors occurred downloading message [").concat(String.valueOf(msgnum))).concat(String.valueOf("].")));
                }
                this.setMaintain(true);
            }
        }
    }

    public void formatMessage() {
        if (this.msgList.getSelectedItem() != null) {
            MessageViewThread msgthread = new MessageViewThread(this);
            msgthread.setFormat(true);
            msgthread.start();
        }
    }

    public void viewMessage() {
        if (this.msgList.getSelectedItem() != null) {
            MessageViewThread msgthread = new MessageViewThread(this);
            msgthread.start();
        }
    }

    public void peekMessage() {
        if (this.msgList.getSelectedItem() != null) {
            MessageViewThread msgthread = new MessageViewThread(this, true);
            msgthread.start();
        }
    }

    public void viewTheMessage(boolean peek, boolean format) {
        int index = this.msgList.getSelectedIndex();
        Vector item = null;
        int msgnum = 0;
        PopFileProcedure pop = null;
        File tempfile = new File(new GenPopName(this.parent.getCollectDir().getAbsolutePath()).getName());
        Label text = null;
        ViewWindow view = null;
        ViewFormattedMessage fview = null;
        String title = null;
        item = (Vector)this.msgList.getSelectedItem();
        if (item != null) {
            this.setMaintain(false);
            msgnum = Integer.valueOf((String)item.elementAt(1));
            title = peek ? new String(String.valueOf(String.valueOf("Peek Message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]"))) : (format ? new String(String.valueOf(String.valueOf("Formatted Message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]"))) : new String(String.valueOf(String.valueOf("Unformatted Message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]"))));
            if (!format) {
                view = new ViewWindow(this, this.parent, title);
                text = view.getTextWindow();
            } else {
                fview = new ViewFormattedMessage(this, this.parent, title);
                text = fview.getTextWindow();
            }
            text.setText(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]...")));
            pop = peek ? this.pop3.getMessage(msgnum, tempfile, 4, text) : this.pop3.getMessage(msgnum, tempfile, 0, text);
            if (pop != null) {
                if (!this.headers) {
                    this.UpdateRecord(item, index, pop);
                }
                text.setText(String.valueOf(String.valueOf("Reading message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]...")));
                if (format) {
                    fview.setDelete(true);
                    fview.loadFile(tempfile);
                } else {
                    view.setDelete(true);
                    view.loadFile(tempfile);
                }
                pop = null;
            }
            text.setText("");
            this.setMaintain(true);
        }
    }

    public void UpdateRecord(Vector item, int index, PopFileProcedure pop) {
        item.setElementAt(this.fixSubject(pop.getHeader("subject")), 2);
        item.setElementAt(pop.getHeader("from"), 3);
        item.setElementAt(pop.getHeader("to"), 4);
        item.setElementAt(pop.getHeader("date"), 5);
        item.setElementAt(new String(String.valueOf("").concat(String.valueOf(pop.getBytes()))), 6);
        this.msgList.paintRow(index);
    }

    private String fixSubject(String text) {
        text = new String(text.replace('[', '(').replace(']', ')'));
        return text;
    }

    public void retrieveMessages(boolean mark) {
        block6: {
            Vector item = null;
            Object val = null;
            if (this.previewretr != null) {
                this.previewretr.stop();
            }
            this.retrrecs = new Vector();
            if (mark) {
                for (int i = 0; i < this.msgList.countItems(); ++i) {
                    item = (Vector)this.msgList.getItem(i);
                    val = item.elementAt(0);
                    if (val == null) continue;
                    this.retrrecs.addElement(Integer.valueOf((String)item.elementAt(1)));
                }
            } else {
                int[] selected = this.msgList.getSelectedIndexes();
                if (selected != null && selected.length > 0) {
                    for (int i = 0; i < selected.length; ++i) {
                        item = (Vector)this.msgList.getItem(selected[i]);
                        this.retrrecs.addElement(Integer.valueOf((String)item.elementAt(1)));
                    }
                }
            }
            if (this.retrrecs.size() <= 0) break block6;
            this.previewretr = new PreviewMailRetrieve(this);
            this.previewretr.start();
        }
    }

    public void retrieveTheMessages() {
        int msgnum = 0;
        PopFileProcedure pop = null;
        NewInboxMessage newmsg = null;
        File tempfile = null;
        String retCode = null;
        this.enableMenu(false);
        this.setMaintain(false);
        for (int i = 0; i < this.retrrecs.size(); ++i) {
            msgnum = (Integer)this.retrrecs.elementAt(i);
            this.text.setText(String.valueOf(String.valueOf("Retrieving message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]")));
            tempfile = null;
            pop = null;
            tempfile = new File(new GenPopName(this.parent.getCollectDir().getAbsolutePath()).getName());
            pop = this.pop3.getMessage(msgnum, tempfile, 0, this.text);
            if (pop == null) continue;
            if (tempfile.exists()) {
                FilterExecute runFilters = new FilterExecute(this.parent, tempfile.getParent(), tempfile.getName());
                retCode = runFilters.getReturnCode();
                runFilters = null;
            }
            if (!tempfile.exists()) continue;
            if (newmsg == null) {
                newmsg = new NewInboxMessage(this.parent);
            }
            if (retCode != null && retCode.startsWith("cc")) {
                newmsg.add(tempfile, Integer.valueOf(retCode.substring(2, 3)));
            } else {
                newmsg.add(tempfile);
            }
            tempfile.delete();
        }
        pop = null;
        tempfile = null;
        newmsg = null;
        this.text.setText("Message retrieve process has completed.");
        this.enableMenu(true);
        this.setMaintain(true);
    }

    private void setMaintain(boolean val) {
        if (this.maintainpop != null) {
            this.maintainpop.enable(val);
        }
    }

    private Vector markedRecords() {
        Vector item = null;
        Object val = null;
        Vector<Integer> recs = new Vector<Integer>();
        for (int i = 0; i < this.msgList.countItems(); ++i) {
            item = (Vector)this.msgList.getItem(i);
            val = item.elementAt(0);
            if (val == null) continue;
            recs.addElement(Integer.valueOf((String)item.elementAt(1)));
        }
        return recs;
    }

    public void deleteRecords() {
        if (this.previewdel != null) {
            this.previewdel.stop();
        }
        this.delrecs = this.markedRecords();
        if (this.delrecs.size() > 0) {
            this.previewdel = new PreviewMailDelete(this);
            this.previewdel.start();
        }
    }

    public void deleteNotes() {
        int msgnum = 0;
        this.enableMenu(false);
        this.setMaintain(false);
        for (int i = 0; i < this.delrecs.size(); ++i) {
            msgnum = (Integer)this.delrecs.elementAt(i);
            this.text.setText(String.valueOf(String.valueOf("Deleting message [").concat(String.valueOf(msgnum))).concat(String.valueOf("]")));
            this.pop3.deleteMessage(msgnum);
        }
        this.pop3.Logoff();
        this.pop3 = null;
        this.text.setText("");
        this.Close();
    }

    public void load() {
        if (this.previewload != null) {
            this.previewload.stop();
        }
        if (this.maintainpop != null) {
            this.maintainpop.setStop(true);
            this.maintainpop = null;
        }
        this.previewload = new PreviewMailLoad(this);
        this.previewload.start();
    }

    public void loadNotes(PreviewMailLoad thread) {
        boolean go = true;
        int cnt = 0;
        int start = 0;
        int end = 0;
        Object rec = null;
        String bytes = null;
        PopFileProcedure pop = null;
        this.enableMenu(false);
        this.msgList.clear();
        this.msgs.setText("");
        if (this.pop3 == null || !this.pop3.outReady() && !thread.getStop()) {
            int portval = 0;
            try {
                portval = Integer.valueOf(this.port);
            }
            catch (NumberFormatException e) {
                portval = 110;
            }
            this.pop3 = new Pop3(this.parent, this, this.server, this.userid, this.password, portval);
            go = this.pop3 != null ? this.pop3.Logon(this.text) : false;
        }
        if (!this.done && go && this.pop3 != null && !thread.getStop() && this.pop3.ExecuteStat()) {
            cnt = this.pop3.Notes();
            this.msgs.setText(cnt);
            if (!(thread.getStop() || this.done || this.countonly || cnt <= 0)) {
                switch (this.messages) {
                    case 0: {
                        start = 1;
                        end = cnt;
                        break;
                    }
                    case 3: {
                        start = 1;
                        if (cnt < 10) {
                            end = cnt;
                            break;
                        }
                        end = 10;
                        break;
                    }
                    case 2: {
                        start = 1;
                        if (cnt < 25) {
                            end = cnt;
                            break;
                        }
                        end = 25;
                        break;
                    }
                    case 1: {
                        start = 1;
                        if (cnt < 50) {
                            end = cnt;
                            break;
                        }
                        end = 50;
                        break;
                    }
                    case 4: {
                        start = cnt < 50 ? 1 : cnt - 49;
                        end = cnt;
                        break;
                    }
                    case 5: {
                        start = cnt < 25 ? 1 : cnt - 24;
                        end = cnt;
                        break;
                    }
                    case 6: {
                        start = cnt < 10 ? 1 : cnt - 9;
                        end = cnt;
                        break;
                    }
                }
                if (!this.headers) {
                    this.msgList.setBatched(true);
                }
                File tempfile = new File(this.parent.getSystemDir(), TEMP_FILE);
                for (int i = start; i <= end; ++i) {
                    this.text.setText(String.valueOf(String.valueOf("Working on message [").concat(String.valueOf(i))).concat(String.valueOf("]")));
                    if (!thread.getStop() && !this.done && this.headers) {
                        pop = this.pop3.getMessage(i, tempfile, 3, this.text);
                        if (thread.getStop() || this.done || pop == null) break;
                        this.msgList.setBatched(true);
                        bytes = pop.getBytes() == (long)0 ? new String("<unknown>") : new String(String.valueOf("").concat(String.valueOf(pop.getBytes())));
                        this.msgList.addItem(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("|").concat(String.valueOf(i))).concat(String.valueOf("|"))).concat(String.valueOf(this.fixSubject(pop.getHeader("subject"))))).concat(String.valueOf("|"))).concat(String.valueOf(pop.getHeader("from")))).concat(String.valueOf("|"))).concat(String.valueOf(pop.getHeader("to")))).concat(String.valueOf("|"))).concat(String.valueOf(pop.getHeader("date")))).concat(String.valueOf("|"))).concat(String.valueOf(bytes)), '|');
                        this.msgList.setBatched(false);
                    } else {
                        this.msgList.addItem(String.valueOf(String.valueOf("|").concat(String.valueOf(i))).concat(String.valueOf("| | | | | |")), '|');
                    }
                    if (this.done) break;
                }
                if (!this.headers) {
                    this.msgList.setBatched(false);
                }
                tempfile.delete();
            }
        }
        if (!this.done && this.pop3 != null) {
            this.maintainpop = new MaintainPop(this.pop3);
            this.setMaintain(true);
        }
        this.text.setText("");
        this.enableMenu(true);
    }
}

