/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.Last15;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class ReplyAddress
extends Dialog
implements KeyListener,
ActionListener {
    private Frame frame;
    private Button okButton;
    private Button cancelButton;
    private Button selectallButton;
    private TextField toField;
    private boolean ret_code;
    private List list;

    ReplyAddress(Frame frame, PopFileProcedure pop, TextField toField) {
        super(frame, "Select Address(es) for Reply", true);
        this.frame = frame;
        this.toField = toField;
        this.setupDialog();
        this.loadListBox(pop);
        this.show();
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{200, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 5, 80, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.list = new List();
        this.list.addActionListener(this);
        this.list.setMultipleMode(true);
        this.add(this.list);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 8;
        grid.setConstraints(this.list, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 2;
        grid.setConstraints(this.cancelButton, con);
        this.selectallButton = new Button("Select All");
        this.selectallButton.addActionListener(this);
        this.selectallButton.addKeyListener(this);
        this.add(this.selectallButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        grid.setConstraints(this.selectallButton, con);
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public boolean getReturn() {
        return this.ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton || e.getSource() == this.list) {
            String[] item = this.list.getSelectedItems();
            int spot = 0;
            if (item != null && item.length > 0) {
                String text = "";
                for (int i = 0; i < item.length; ++i) {
                    if (text.length() > 0) {
                        text = new String(String.valueOf(text).concat(String.valueOf(",")));
                    }
                    spot = item[i].lastIndexOf(91);
                    text = new String(String.valueOf(text).concat(String.valueOf(item[i].substring(0, spot - 1))));
                }
                ((TextComponent)this.toField).setText(text);
                this.ret_code = true;
                this.dispose();
            } else {
                MsgBox msgBox = new MsgBox(this.frame, "No addresses have been selected.");
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else if (e.getSource() == this.selectallButton) {
            for (int i = 0; i < this.list.getItemCount(); ++i) {
                this.list.select(i);
            }
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void loadListBox(PopFileProcedure pop) {
        Vector addrVector = null;
        String[] hdr = new String[]{"from", "reply-to", "to", "cc", "bcc", "sender"};
        String text = null;
        for (int i = 0; i < hdr.length; ++i) {
            text = pop.getHeader(hdr[i]);
            addrVector = Last15.parseAddresses(text);
            for (int j = 0; j < addrVector.size(); ++j) {
                this.list.add(String.valueOf(String.valueOf(String.valueOf((String)addrVector.elementAt(j)).concat(String.valueOf(" ["))).concat(String.valueOf(hdr[i]))).concat(String.valueOf("]")));
            }
        }
    }

    public static boolean qualifies(PopFileProcedure pop) {
        boolean ret_code = false;
        if (pop.isHeader("cc") || pop.isHeader("sender")) {
            ret_code = true;
        } else {
            Vector vector = Last15.parseAddresses(pop.getHeader("to"));
            if (vector != null && vector.size() > 1) {
                ret_code = true;
            }
        }
        return ret_code;
    }
}

