/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.AddrTool;
import innoval.mailer.Compose;
import innoval.mailer.Last15;
import innoval.mailer.MsgBox;
import innoval.mailer.NoteList;
import innoval.mailer.OutboxMessage;
import innoval.mailer.Persona;
import innoval.mailer.PopFileProcedure;
import innoval.mailer.RouterRun;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;

public class RouteMessages
extends Dialog
implements KeyListener,
ActionListener {
    static final int SENDNOW = 0;
    static final int SENDLATER = 1;
    private jstreet parent;
    private Frame frame;
    private Panel panel;
    private int sendStyle;
    private AddrTool addrtool;
    private Button addrButton;
    private Button toolButton;
    private Button okButton;
    private Button okLaterButton;
    private Button last15Button;
    private Button cancelButton;
    private boolean ret_code = false;
    private boolean routing = false;
    private NoteList notelist;
    private TextArea toField;
    private TextArea noteField;
    private Label textLabel;
    private Object[] note;

    RouteMessages(Frame frame, jstreet parent, NoteList notelist) {
        super(frame, "Route the Selected Message(s)", false);
        this.frame = frame;
        this.notelist = notelist;
        Persona persona = Persona.getDefaultPersona(frame, parent, parent.getProfile());
        if (persona != null) {
            this.parent = parent;
            this.note = notelist.getSelectedObjects();
            this.setupDialog();
            this.show();
        } else {
            MsgBox msg = new MsgBox(frame, "This feature cannot be used until you have created a default Persona, via the compose window.");
            this.dispose();
        }
    }

    public void setupDialog() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5, 20, 5, 20, 10, 20, 20, 60, 5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 5, 80, 200, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Addressee(s):", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(label, con);
        this.toField = new TextArea(new String(""), 1, 1, 1);
        this.toField.addKeyListener(this);
        this.add(this.toField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        con.gridwidth = 4;
        con.gridheight = 7;
        grid.setConstraints(this.toField, con);
        this.last15Button = new Button("Last 15");
        this.last15Button.addActionListener(this);
        this.last15Button.addKeyListener(this);
        this.add(this.last15Button);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(this.last15Button, con);
        this.toolButton = new Button("Address Tool");
        this.toolButton.addActionListener(this);
        this.toolButton.addKeyListener(this);
        this.add(this.toolButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.toolButton, con);
        this.addrButton = new Button("Address Book");
        this.addrButton.addActionListener(this);
        this.addrButton.addKeyListener(this);
        this.add(this.addrButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 7;
        grid.setConstraints(this.addrButton, con);
        label = new Label("Notes to", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 9;
        grid.setConstraints(label, con);
        label = new Label("Addressee(s):", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 10;
        grid.setConstraints(label, con);
        this.noteField = new TextArea(new String(""), 1, 1, 1);
        this.add(this.noteField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 9;
        con.gridwidth = 4;
        con.gridheight = 3;
        grid.setConstraints(this.noteField, con);
        this.textLabel = new Label("");
        this.add(this.textLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 13;
        con.gridwidth = 6;
        grid.setConstraints(this.textLabel, con);
        this.okLaterButton = new Button("Send Later");
        this.okLaterButton.addActionListener(this);
        this.okLaterButton.addKeyListener(this);
        this.add(this.okLaterButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 15;
        grid.setConstraints(this.okLaterButton, con);
        this.okButton = new Button("Send Now");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 15;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 15;
        grid.setConstraints(this.cancelButton, con);
        this.setLayout(grid);
        this.pack();
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.toField && e.getKeyCode() == 10) {
            Compose.checkAddresses(this.toField, this.frame, this.parent);
        } else if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Last15 last15;
        if (e.getSource() == this.okButton || e.getSource() == this.okLaterButton) {
            this.sendStyle = e.getSource() == this.okLaterButton ? 1 : 0;
            if (this.auditValues()) {
                Last15 last152 = new Last15(this.parent);
                last152.update(this.toField.getText());
                this.routing = true;
                this.enableDialog(false);
                RouterRun route = new RouterRun(this);
                route.start();
            }
        } else if (e.getSource() == this.cancelButton) {
            if (this.routing) {
                MsgBox msg = new MsgBox((Container)this.frame, "Halt the message routing?", 3);
                if (msg.ret_code == 0) {
                    this.routing = false;
                    this.textLabel.setText("Routing HALT request has been issued...");
                }
            } else {
                this.dispose();
            }
        } else if (e.getSource() == this.toolButton) {
            if (this.addrtool != null && this.addrtool.active) {
                this.addrtool.toFront();
            } else {
                this.toField.setEditable(false);
                this.addrtool = new AddrTool(this.frame, this.parent, this.toField);
            }
        } else if (e.getSource() == this.addrButton) {
            AddrBook addr = new AddrBook(this.frame, this.parent, this.parent.addrbook);
            if (addr.getAddressBook() != null) {
                addr.setRemoteEntry(this.toField);
                addr.show();
                this.parent.addrbook = addr.getAddressBook();
            }
        } else if (e.getSource() == this.last15Button && (last15 = new Last15(this.parent)).size() > 0) {
            last15.show(this.toField, this.toField);
        }
    }

    private void enableDialog(boolean val) {
        this.toField.setEnabled(val);
        this.addrButton.setEnabled(val);
        this.noteField.setEnabled(val);
        this.okButton.setEnabled(val);
        this.okLaterButton.setEnabled(val);
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean auditValues() {
        boolean ret_code;
        block1: {
            block0: {
                ret_code = true;
                if (!ret_code || this.toField.getText().length() != 0) break block0;
                MsgBox msgbox = new MsgBox(this.frame, "Please enter the message addressee(s).");
                ret_code = false;
                break block1;
            }
            if (Compose.checkAddresses(this.toField, this.frame, this.parent)) break block1;
            ret_code = false;
        }
        return ret_code;
    }

    public void routeMessages() {
        Persona persona = Persona.getDefaultPersona(this.frame, this.parent, this.parent.getProfile());
        persona.setSignature("");
        for (int i = 0; i < this.note.length; ++i) {
            this.textLabel.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Routing message [").concat(String.valueOf(i + 1))).concat(String.valueOf(" of "))).concat(String.valueOf(this.note.length))).concat(String.valueOf("]...")));
            this.routeMessage((Vector)this.note[i], persona);
            if (!this.routing) break;
        }
        if (this.routing) {
            this.textLabel.setText("Message routing completed.");
        } else {
            this.textLabel.setText("Routing was halted.");
        }
        this.enableDialog(true);
        this.routing = false;
    }

    public void routeMessage(Vector note, Persona persona) {
        OutboxMessage msg = new OutboxMessage(this.parent);
        String fname = (String)note.elementAt(8);
        File file = this.notelist.getMessageFile(fname);
        PopFileProcedure pop = new PopFileProcedure();
        if (file.exists()) {
            pop.readHeaders(file);
            msg.msgtype = 0;
            msg.bounce = false;
            if (this.sendStyle == 0) {
                msg.sendImmediate = true;
            }
            msg.persona = persona;
            msg.draft = false;
            String text = new String(this.noteField.getText());
            if (text.length() > 0) {
                text = new String(String.valueOf(text).concat(String.valueOf("\n\n")));
            }
            text = new String(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(text).concat(String.valueOf("Routing message from: "))).concat(String.valueOf(pop.getHeader("from")))).concat(String.valueOf(" "))).concat(String.valueOf(pop.getHeader("date")))).concat(String.valueOf("\n\n"))).concat(String.valueOf(pop.readBody(file))));
            msg.toaddr = new String(this.toField.getText());
            msg.folder = new String(persona.getFolder());
            msg.subject = new String(pop.getHeader("subject"));
            msg.body = new String(text);
            if (pop.getHeader("mime-version").length() > 0) {
                msg.addHeader(String.valueOf("MIME-Version: ").concat(String.valueOf(pop.getHeader("mime-version"))));
            }
            if (pop.getHeader("content-type").length() > 0) {
                msg.addHeader(String.valueOf("Content-type: ").concat(String.valueOf(pop.getHeader("content-type"))));
            }
            if (pop.getHeader("content-transfer-encoding").length() > 0) {
                msg.addHeader(String.valueOf("Content-transfer-encoding: ").concat(String.valueOf(pop.getHeader("content-transfer-encoding"))));
            }
            msg.wordwrap = false;
            msg.tagline = new String("");
            Compose.createMessage(msg);
        }
    }
}

