/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.PopFileReader;
import innoval.mailer.PopFileWriter;
import innoval.mailer.Profile;
import innoval.mailer.SettingsGeneral;
import innoval.mailer.jstreet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class UIDLHandler {
    static final int MAX = 1000;
    private jstreet Jstreet;
    private File file;
    private Vector vectorLast;
    private Vector vectorNew;

    public UIDLHandler(jstreet Jstreet) {
        this.Jstreet = Jstreet;
        this.file = new File(Jstreet.getAccountDir(), jstreet.UIDL_FILE);
        this.loadIds();
    }

    public UIDLHandler(File accountdir) {
        this.file = new File(accountdir, jstreet.UIDL_FILE);
        this.loadIds();
    }

    public void addId(int num) {
        String text;
        if (num >= 0 && num <= this.vectorNew.size() && !this.findId(text = (String)this.vectorNew.elementAt(num))) {
            this.vectorLast.addElement(text);
        }
    }

    public void addId(String text) {
        if (text != null && !this.findId(text)) {
            this.vectorLast.addElement(text);
        }
    }

    public boolean findId(int num) {
        boolean ret_code = false;
        if (num >= 0 && num <= this.vectorNew.size()) {
            ret_code = this.findId((String)this.vectorNew.elementAt(num));
        }
        return ret_code;
    }

    public boolean findId(String text) {
        int spot;
        boolean ret_code = false;
        if (text != null && (spot = this.vectorLast.indexOf(text)) >= 0) {
            ret_code = true;
        }
        return ret_code;
    }

    private void loadIds() {
        PopFileReader in;
        String text = "";
        if (this.vectorLast == null) {
            this.vectorLast = new Vector();
        } else {
            this.vectorLast.removeAllElements();
        }
        if (this.file.exists() && (in = new PopFileReader()).open(this.file)) {
            while (text != null) {
                text = in.lineIn();
                if (text == null) continue;
                this.vectorLast.addElement(text);
            }
            in.close();
        }
    }

    public void addNew(String text) {
        if (this.vectorNew == null) {
            this.vectorNew = new Vector();
        }
        this.vectorNew.addElement(text);
    }

    public void retrieveIds(BufferedReader in) {
        String text = "";
        boolean quit = false;
        if (this.vectorNew == null) {
            this.vectorNew = new Vector();
        } else {
            this.vectorNew.removeAllElements();
        }
        try {
            while (!quit) {
                text = in.readLine();
                if (text.charAt(0) == '.') {
                    quit = true;
                    continue;
                }
                this.vectorNew.addElement(text.substring(text.indexOf(32) + 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSetting(boolean val) {
        this.setSetting(this.Jstreet.getProfile(), val);
    }

    public void setSetting(Profile profile, boolean val) {
        if (profile != null) {
            profile.WriteString(SettingsGeneral.SAVEGENERAL, SettingsGeneral.UIDLCMD, String.valueOf("").concat(String.valueOf(val)), true);
        }
    }

    public void saveServer() {
        String text = "";
        int start = 0;
        if (this.vectorLast != null && this.vectorNew != null) {
            for (int i = this.vectorLast.size() - 1; i >= 0; --i) {
                if (this.vectorNew.indexOf(this.vectorLast.elementAt(i)) >= 0) continue;
                this.vectorLast.removeElementAt(i);
            }
            PopFileWriter out = new PopFileWriter();
            if (out.open(this.file)) {
                for (int i = start; i < this.vectorLast.size(); ++i) {
                    text = (String)this.vectorLast.elementAt(i);
                    out.lineOut(String.valueOf(text).concat(String.valueOf("\n")));
                }
                out.close();
            }
        }
    }
}

