/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ColorCodeList;
import innoval.mailer.FolderItem;
import innoval.mailer.JBevelPanel;
import innoval.mailer.VfDateDefine;
import innoval.mailer.VirtualFolderList;
import innoval.mailer.VirtualFolderParms;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import jclass.util.JCVector;

public class VirtualFolderFrame
extends Dialog
implements ActionListener,
KeyListener {
    static final String VF_RECD_LAST30 = new String("was received in last 30 days");
    static final String VF_SENT_LAST30 = new String("was sent in last 30 days");
    static final String VF_WITHIN_RANGE = new String("was sent/received within date range...");
    static final String VF_COLOR_CODED = new String("is color-coded...");
    static final String VF_UNOPENED = new String("is unopened");
    static final String VF_HAS_NOTE = new String("has sticky-notes");
    static final String VF_FROM = new String("is from...");
    static final String VF_FROMTO = new String("is from/to...");
    static final String VF_TO = new String("is to...");
    static final String VF_SUBJECT = new String("subject contains...");
    static final String VF_MSGTEXT = new String("body contains...");
    Button okButton = new Button("OK");
    Button cancelButton = new Button("Cancel");
    CheckboxGroup choice = new CheckboxGroup();
    Checkbox c1 = new Checkbox(VF_RECD_LAST30, this.choice, false);
    Checkbox c2 = new Checkbox(VF_SENT_LAST30, this.choice, false);
    Checkbox c3 = new Checkbox(VF_WITHIN_RANGE, this.choice, false);
    Checkbox c4 = new Checkbox(VF_COLOR_CODED, this.choice, false);
    Checkbox c5 = new Checkbox(VF_UNOPENED, this.choice, false);
    Checkbox c6 = new Checkbox(VF_HAS_NOTE, this.choice, false);
    Checkbox c7 = new Checkbox(VF_FROM, this.choice, false);
    Checkbox c8 = new Checkbox(VF_TO, this.choice, false);
    Checkbox c9 = new Checkbox(VF_SUBJECT, this.choice, false);
    Checkbox c10 = new Checkbox(VF_MSGTEXT, this.choice, false);
    Label label1 = new Label();
    List folderListBox = new List();
    Button folderListSelectAll = new Button("Select All");
    Button folderListDeselectAll = new Button("Deselect All");
    Vector folderItemVector = new Vector();
    jstreet parent;

    public VirtualFolderFrame(jstreet parent) {
        super(parent, "Virtual Folder Specification", true);
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 5, 5, 20, 5, 55, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 20, 150, 90, 2, 90, 10, 70, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.add(this.label1);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.label1, con);
        this.add(this.c1);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.c1, con);
        this.add(this.c2);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(this.c2, con);
        this.add(this.c3);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 4;
        con.gridwidth = 4;
        grid.setConstraints(this.c3, con);
        this.add(this.c4);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 5;
        con.gridwidth = 4;
        grid.setConstraints(this.c4, con);
        this.add(this.c5);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 6;
        con.gridwidth = 4;
        grid.setConstraints(this.c5, con);
        this.add(this.c6);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 7;
        con.gridwidth = 4;
        grid.setConstraints(this.c6, con);
        this.add(this.c7);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 8;
        con.gridwidth = 4;
        grid.setConstraints(this.c7, con);
        this.add(this.c8);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 9;
        con.gridwidth = 4;
        grid.setConstraints(this.c8, con);
        this.add(this.c9);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 10;
        con.gridwidth = 4;
        grid.setConstraints(this.c9, con);
        this.add(this.c10);
        jstreet.reset(con);
        con.gridx = 2;
        con.gridy = 11;
        con.gridwidth = 4;
        grid.setConstraints(this.c10, con);
        this.c1.setState(true);
        JBevelPanel rect = new JBevelPanel();
        rect.setBevelInner(2);
        rect.setBevelOuter(2);
        rect.setPreferredSize(60, 60);
        this.add(rect);
        jstreet.reset(con);
        con.gridx = 0;
        con.gridy = 0;
        con.gridwidth = 8;
        con.gridheight = 13;
        grid.setConstraints(rect, con);
        Label folderLabel = new Label("Folders to Search:");
        this.add(folderLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 14;
        con.gridwidth = 2;
        grid.setConstraints(folderLabel, con);
        this.add(this.folderListSelectAll);
        this.folderListSelectAll.addActionListener(this);
        this.folderListSelectAll.addKeyListener(this);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 14;
        grid.setConstraints(this.folderListSelectAll, con);
        this.add(this.folderListDeselectAll);
        this.folderListDeselectAll.addActionListener(this);
        this.folderListDeselectAll.addKeyListener(this);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 14;
        grid.setConstraints(this.folderListDeselectAll, con);
        this.folderListBox.setMultipleMode(true);
        this.loadFolderList(this.folderListBox);
        this.add(this.folderListBox);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 16;
        con.gridwidth = 5;
        con.gridheight = 4;
        grid.setConstraints(this.folderListBox, con);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 17;
        grid.setConstraints(this.okButton, con);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 19;
        grid.setConstraints(this.cancelButton, con);
        this.label1.setText("Include messages with the following attribute:");
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, this.parent);
        this.folderListBox.makeVisible(0);
        this.enableEvents(64L);
    }

    private void loadFolderList(List folderListBox) {
        JCVector children = this.parent.folderlist.getRootNode().getChildren();
        FolderItem item = null;
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                item = (FolderItem)children.elementAt(i);
                this.loadFolderItem(item, folderListBox, null);
            }
        }
    }

    private void loadFolderItem(FolderItem item, List folderListBox, String folderParent) {
        JCVector children;
        String folderName;
        int i = 0;
        this.folderItemVector.addElement(item);
        if (item.isRemote()) {
            String dir = item.getPath().getAbsolutePath();
            if (dir.lastIndexOf(item.getName()) >= 0) {
                dir = dir.substring(0, dir.lastIndexOf(item.getName()));
            }
            folderName = String.valueOf(String.valueOf(String.valueOf(item.getName()).concat(String.valueOf(" ("))).concat(String.valueOf(dir))).concat(String.valueOf(")"));
        } else {
            folderName = item.getName();
        }
        if (folderParent != null) {
            folderName = new String(String.valueOf(String.valueOf(folderParent).concat(String.valueOf(File.separator))).concat(String.valueOf(folderName)));
        }
        folderListBox.add(folderName);
        if (!item.isTrash()) {
            if (!folderName.equals(jstreet.PRINTQUEUE)) {
                folderListBox.select(folderListBox.getItemCount() - 1);
            }
        }
        if ((children = item.getChildren()) != null && children.size() > 0) {
            for (i = 0; i < children.size(); ++i) {
                FolderItem childItem = (FolderItem)children.elementAt(i);
                this.loadFolderItem(childItem, folderListBox, folderName);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String[] parmList = null;
        if (e.getSource() == this.folderListSelectAll) {
            for (int i = 0; i < this.folderListBox.getItemCount(); ++i) {
                this.folderListBox.select(i);
            }
        } else if (e.getSource() == this.folderListDeselectAll) {
            for (int i = 0; i < this.folderListBox.getItemCount(); ++i) {
                this.folderListBox.deselect(i);
            }
        } else if (e.getSource() == this.okButton) {
            String selected = this.choice.getSelectedCheckbox().getLabel();
            if (selected.equals(VF_FROM) || selected.equals(VF_TO) || selected.equals(VF_SUBJECT) || selected.equals(VF_MSGTEXT)) {
                VirtualFolderParms vfParms = new VirtualFolderParms(this.parent, String.valueOf("If message ").concat(String.valueOf(selected)), true);
                vfParms.show();
                parmList = vfParms.getParmList();
                if (parmList != null) {
                    this.buildFolder(selected, parmList);
                }
            } else if (selected.equals(VF_WITHIN_RANGE)) {
                VfDateDefine cal = new VfDateDefine(this.parent, "Virtual Folder Date Range Selection Window");
                parmList = cal.getParmList();
                if (parmList != null) {
                    this.buildFolder(selected, parmList);
                }
            } else if (selected.equals(VF_COLOR_CODED)) {
                ColorCodeList code = new ColorCodeList((Frame)this.parent, this.parent, "All");
                if (code.getReturn()) {
                    parmList = new String[]{String.valueOf(code.getSelectedCode())};
                    this.buildFolder(selected, parmList);
                }
            } else {
                this.buildFolder(selected, parmList);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public void buildFolder(String selected, String[] parmList) {
        this.dispose();
        String[] selectedFolders = this.getSelectedFolders();
        VirtualFolderList list = new VirtualFolderList(this.parent, selected, parmList, selectedFolders);
        list.load();
        this.parent.addVFolder(list);
    }

    private String[] getSelectedFolders() {
        int[] selectedItems = this.folderListBox.getSelectedIndexes();
        String[] selectedFolders = new String[selectedItems.length];
        for (int i = 0; i < selectedItems.length; ++i) {
            selectedFolders[i] = ((FolderItem)this.folderItemVector.elementAt(selectedItems[i])).getPath().getAbsolutePath();
        }
        return selectedFolders;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = 0;
        keyCode = e.getKeyCode();
        if (keyCode == 10) {
            ActionEvent AE = new ActionEvent(e.getSource(), 1001, "OK");
            this.actionPerformed(AE);
        }
    }

    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        } else {
            super.processWindowEvent(e);
        }
    }
}

