/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client.opers;

import java.io.IOException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;

public class JDAPExtendedResponse
extends JDAPResult
implements JDAPProtocolOp {
    protected String m_oid;
    protected byte[] m_value;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDAPExtendedResponse(BERElement bERElement) throws IOException {
        super(((BERTag)bERElement).getValue());
        BERSequence bERSequence = (BERSequence)((BERTag)bERElement).getValue();
        int n = 0;
        while (n < bERSequence.size()) {
            BERElement bERElement2 = bERSequence.elementAt(n);
            if (bERElement2.getType() == -1) {
                BERTag bERTag = (BERTag)bERElement2;
                switch (bERTag.getTag() & 0xF) {
                    case 10: {
                        BEROctetString bEROctetString = (BEROctetString)bERTag.getValue();
                        try {
                            this.m_oid = new String(bEROctetString.getValue(), "UTF8");
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 11: {
                        BEROctetString bEROctetString = (BEROctetString)bERTag.getValue();
                        this.m_value = bEROctetString.getValue();
                        break;
                    }
                }
            }
            {
                catch (ClassCastException classCastException) {}
                break;
            }
            ++n;
        }
    }

    public int getType() {
        return 24;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    public String getID() {
        return this.m_oid;
    }

    public String toString() {
        return "ExtendedResponse " + super.getParamString();
    }
}

