
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * This program converts a Post Road Mailer folder to
 * Netscape Communicator format.
 *
 * Attachments, unless they remain in the original message,
 * are not converted.
 *
 * There is some special processing due to the way Mozilla handles
 * incoming mail.  If a line starts with "From " then it must be
 * changed to ">From ".
 *
 * This code also strips blank lines from the end of any mail messages.
 *
 * @author Aaron Williams
 * @version 1.01
 */

public class Convert {

  public static void main(String args[]) {
    File file = new File(args[0]);
    File inFile;
    String fileList[] = file.list();
    String line;
    int blankcount=0;
    boolean verbose = false;
    for (int i=1; i<args.length; i++) {
      if (args[i].equals("-v"))
	verbose = true;
    }
    SimpleDateFormat gmtDateFormat = 
      new SimpleDateFormat("d MMM yyyy HH:mm:ss", Locale.US);

    gmtDateFormat.setTimeZone(TimeZone.getDefault());
    FileInputStream in;
    BufferedReader reader;
    String name;

    try {
      for (int i=0; i<fileList.length; i++) {
	name = fileList[i];
	if (!name.toLowerCase().endsWith(".pop")) {
	  if (verbose) 
	    System.err.println("Skipping "+name);
	} else {
	  System.err.print("Converting "+name+" ("+i+" out of "+fileList.length+" files)\t\r");
	  inFile = new File(file, name);
	  System.out.println("From - "+gmtDateFormat.format(new Date(inFile.lastModified())));
	  System.out.println("X-Mozilla-Status: 0000");
	  
	  in = new FileInputStream(inFile);
	  reader = new BufferedReader(new InputStreamReader(in));
	  line = reader.readLine();
	  while (line != null && line.length() > 0) {
	    System.out.println(line);
	    if (verbose) {
	      if (line.startsWith("Subject:"))
		System.err.println(line);
	      if (line.startsWith("From:"))
		System.err.println(line);
	    }
	    line = reader.readLine();
	  }

	  while (line != null) {
	    if (line.length() > 0) {
	      if (blankcount > 0) {
		for (int j=0; j<blankcount; j++)
		  System.out.println();
		blankcount = 0;
	      }
	      if (line.startsWith("From "))
		line = ">"+line;
	      System.out.println(line);
	    } else {
	      blankcount++;
	    }
	    line = reader.readLine();
	  }
	  // There must be two blank lines at the end of the message
	  System.out.println();
	  in.close();
	}
      }
    } catch (Exception ex) {
      ex.printStackTrace();
    }
  }
}
