/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.ListModel;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.IconSelectionPopupDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.icon.IIconInformation;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.mindmapmode.IconAction;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

public class IconSelectionPlugin
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public IconSelectionPlugin() {
        super("IconSelectionPlugin");
    }

    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        ArrayList<IIconInformation> actions = new ArrayList<IIconInformation>();
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        IconRegistry iconRegistry = map.getIconRegistry();
        ListModel usedIcons = iconRegistry.getIconsAsListModel();
        for (int i = 0; i < usedIcons.getSize(); ++i) {
            Object icon = usedIcons.getElementAt(i);
            if (!(icon instanceof MindIcon)) continue;
            actions.add(new IconAction((MindIcon)icon));
        }
        MIconController mIconController = (MIconController)IconController.getController();
        for (AFreeplaneAction aFreeplaneAction : mIconController.getIconActions()) {
            actions.add((IIconInformation)aFreeplaneAction);
        }
        actions.add((IIconInformation)modeController.getAction("RemoveIcon_0_Action"));
        actions.add((IIconInformation)modeController.getAction("RemoveIconAction"));
        actions.add((IIconInformation)modeController.getAction("RemoveAllIconsAction"));
        IconSelectionPopupDialog selectionDialog = new IconSelectionPopupDialog(UITools.getCurrentFrame(), actions);
        NodeModel selected = controller.getSelection().getSelected();
        controller.getMapViewManager().scrollNodeToVisible(selected);
        selectionDialog.pack();
        UITools.setDialogLocationRelativeTo((JDialog)selectionDialog, (NodeModel)selected);
        selectionDialog.setModal(true);
        selectionDialog.show();
        int result = selectionDialog.getResult();
        if (result >= 0) {
            Action action = (Action)actions.get(result);
            action.actionPerformed(new ActionEvent(action, 0, "icon", selectionDialog.getModifiers()));
        }
    }
}

