/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.IMapViewManager;

public class ChangeNodeLevelController {
    public ChangeNodeLevelController(MModeController modeController) {
        modeController.addAction(new ChangeNodeLevelLeftsAction());
        modeController.addAction(new ChangeNodeLevelRightsAction());
    }

    private boolean checkSelection() {
        ModeController currentModeController = Controller.getCurrentModeController();
        MapController mapController = currentModeController.getMapController();
        NodeModel selectedNode = mapController.getSelectedNode();
        NodeModel selectedParent = selectedNode.getParentNode();
        if (selectedParent == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_to_root"));
            return false;
        }
        Collection selectedNodes = mapController.getSelectedNodes();
        for (NodeModel node : selectedNodes) {
            if (node.getParentNode() == selectedParent) continue;
            UITools.errorMessage((Object)TextUtils.getText((String)"cannot_add_parent_diff_parents"));
            return false;
        }
        return true;
    }

    private void moveDownwards(NodeModel selectedNode) {
        NodeModel targetCandidate;
        int i;
        if (!this.checkSelection()) {
            return;
        }
        NodeModel selectedParent = selectedNode.getParentNode();
        List selectedNodes = Controller.getCurrentController().getSelection().getSortedSelection(true);
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        int ownPosition = selectedParent.getIndex(selectedNode);
        NodeModel directSibling = null;
        for (i = ownPosition - 1; i >= 0; --i) {
            targetCandidate = selectedParent.getChildAt(i);
            if (!this.canMoveTo(selectedNode, selectedNodes, targetCandidate)) continue;
            directSibling = targetCandidate;
            break;
        }
        if (directSibling == null) {
            for (i = ownPosition + 1; i < selectedParent.getChildCount(); ++i) {
                targetCandidate = selectedParent.getChildAt(i);
                if (!this.canMoveTo(selectedNode, selectedNodes, targetCandidate)) continue;
                directSibling = targetCandidate;
                break;
            }
        }
        if (directSibling != null) {
            for (NodeModel node : selectedNodes) {
                ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
            }
            mapController.moveNodes(selectedNodes, directSibling, directSibling.getChildCount());
            Controller.getCurrentModeController().getMapController().selectMultipleNodes(selectedNode, (Collection)selectedNodes);
        }
    }

    private boolean canMoveTo(NodeModel selectedNode, List<NodeModel> selectedNodes, NodeModel targetCandidate) {
        return !selectedNodes.contains(targetCandidate) && selectedNode.isLeft() == targetCandidate.isLeft() && (targetCandidate.hasChildren() || !targetCandidate.isHiddenSummary());
    }

    private void moveUpwards(NodeModel selectedNode) {
        int position;
        boolean changeSide;
        if (!this.checkSelection()) {
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        NodeModel selectedParent = selectedNode.getParentNode();
        List selectedNodes = Controller.getCurrentController().getSelection().getSortedSelection(true);
        boolean leftSide = selectedNode.isLeft();
        if (selectedParent.isRoot()) {
            Component mapViewComponent;
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            if (!mapViewManager.isLeftTreeSupported(mapViewComponent = mapViewManager.getMapViewComponent())) {
                return;
            }
            changeSide = true;
            leftSide = !leftSide;
            position = selectedParent.getChildCount();
        } else {
            NodeModel grandParent = selectedParent.getParentNode();
            NodeModel childNode = selectedParent;
            position = grandParent.getIndex(childNode) + 1;
            selectedParent = grandParent;
            changeSide = false;
        }
        for (NodeModel node : selectedNodes) {
            ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
        }
        mapController.moveNodes(selectedNodes, selectedParent, position, leftSide, changeSide);
        mapController.selectMultipleNodes(selectedNode, selectedNodes);
    }

    private class ChangeNodeLevelRightsAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        public ChangeNodeLevelRightsAction() {
            super("ChangeNodeLevelRightsAction");
        }

        public void actionPerformed(ActionEvent e) {
            Component mapViewComponent;
            ModeController modeController = Controller.getCurrentModeController();
            NodeModel selectedNode = modeController.getMapController().getSelectedNode();
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            if (mapViewManager.isLeftTreeSupported(mapViewComponent = mapViewManager.getMapViewComponent()) && selectedNode.isLeft()) {
                ChangeNodeLevelController.this.moveUpwards(selectedNode);
            } else {
                ChangeNodeLevelController.this.moveDownwards(selectedNode);
            }
        }
    }

    private class ChangeNodeLevelLeftsAction
    extends AFreeplaneAction {
        private static final long serialVersionUID = 1L;

        public ChangeNodeLevelLeftsAction() {
            super("ChangeNodeLevelLeftsAction");
        }

        public void actionPerformed(ActionEvent e) {
            Component mapViewComponent;
            ModeController modeController = Controller.getCurrentModeController();
            NodeModel selectedNode = modeController.getMapController().getSelectedNode();
            IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
            if (mapViewManager.isLeftTreeSupported(mapViewComponent = mapViewManager.getMapViewComponent()) && selectedNode.isLeft()) {
                ChangeNodeLevelController.this.moveDownwards(selectedNode);
            } else {
                ChangeNodeLevelController.this.moveUpwards(selectedNode);
            }
        }
    }
}

