/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.LengthUnits;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.Quantity;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FirstGroupNode;
import org.freeplane.features.map.FirstGroupNodeFlag;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.SummaryNodeFlag;
import org.freeplane.features.map.mindmapmode.ConvertCloneToIndependentNodeAction;
import org.freeplane.features.map.mindmapmode.DeleteAction;
import org.freeplane.features.map.mindmapmode.DocuMapAttribute;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.map.mindmapmode.NewChildAction;
import org.freeplane.features.map.mindmapmode.NewFreeNodeAction;
import org.freeplane.features.map.mindmapmode.NewMapViewAction;
import org.freeplane.features.map.mindmapmode.NewPreviousSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSummaryAction;
import org.freeplane.features.map.mindmapmode.NodeDownAction;
import org.freeplane.features.map.mindmapmode.NodeUpAction;
import org.freeplane.features.map.mindmapmode.SummaryGroupEdgeListAdder;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.NodeAndMapReference;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.XMLException;

public class MMapController
extends MapController {
    public static final int NEW_CHILD = 2;
    public static final int NEW_SIBLING_BEFORE = 4;
    public static final int NEW_SIBLING_BEHIND = 3;
    public static final String RESOURCES_CONVERT_TO_CURRENT_VERSION = "convert_to_current_version";
    private static final List<String> foldingSavedOptions = Arrays.asList("always_save_folding", "save_folding_if_map_is_changed");

    public MMapController(ModeController modeController) {
        super(modeController);
        this.createActions(modeController);
        this.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                if (ResourceController.getResourceController().getBooleanProperty("display_node_id")) {
                    viewController.addStatusInfo("display_node_id", "ID=" + node.createID(), null);
                }
            }

            public void onDeselect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                viewController.addStatusInfo("display_node_id", null, null);
            }
        });
        this.addMapChangeListener(new IMapChangeListener(){

            public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
            }

            public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            }

            public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
                if (!nodeMoveEvent.oldParent.equals(nodeMoveEvent.newParent)) {
                    this.onNodeDeleted(nodeMoveEvent.oldParent);
                }
            }

            public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            }

            public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
                NodeModel parent = nodeDeletionEvent.parent;
                this.onNodeDeleted(parent);
            }

            private void onNodeDeleted(NodeModel node) {
                if (!MMapController.this.getModeController().isUndoAction() && !node.isFolded() && !node.hasChildren() && SummaryNode.isSummaryNode((NodeModel)node) && node.getText().isEmpty()) {
                    MMapController.this.deleteSingleSummaryNode(node);
                }
            }

            public void mapChanged(MapChangeEvent event) {
            }
        });
    }

    public NodeModel addNewNode(int newNodeMode) {
        NodeModel newNode;
        this.stopEditing();
        NodeModel targetNode = this.getSelectedNode();
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (!targetNode.isRoot()) {
                    NodeModel parent = targetNode.getParentNode();
                    int childPosition = parent.getIndex(targetNode);
                    if (newNodeMode == 3) {
                        ++childPosition;
                    }
                    if ((newNode = this.addNewNode(parent, childPosition, targetNode.isLeft())) == null) {
                        return null;
                    }
                    if (ResourceController.getResourceController().getBooleanProperty("copyFormatToNewSibling")) {
                        this.getMModeController().undoableCopyExtensions(LogicalStyleKeys.NODE_STYLE, targetNode, newNode);
                        this.getMModeController().undoableCopyExtensions(LogicalStyleKeys.LOGICAL_STYLE, targetNode, newNode);
                        if (ResourceController.getResourceController().getBooleanProperty("copyFormatToNewSiblingIncludesIcons")) {
                            this.getMModeController().undoableCopyExtensions((Object)MIconController.Keys.ICONS, targetNode, newNode);
                        }
                    }
                    this.startEditingAfterSelect(newNode);
                    this.select(newNode);
                    break;
                }
                newNodeMode = 2;
            }
            case 2: {
                int position;
                boolean parentFolded = this.isFolded(targetNode);
                if (parentFolded) {
                    this.setFolded(targetNode, false);
                }
                if ((newNode = this.addNewNode(targetNode, position = ResourceController.getResourceController().getProperty("placenewbranches").equals("last") ? targetNode.getChildCount() : 0, targetNode.isNewChildLeft())) == null) {
                    return null;
                }
                this.startEditingAfterSelect(newNode);
                this.select(newNode);
                break;
            }
            default: {
                newNode = null;
            }
        }
        return newNode;
    }

    private void startEditingAfterSelect(final NodeModel newNode) {
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return;
        }
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                TextController textController = TextController.getController();
                ((MTextController)textController).edit(newNode, newNode.getParentNode(), true, false, false);
            }
        });
    }

    private void stopEditing() {
        TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopEditing();
        }
    }

    public void addNewSummaryNodeStartEditing(NodeModel parentNode, int start, int end, int summaryLevel, boolean isLeft) {
        MModeController modeController = this.getMModeController();
        this.stopEditing();
        NodeModel newSummaryNode = this.addNewNode(parentNode, end + 1, isLeft);
        SummaryNode summary = (SummaryNode)modeController.getExtension(SummaryNode.class);
        summary.undoableActivateHook(newSummaryNode, (IExtension)SummaryNodeFlag.SUMMARY);
        AlwaysUnfoldedNode unfolded = (AlwaysUnfoldedNode)modeController.getExtension(AlwaysUnfoldedNode.class);
        unfolded.undoableActivateHook(newSummaryNode, (IExtension)unfolded);
        FirstGroupNode firstGroupNodeHook = (FirstGroupNode)modeController.getExtension(FirstGroupNode.class);
        NodeModel firstNodeInGroup = parentNode.getChildAt(start);
        if (SummaryNode.isSummaryNode((NodeModel)firstNodeInGroup)) {
            firstGroupNodeHook.undoableActivateHook(firstNodeInGroup, (IExtension)FirstGroupNodeFlag.FIRST_GROUP);
        } else {
            NodeModel previousNode = firstNodeInGroup.previousNode(start, isLeft);
            if (previousNode == null || SummaryNode.isSummaryNode((NodeModel)previousNode) || !SummaryNode.isFirstGroupNode((NodeModel)previousNode)) {
                NodeModel newFirstGroup = this.addNewNode(parentNode, start, isLeft);
                firstGroupNodeHook.undoableActivateHook(newFirstGroup, (IExtension)FirstGroupNodeFlag.FIRST_GROUP);
            }
            firstGroupNodeHook.undoableDeactivateHook(firstNodeInGroup);
        }
        int level = summaryLevel;
        for (int i = start + 1; i <= end; ++i) {
            NodeModel node = parentNode.getChildAt(i);
            if (isLeft != node.isLeft()) continue;
            level = SummaryNode.isSummaryNode((NodeModel)node) ? ++level : 0;
            if (level != summaryLevel || !SummaryNode.isFirstGroupNode((NodeModel)node)) continue;
            if (level > 0) {
                firstGroupNodeHook.undoableDeactivateHook(node);
                continue;
            }
            this.deleteSingleNodeWithClones(node);
        }
        NodeModel firstSummaryChildNode = this.addNewNode(newSummaryNode, 0, isLeft);
        this.startEditingAfterSelect(firstSummaryChildNode);
        this.select(firstSummaryChildNode);
    }

    public NodeModel addNewNode(NodeModel parent, int index, boolean newNodeIsLeft) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return null;
        }
        NodeModel newNode = this.newNode("", parent.getMap());
        if (this.addNewNode(newNode, parent, index, newNodeIsLeft)) {
            return newNode;
        }
        return null;
    }

    public boolean addNewNode(NodeModel newNode, NodeModel parent, int index, boolean newNodeIsLeft) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return false;
        }
        this.insertNewNode(newNode, parent, index, newNodeIsLeft);
        return true;
    }

    private void insertNewNode(NodeModel newNode, NodeModel parent, int index, boolean newNodeIsLeft) {
        if (index < 0 || index > parent.getChildCount()) {
            this.insertNewNode(newNode, parent, parent.getChildCount(), newNodeIsLeft);
            return;
        }
        if (newNode.subtreeContainsCloneOf(parent)) {
            UITools.errorMessage((Object)"not allowed");
            return;
        }
        this.stopEditing();
        this.insertSingleNewNode(newNode, parent, index, newNodeIsLeft);
        for (NodeModel parentClone : parent.subtreeClones()) {
            if (parentClone == parent) continue;
            NodeModel childClone = newNode.cloneTree();
            this.insertSingleNewNode(childClone, parentClone, index, parentClone.isLeft());
        }
    }

    private void insertSingleNewNode(final NodeModel newNode, final NodeModel parent, final int index, boolean newNodeIsLeft) {
        MapModel map = parent.getMap();
        newNode.setLeft(newNodeIsLeft);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.insertNodeIntoWithoutUndo(newNode, parent, index);
            }

            public String getDescription() {
                return "addNewNode";
            }

            public void undo() {
                MMapController.this.deleteWithoutUndo(parent, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public boolean close(MapModel map) {
        if (!map.isSaved()) {
            boolean savingNotCancelled;
            String text = TextUtils.getText((String)"save_unsaved") + "\n" + map.getTitle();
            String title = TextUtils.getText((String)"SaveAction.text");
            Frame viewFrame = UITools.getCurrentFrame();
            Component dialogParent = viewFrame != null && viewFrame.isShowing() && viewFrame.getExtendedState() != 1 ? viewFrame : UITools.getCurrentRootComponent();
            int returnVal = JOptionPane.showOptionDialog(dialogParent, text, title, 1, 3, null, null, null);
            if (returnVal == 0 ? !(savingNotCancelled = ((MFileManager)UrlManager.getController()).save(map)) : returnVal == 2 || returnVal == -1) {
                return false;
            }
        }
        this.closeWithoutSaving(map);
        return true;
    }

    public void closeWithoutSaving(MapModel map) {
        super.closeWithoutSaving(map);
    }

    private void createActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new NewMapViewAction());
        modeController.addAction((AFreeplaneAction)new NewSiblingAction());
        modeController.addAction((AFreeplaneAction)new NewPreviousSiblingAction());
        modeController.addAction((AFreeplaneAction)new NewChildAction());
        modeController.addAction((AFreeplaneAction)new NewSummaryAction());
        modeController.addAction((AFreeplaneAction)new NewFreeNodeAction());
        modeController.addAction((AFreeplaneAction)new DeleteAction());
        modeController.addAction((AFreeplaneAction)new NodeUpAction());
        modeController.addAction((AFreeplaneAction)new NodeDownAction());
        modeController.addAction((AFreeplaneAction)new ConvertCloneToIndependentNodeAction());
    }

    public void deleteNode(NodeModel node) {
        this.deleteNodes(Arrays.asList(node));
    }

    public void deleteNodes(List<NodeModel> nodes) {
        List<NodeModel> deletedNodesWithSummaryGroupIndicators = new SummaryGroupEdgeListAdder(nodes).addSummaryEdgeNodes();
        for (NodeModel node : deletedNodesWithSummaryGroupIndicators) {
            this.deleteSingleNodeWithClones(node);
        }
    }

    public void convertClonesToIndependentNodes(NodeModel node) {
        MLinkController linkController = (MLinkController)MLinkController.getController();
        if (node.isCloneTreeRoot()) {
            linkController.deleteMapLinksForClone(node);
            this.convertCloneToNode(node);
            linkController.insertMapLinksForClone(node);
        }
    }

    private void convertCloneToNode(final NodeModel node) {
        MModeController mModeController = this.getMModeController();
        ClipboardController clipboardController = (ClipboardController)mModeController.getExtension(ClipboardController.class);
        final NodeModel duplicate = clipboardController.duplicate(node, false);
        IActor converter = new IActor(){

            public void act() {
                node.swapData(duplicate);
                MMapController.this.nodeChanged(node);
            }

            public void undo() {
                node.swapData(duplicate);
                MMapController.this.nodeChanged(node);
            }

            public String getDescription() {
                return "convertClonesToIndependentNodes";
            }
        };
        boolean shouldConvertChildNodes = node.subtreeClones().size() > 1;
        mModeController.execute(converter, node.getMap());
        if (shouldConvertChildNodes) {
            for (NodeModel child : node.getChildren()) {
                this.convertCloneToNode(child);
            }
        }
    }

    private void deleteSingleNodeWithClones(NodeModel node) {
        NodeModel parentNode = node.getParentNode();
        int index = parentNode.getIndex(node);
        for (NodeModel parentClone : parentNode.subtreeClones()) {
            this.deleteSingleNode(parentClone, index);
        }
    }

    private void deleteSingleSummaryNode(NodeModel summarynode) {
        NodeModel summaryParent = summarynode.getParentNode();
        SummaryLevels summaryLevels = new SummaryLevels(summaryParent);
        int summaryNodeIndex = summarynode.getIndex();
        int groupBeginNodeIndex = summaryLevels.findGroupBeginNodeIndex(summaryNodeIndex - 1);
        this.deleteSingleNode(summaryParent, summaryNodeIndex);
        this.deleteSingleNode(summaryParent, groupBeginNodeIndex);
    }

    private void deleteSingleNode(final NodeModel parentNode, final int index) {
        final NodeModel node = parentNode.getChildAt(index);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.deleteWithoutUndo(parentNode, index);
            }

            public String getDescription() {
                return "delete";
            }

            public void undo() {
                Controller.getCurrentModeController().getMapController().insertNodeIntoWithoutUndo(node, parentNode, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, parentNode.getMap());
    }

    private void deleteWithoutUndo(NodeModel parent, int index) {
        NodeModel child = parent.getChildAt(index);
        NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(parent, child, index);
        this.firePreNodeDelete(nodeDeletionEvent);
        MapModel map = parent.getMap();
        this.setSaved(map, false);
        parent.remove(index);
        this.fireNodeDeleted(nodeDeletionEvent);
    }

    public MModeController getMModeController() {
        return (MModeController)Controller.getCurrentModeController();
    }

    public void insertNode(NodeModel node, NodeModel parent) {
        this.insertNode(node, parent, parent.getChildCount());
    }

    public void insertNode(NodeModel node, NodeModel target, boolean asSibling, boolean isLeft, boolean changeSide) {
        NodeModel parent = asSibling ? target.getParentNode() : target;
        if (changeSide) {
            node.setParent(parent);
            node.setLeft(isLeft);
        }
        if (asSibling) {
            this.insertNode(node, parent, parent.getIndex(target));
        } else {
            this.insertNode(node, parent, parent.getChildCount());
        }
    }

    public void insertNode(NodeModel node, NodeModel parentNode, int index) {
        this.insertNewNode(node, parentNode, index, node.isLeft());
    }

    public void insertNodeIntoWithoutUndo(NodeModel newNode, NodeModel parent, int index) {
        this.setSaved(parent.getMap(), false);
        super.insertNodeIntoWithoutUndo(newNode, parent, index);
    }

    public boolean isWriteable(NodeModel targetNode) {
        EncryptionModel encryptionModel = EncryptionModel.getModel((NodeModel)targetNode);
        if (encryptionModel != null) {
            return encryptionModel.isAccessible();
        }
        return true;
    }

    public void moveNode(NodeModel node, int newIndex) {
        this.moveNodes(Arrays.asList(node), node.getParentNode(), newIndex);
    }

    public void moveNodes(List<NodeModel> children, NodeModel newParent, int newIndex) {
        this.moveNodes(children, newParent, newIndex, false, false);
    }

    public void moveNodes(List<NodeModel> movedNodes, NodeModel newParent, int newIndex, boolean isLeft, boolean changeSide) {
        List<NodeModel> movedNodesWithSummaryGroupIndicators = new SummaryGroupEdgeListAdder(movedNodes).addSummaryEdgeNodes();
        int index = newIndex;
        for (NodeModel node : movedNodesWithSummaryGroupIndicators) {
            this.moveNodeAndItsClones(node, newParent, index++, isLeft, changeSide && node.isLeft() != isLeft);
        }
    }

    public void moveNodeAndItsClones(NodeModel child, NodeModel newParent, int newIndex, boolean isLeft, boolean changeSide) {
        if (child.subtreeContainsCloneOf(newParent)) {
            UITools.errorMessage((Object)"not allowed");
            return;
        }
        NodeModel oldParent = child.getParentNode();
        if (newParent != oldParent && newParent.subtreeClones().contains(oldParent)) {
            this.moveNodeAndItsClones(child, oldParent, newIndex, newParent.isLeft(), false);
            return;
        }
        NodeModel childNode = child;
        int oldIndex = oldParent.getIndex(childNode);
        int childCount = newParent.getChildCount();
        int n = newIndex >= childCount ? (oldParent == newParent ? childCount - 1 : childCount) : (newIndex = newIndex);
        if (oldParent != newParent || oldIndex != newIndex || changeSide) {
            NodeRelativePath nodeRelativePath = this.getPathToNearestTargetClone(oldParent, newParent);
            HashSet oldParentClones = new HashSet(oldParent.subtreeClones().toCollection());
            HashSet newParentClones = new HashSet(newParent.subtreeClones().toCollection());
            NodeModel commonAncestor = nodeRelativePath.commonAncestor();
            for (NodeModel commonAncestorClone : commonAncestor.subtreeClones()) {
                NodeModel oldParentClone = nodeRelativePath.pathBegin(commonAncestorClone);
                NodeModel newParentClone = nodeRelativePath.pathEnd(commonAncestorClone);
                boolean isLeftForClone = newParentClone == newParent ? isLeft : newParentClone.isLeft();
                this.moveSingleNode(oldParentClone.getChildAt(oldIndex), newParentClone, newIndex, isLeftForClone, changeSide);
                oldParentClones.remove(oldParentClone);
                newParentClones.remove(newParentClone);
            }
            for (NodeModel newParentClone : newParentClones) {
                this.insertSingleNewNode(child.cloneTree(), newParentClone, newIndex, newParentClone.isLeft());
            }
            for (NodeModel oldParentClone : oldParentClones) {
                this.deleteSingleNode(oldParentClone, oldIndex);
            }
        }
    }

    private NodeRelativePath getPathToNearestTargetClone(NodeModel source, NodeModel target) {
        if (source == target) {
            return new NodeRelativePath(source, target);
        }
        Clones targetClones = target.subtreeClones();
        int pathNumber = targetClones.size();
        if (pathNumber == 1) {
            return new NodeRelativePath(source, target);
        }
        ArrayList<NodeRelativePath> paths = new ArrayList<NodeRelativePath>(pathNumber);
        for (NodeModel targetClone : targetClones) {
            paths.add(new NodeRelativePath(source, targetClone));
        }
        NodeRelativePath shortestPath = Collections.min(paths, new Comparator<NodeRelativePath>(){

            @Override
            public int compare(NodeRelativePath o1, NodeRelativePath o2) {
                return o1.getPathLength() - o2.getPathLength();
            }
        });
        return shortestPath;
    }

    private void moveSingleNode(final NodeModel child, final NodeModel newParent, final int newIndex, final boolean isLeft, final boolean changeSide) {
        final NodeModel oldParent = child.getParentNode();
        final int oldIndex = oldParent.getIndex(child);
        final boolean wasLeft = child.isLeft();
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.moveNodeToWithoutUndo(child, newParent, newIndex, isLeft, changeSide);
            }

            public String getDescription() {
                return "moveNode";
            }

            public void undo() {
                MMapController.this.moveNodeToWithoutUndo(child, oldParent, oldIndex, wasLeft, changeSide);
            }
        };
        Controller.getCurrentModeController().execute(actor, newParent.getMap());
    }

    public void moveNodesAsChildren(List<NodeModel> children, NodeModel target, boolean isLeft, boolean changeSide) {
        FreeNode r = (FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class);
        for (NodeModel node : children) {
            IExtension extension = node.getExtension(FreeNode.class);
            if (extension == null) continue;
            r.undoableToggleHook(node, extension);
            if (!MapStyleModel.FLOATING_STYLE.equals(LogicalStyleModel.getStyle((NodeModel)node))) continue;
            ((MLogicalStyleController)MLogicalStyleController.getController((ModeController)this.getMModeController())).setStyle(node, null);
        }
        int position = target.getChildCount();
        this.moveNodes(children, target, position, isLeft, changeSide);
    }

    public void moveNodesBefore(List<NodeModel> children, NodeModel target, boolean isLeft, boolean changeSide) {
        NodeModel newParent = target.getParentNode();
        int newIndex = newParent.getIndex(target);
        for (NodeModel node : children) {
            NodeModel childNode;
            int oldIndex;
            NodeModel oldParent = node.getParentNode();
            if (newParent.subtreeClones().contains(oldParent) && (oldIndex = oldParent.getIndex(childNode = node)) < newIndex) {
                --newIndex;
            }
            ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
        }
        this.moveNodes(children, newParent, newIndex, isLeft, changeSide);
    }

    public void moveNodesInGivenDirection(NodeModel selected, Collection<NodeModel> movedNodes, int direction) {
        Comparator<Object> comparator;
        List<NodeModel> movedNodesWithEdges = new SummaryGroupEdgeListAdder(movedNodes).addSummaryEdgeNodes();
        HashSet<NodeModel> movedNodeSet = new HashSet<NodeModel>(movedNodesWithEdges);
        Comparator<Object> comparator2 = comparator = direction == -1 ? null : new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return i2 - i1;
            }
        };
        if (movedNodeSet.size() == 0) {
            return;
        }
        NodeModel oneMovedNode = (NodeModel)movedNodeSet.iterator().next();
        NodeModel parent = oneMovedNode.getParentNode();
        if (parent != null) {
            List<NodeModel> sortedChildren = this.getSiblingsSortedOnSide(parent);
            TreeSet<Object> range = new TreeSet<Object>(comparator);
            for (NodeModel nodeModel : movedNodeSet) {
                if (nodeModel.getParentNode() != parent) {
                    LogUtils.warn((String)"Not all selected nodes have the same parent.");
                    return;
                }
                range.add(new Integer(sortedChildren.indexOf(nodeModel)));
            }
            Object last = (Integer)range.iterator().next();
            for (Object newInt : range) {
                if (Math.abs((Integer)newInt - (Integer)last) > 1) {
                    LogUtils.warn((String)"Not adjacent nodes. Skipped. ");
                    return;
                }
                last = newInt;
            }
            ArrayList arrayList = new ArrayList(this.getSelectedNodes());
            for (Integer n : range) {
                NodeModel node = sortedChildren.get(n);
                this.moveSingleNodeInGivenDirection(node, direction);
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            selection.selectAsTheOnlyOneSelected(selected);
            for (NodeModel selectedNode : arrayList) {
                selection.makeTheSelected(selectedNode);
            }
        }
    }

    private int moveSingleNodeInGivenDirection(NodeModel child, int direction) {
        int index;
        NodeModel parent = child.getParentNode();
        int newIndex = index = parent.getIndex(child);
        int maxIndex = parent.getChildCount();
        List<NodeModel> sortedOnSideNodes = this.getSiblingsSortedOnSide(parent);
        int newPositionInVector = sortedOnSideNodes.indexOf(child) + direction;
        if (newPositionInVector < 0) {
            newPositionInVector = maxIndex - 1;
        }
        if (newPositionInVector >= maxIndex) {
            newPositionInVector = 0;
        }
        NodeModel destinationNode = sortedOnSideNodes.get(newPositionInVector);
        newIndex = parent.getIndex(destinationNode);
        this.moveNodeAndItsClones(child, parent, newIndex, child.isLeft(), false);
        return newIndex;
    }

    private List<NodeModel> getSiblingsSortedOnSide(NodeModel node) {
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>(node.getChildCount());
        for (NodeModel child : Controller.getCurrentModeController().getMapController().childrenUnfolded(node)) {
            nodes.add(child);
        }
        if (!node.isRoot()) {
            return nodes;
        }
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)node.getMap());
        MapViewLayout layoutType = mapStyleModel.getMapViewLayout();
        if (layoutType.equals((Object)MapViewLayout.OUTLINE)) {
            return nodes;
        }
        Collections.sort(nodes, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof NodeModel) {
                    NodeModel n1 = (NodeModel)o1;
                    if (o2 instanceof NodeModel) {
                        NodeModel n2 = (NodeModel)o2;
                        int b1 = n1.isLeft() ? 0 : 1;
                        int b2 = n2.isLeft() ? 0 : 1;
                        return b1 - b2;
                    }
                }
                throw new IllegalArgumentException("Elements in LeftRightComparator are not comparable.");
            }
        });
        return nodes;
    }

    private int moveNodeToWithoutUndo(NodeModel child, NodeModel newParent, int newIndex, boolean isLeft, boolean changeSide) {
        NodeModel oldParent = child.getParentNode();
        int oldIndex = oldParent.getIndex(child);
        boolean oldSideLeft = child.isLeft();
        boolean newSideLeft = changeSide ? isLeft : oldSideLeft;
        NodeMoveEvent nodeMoveEvent = new NodeMoveEvent(oldParent, oldIndex, oldSideLeft, newParent, child, newIndex, newSideLeft);
        this.firePreNodeMoved(nodeMoveEvent);
        oldParent.remove(oldParent.getIndex(child));
        if (changeSide) {
            child.setParent(newParent);
            child.setLeft(isLeft);
        }
        newParent.insert(child, newIndex);
        this.fireNodeMoved(nodeMoveEvent);
        this.setSaved(newParent.getMap(), false);
        return newIndex;
    }

    public MapModel newModel(NodeModel existingNode) {
        if (existingNode == null) {
            throw new NullPointerException("null node not allowed.");
        }
        MMapModel mindMapMapModel = new MMapModel();
        mindMapMapModel.setRoot(existingNode);
        mindMapMapModel.registryNodeRecursive(existingNode);
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    public MapModel newModel() {
        MMapModel mindMapMapModel = new MMapModel();
        mindMapMapModel.createNewRoot();
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    public void setSaved(MapModel mapModel, boolean saved) {
        boolean setTitle = saved != mapModel.isSaved() || mapModel.isReadOnly();
        mapModel.setSaved(saved);
        if (setTitle) {
            Controller controller = Controller.getCurrentController();
            controller.getMapViewManager().setMapTitles();
            AFreeplaneAction saveAction = controller.getModeController().getAction("SaveAction");
            if (saveAction != null) {
                saveAction.setEnabled();
            }
        }
    }

    public NodeModel addFreeNode(Point pt, boolean newNodeIsLeft) {
        NodeModel target;
        NodeModel targetNode;
        boolean parentFolded;
        ModeController modeController = Controller.getCurrentModeController();
        final TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopEditing();
            modeController.forceNewTransaction();
        }
        if (parentFolded = this.isFolded(targetNode = (target = this.getRootNode()))) {
            this.setFolded(targetNode, false);
        }
        if (!this.isWriteable(target)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return null;
        }
        final NodeModel newNode = this.newNode("", target.getMap());
        LogicalStyleModel.createExtension((NodeModel)newNode).setStyle(MapStyleModel.FLOATING_STYLE);
        newNode.addExtension(modeController.getExtension(FreeNode.class));
        if (!this.addNewNode(newNode, target, target.getChildCount(), newNodeIsLeft)) {
            return null;
        }
        Quantity x = LengthUnits.pixelsInPt((double)pt.x);
        Quantity y = LengthUnits.pixelsInPt((double)pt.y);
        ((MLocationController)MLocationController.getController((ModeController)modeController)).moveNodePosition(newNode, (Quantity<LengthUnits>)x, (Quantity<LengthUnits>)y);
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return newNode;
        }
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                ((MTextController)textController).edit(newNode, targetNode, true, false, false);
            }
        });
        this.select(newNode);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean newUntitledMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MMapModel newModel = new MMapModel();
            UrlManager.getController().load(url, (MapModel)newModel);
            newModel.setURL(null);
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean newMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        MFileManager fileManager;
        if (this.getMModeController().containsExtension(DocuMapAttribute.class)) {
            return this.newDocumentationMap(url);
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return false;
        }
        if (AddOnsController.getController().installIfAppropriate(url)) {
            return false;
        }
        URL alternativeURL = null;
        try {
            File file = Compat.urlToFile((URL)url);
            if (file == null) {
                alternativeURL = url;
            } else if (file.exists()) {
                fileManager = MFileManager.getController(this.getMModeController());
                File alternativeFile = fileManager.getAlternativeFile(file, MFileManager.AlternativeFileMode.AUTOSAVE);
                if (alternativeFile == null) return false;
                alternativeURL = alternativeFile.getAbsoluteFile().equals(file.getAbsoluteFile()) ? url : Compat.fileToUrl((File)alternativeFile);
            } else {
                alternativeURL = url;
            }
        }
        catch (MalformedURLException file) {
        }
        catch (URISyntaxException file) {
            // empty catch block
        }
        if (alternativeURL == null) {
            return false;
        }
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        try {
            MMapModel newModel = new MMapModel();
            fileManager = MFileManager.getController(this.getMModeController());
            fileManager.loadAndLock(alternativeURL, newModel);
            newModel.setURL(url);
            newModel.setSaved(alternativeURL.equals(url));
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    public void newDocumentationMap(String file) {
        block7: {
            NodeAndMapReference nodeAndMapReference = new NodeAndMapReference(file);
            ResourceController resourceController = ResourceController.getResourceController();
            File userDir = new File(resourceController.getFreeplaneUserDirectory());
            File baseDir = new File(resourceController.getInstallationBaseDir());
            String languageCode = resourceController.getLanguageCode();
            File localFile = ConfigurationUtils.getLocalizedFile((File[])new File[]{userDir, baseDir}, (String)nodeAndMapReference.getMapReference(), (String)languageCode);
            if (localFile == null) {
                String errorMessage = TextUtils.format((String)"invalid_file_msg", (Object[])new Object[]{file});
                UITools.errorMessage((Object)errorMessage);
                return;
            }
            try {
                URL endUrl = localFile.toURL();
                try {
                    if (endUrl.getFile().endsWith(".mm")) {
                        Controller.getCurrentController().selectMode("MindMap");
                        this.newDocumentationMap(endUrl);
                        if (nodeAndMapReference.hasNodeReference()) {
                            this.select(nodeAndMapReference.getNodeReference());
                        }
                        break block7;
                    }
                    Controller.getCurrentController().getViewController().openDocument(endUrl);
                }
                catch (Exception e1) {
                    LogUtils.severe((Throwable)e1);
                }
            }
            catch (MalformedURLException e1) {
                LogUtils.warn((Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean newDocumentationMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return false;
        }
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MMapModel newModel = new MMapModel();
            newModel.addExtension(DocuMapAttribute.instance);
            UrlManager.getController().load(url, (MapModel)newModel);
            newModel.setReadOnly(true);
            this.fireMapCreated(newModel);
            this.newMapView(newModel);
            newModel.setSaved(true);
            boolean bl = true;
            return bl;
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean restoreCurrentMap() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        URL url = map.getURL();
        if (url == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"map_not_saved"));
            return false;
        }
        if (map.containsExtension(DocuMapAttribute.class)) {
            this.closeWithoutSaving(map);
            return this.newDocumentationMap(url);
        }
        URL alternativeURL = MFileManager.getController(this.getMModeController()).getAlternativeURL(url, MFileManager.AlternativeFileMode.ALL);
        if (alternativeURL == null) {
            return false;
        }
        controller.getViewController().setWaitingCursor(true);
        try {
            MMapModel newModel = new MMapModel();
            ((MFileManager)MFileManager.getController()).loadAndLock(alternativeURL, newModel);
            newModel.setURL(url);
            newModel.setSaved(alternativeURL.equals(url));
            this.fireMapCreated(newModel);
            this.closeWithoutSaving(map);
            this.newMapView(newModel);
            boolean bl = true;
            return bl;
        }
        finally {
            controller.getViewController().setWaitingCursor(false);
        }
    }

    protected void setFoldingState(final NodeModel node, final boolean folded) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        final boolean wasFolded = mapViewManager.isFoldedOnCurrentView(node);
        if (wasFolded == folded && mapViewManager.getComponent(node) == null) {
            return;
        }
        if (this.isFoldingPersistent()) {
            IActor foldingActor = new IActor(){

                public void undo() {
                    MMapController.this.unfoldHiddenChildren(node);
                    MMapController.super.setFoldingState(node, wasFolded);
                }

                public String getDescription() {
                    return "setFoldingState";
                }

                public void act() {
                    MMapController.this.unfoldHiddenChildren(node);
                    MMapController.super.setFoldingState(node, folded);
                }
            };
            this.getMModeController().execute(foldingActor, node.getMap());
        } else {
            super.setFoldingState(node, folded);
        }
    }

    private boolean isFoldingPersistent() {
        ResourceController resourceController = ResourceController.getResourceController();
        return foldingSavedOptions.contains(resourceController.getProperty("save_folding"));
    }
}

