/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mapio.mindmapmode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mapio.MapIO;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MMapIO
extends MapIO {
    private final MFileManager fileManager;
    private final MMapController mapController;

    private MMapIO(MFileManager urlManager, MMapController mapController) {
        super((UrlManager)urlManager, (MapController)mapController);
        this.fileManager = urlManager;
        this.mapController = mapController;
    }

    public static void install(MModeController modeController) {
        MFileManager urlManager = (MFileManager)modeController.getExtension(UrlManager.class);
        MMapController mapController = (MMapController)modeController.getMapController();
        MMapIO mapIO = new MMapIO(urlManager, mapController);
        modeController.addExtension(MapIO.class, (IExtension)mapIO);
    }

    public void load(URL url, MapModel map) throws FileNotFoundException, IOException, XMLException, XMLParseException, URISyntaxException {
        this.fileManager.load(url, map);
    }

    public boolean loadCatchExceptions(URL url, MapModel map) {
        return this.fileManager.loadCatchExceptions(url, map);
    }

    public void loadSafeAndLock(URL url, MapModel map) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        this.fileManager.loadAndLock(url, map);
    }

    public void open() {
        this.fileManager.open();
    }

    public MapModel newMapFromTemplate(File startFile) {
        return this.fileManager.newMapFromTemplate(startFile);
    }

    public void saveAsUserTemplate() {
        this.fileManager.saveAsUserTemplate();
    }

    public boolean save(MapModel map) {
        return this.fileManager.save(map);
    }

    public boolean save(MapModel map, File file) {
        return this.fileManager.save(map, file);
    }

    public boolean saveAs(MapModel map) {
        return this.fileManager.saveAs(map);
    }

    public void writeToFile(MapModel map, File file) throws FileNotFoundException, IOException {
        this.fileManager.writeToFile(map, file);
    }

    public String tryToLock(MapModel map, File file) throws Exception {
        return this.fileManager.tryToLock(map, file);
    }

    public NodeModel loadTree(MapModel map, File file) throws XMLParseException, IOException {
        return this.fileManager.loadTree(map, file);
    }

    public MapModel newMapFromDefaultTemplate() {
        return this.fileManager.newMapFromDefaultTemplate();
    }

    public boolean newUntitledMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        return this.mapController.newUntitledMap(url);
    }

    public boolean newMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        return this.mapController.newMap(url);
    }

    public boolean newDocumentationMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        return this.mapController.newDocumentationMap(url);
    }

    public boolean restoreCurrentMap() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        return this.mapController.restoreCurrentMap();
    }
}

